/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import java.io.File;
import java.io.PrintWriter;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.utils.AbstractRangerAuditWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerJSONAuditWriter
extends AbstractRangerAuditWriter {
    private static final Logger logger = LoggerFactory.getLogger(RangerJSONAuditWriter.class);
    public static final String PROP_HDFS_ROLLOVER_ENABLE_PERIODIC_ROLLOVER = "file.rollover.enable.periodic.rollover";
    public static final String PROP_HDFS_ROLLOVER_PERIODIC_ROLLOVER_CHECK_TIME = "file.rollover.periodic.rollover.check.sec";
    protected String JSON_FILE_EXTENSION = ".log";
    private boolean enableAuditFilePeriodicRollOver = false;
    private long periodicRollOverCheckTimeinSec;

    @Override
    public void init(Properties props, String propPrefix, String auditProviderName, Map<String, String> auditConfigs) {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerJSONAuditWriter.init()");
        }
        this.init();
        super.init(props, propPrefix, auditProviderName, auditConfigs);
        this.enableAuditFilePeriodicRollOver = MiscUtil.getBooleanProperty(props, propPrefix + "." + PROP_HDFS_ROLLOVER_ENABLE_PERIODIC_ROLLOVER, false);
        if (this.enableAuditFilePeriodicRollOver) {
            this.periodicRollOverCheckTimeinSec = MiscUtil.getLongProperty(props, propPrefix + "." + PROP_HDFS_ROLLOVER_PERIODIC_ROLLOVER_CHECK_TIME, 60L);
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("rolloverPeriod: " + this.rolloverPeriod + " nextRollOverTime: " + this.nextRollOverTime + " periodicRollOverTimeinSec: " + this.periodicRollOverCheckTimeinSec);
                }
                this.startAuditFilePeriodicRollOverTask();
            }
            catch (Exception e) {
                logger.warn("Error enabling audit file perodic rollover..! Default behavior will be");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerJSONAuditWriter.init()");
        }
    }

    public void init() {
        this.setFileExtension(this.JSON_FILE_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean logJSON(final Collection<String> events) throws Exception {
        boolean ret = false;
        PrintWriter out = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("UGI=" + MiscUtil.getUGILoginUser() + ". Will write to HDFS file=" + this.currentFileName);
            }
            if ((out = MiscUtil.executePrivilegedAction(new PrivilegedExceptionAction<PrintWriter>(){

                @Override
                public PrintWriter run() throws Exception {
                    PrintWriter out = RangerJSONAuditWriter.this.getLogFileStream();
                    for (String event : events) {
                        out.println(event);
                    }
                    return out;
                }
            })).checkError()) {
                out.close();
                this.closeWriter();
                boolean bl = ret;
                return bl;
            }
        }
        catch (Exception e) {
            if (out != null) {
                out.close();
            }
            this.closeWriter();
            boolean bl = ret;
            return bl;
        }
        finally {
            ret = true;
            if (logger.isDebugEnabled()) {
                logger.debug("Flushing HDFS audit. Event Size:" + events.size());
            }
            if (out != null) {
                out.flush();
            }
        }
        return ret;
    }

    @Override
    public boolean log(Collection<String> events) throws Exception {
        return this.logJSON(events);
    }

    public synchronized boolean logAsFile(final File file) throws Exception {
        boolean ret = false;
        if (logger.isDebugEnabled()) {
            logger.debug("UGI=" + MiscUtil.getUGILoginUser() + ". Will write to HDFS file=" + this.currentFileName);
        }
        Boolean retVal = MiscUtil.executePrivilegedAction(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                boolean ret = RangerJSONAuditWriter.this.logFileToHDFS(file);
                return ret;
            }
        });
        ret = retVal;
        logger.info("Flushing HDFS audit File :" + file.getAbsolutePath() + file.getName());
        return ret;
    }

    @Override
    public boolean logFile(File file) throws Exception {
        return this.logAsFile(file);
    }

    public synchronized PrintWriter getLogFileStream() throws Exception {
        if (!this.enableAuditFilePeriodicRollOver) {
            this.closeFileIfNeeded();
        }
        PrintWriter logWriter = this.createWriter();
        return logWriter;
    }

    @Override
    public void flush() {
        if (logger.isDebugEnabled()) {
            logger.debug("==> JSONWriter.flush()");
        }
        logger.info("Flush called. name=" + this.auditProviderName);
        super.flush();
        if (logger.isDebugEnabled()) {
            logger.debug("<== JSONWriter.flush()");
        }
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized void stop() {
        if (logger.isDebugEnabled()) {
            logger.debug("==> JSONWriter.stop()");
        }
        if (this.logWriter != null) {
            try {
                this.logWriter.flush();
                this.logWriter.close();
            }
            catch (Throwable t) {
                logger.error("Error on closing log writter. Exception will be ignored. name=" + this.auditProviderName + ", fileName=" + this.currentFileName);
            }
            this.logWriter = null;
            this.ostream = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== JSONWriter.stop()");
        }
    }

    private void startAuditFilePeriodicRollOverTask() {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new AuditFilePeriodicRollOverTaskThreadFactory());
        if (logger.isDebugEnabled()) {
            logger.debug("HDFSAuditDestination.startAuditFilePeriodicRollOverTask() strated..Audit File rollover happens every " + this.rolloverPeriod);
        }
        executorService.scheduleAtFixedRate(new AuditFilePeriodicRollOverTask(), 0L, this.periodicRollOverCheckTimeinSec, TimeUnit.SECONDS);
    }

    private class AuditFilePeriodicRollOverTask
    implements Runnable {
        private AuditFilePeriodicRollOverTask() {
        }

        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug("==> AuditFilePeriodicRollOverTask.run()");
            }
            try {
                RangerJSONAuditWriter.this.closeFileIfNeeded();
            }
            catch (Exception excp) {
                logger.error("AuditFilePeriodicRollOverTask Failed. Aborting..", (Throwable)excp);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("<== AuditFilePeriodicRollOverTask.run()");
            }
        }
    }

    class AuditFilePeriodicRollOverTaskThreadFactory
    implements ThreadFactory {
        AuditFilePeriodicRollOverTaskThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "AuditFilePeriodicRollOverTask");
            t.setDaemon(true);
            return t;
        }
    }
}

