/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap.plugins;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.elasticsearch.bootstrap.plugins.LoggerTerminal;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.PluginsSynchronizer;

public class PluginsManager {
    public static final String SYNC_PLUGINS_ACTION = "org.elasticsearch.plugins.cli.SyncPluginsAction";

    public static boolean configExists(Environment env) {
        return Files.exists(env.configFile().resolve("elasticsearch-plugins.yml"), new LinkOption[0]);
    }

    public static void syncPlugins(Environment env) throws Exception {
        ClassLoader classLoader = PluginsManager.buildClassLoader(env);
        Class<?> synchronizerClass = classLoader.loadClass(SYNC_PLUGINS_ACTION);
        PluginsSynchronizer provider = (PluginsSynchronizer)synchronizerClass.getConstructor(Terminal.class, Environment.class).newInstance(new Object[]{LoggerTerminal.getLogger(SYNC_PLUGINS_ACTION), env});
        provider.execute();
    }

    private static ClassLoader buildClassLoader(Environment env) {
        Path pluginLibDir = env.libFile().resolve("tools").resolve("plugin-cli");
        try {
            URL[] urls = (URL[])Files.list(pluginLibDir).filter(each -> each.getFileName().toString().endsWith(".jar")).map(PluginsManager::pathToURL).toArray(URL[]::new);
            return URLClassLoader.newInstance(urls, PluginsManager.class.getClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to list jars in [" + pluginLibDir + "]: " + e.getMessage(), e);
        }
    }

    private static URL pathToURL(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to convert path [" + path + "] to URL", e);
        }
    }
}

