/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.ranger.plugin.model.RangerPolicy;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RangerPolicyDelta
implements Serializable {
    public static final int CHANGE_TYPE_POLICY_CREATE = 0;
    public static final int CHANGE_TYPE_POLICY_UPDATE = 1;
    public static final int CHANGE_TYPE_POLICY_DELETE = 2;
    public static final int CHANGE_TYPE_SERVICE_CHANGE = 3;
    public static final int CHANGE_TYPE_SERVICE_DEF_CHANGE = 4;
    public static final int CHANGE_TYPE_RANGER_ADMIN_START = 5;
    public static final int CHANGE_TYPE_LOG_ERROR = 6;
    public static final int CHANGE_TYPE_INVALIDATE_POLICY_DELTAS = 7;
    public static final int CHANGE_TYPE_ROLE_UPDATE = 8;
    private static String[] changeTypeNames = new String[]{"POLICY_CREATE", "POLICY_UPDATE", "POLICY_DELETE", "SERVICE_CHANGE", "SERVICE_DEF_CHANGE", "RANGER_ADMIN_START", "LOG_ERROR", "INVALIDATE_POLICY_DELTAS", "ROLE_UPDATE"};
    private Long id;
    private Integer changeType;
    private Long policiesVersion;
    private RangerPolicy policy;

    public RangerPolicyDelta() {
        this(null, null, null, null);
    }

    public RangerPolicyDelta(Long id, Integer changeType, Long policiesVersion, RangerPolicy policy) {
        this.setId(id);
        this.setChangeType(changeType);
        this.setPoliciesVersion(policiesVersion);
        this.setPolicy(policy);
    }

    public Long getId() {
        return this.id;
    }

    public Integer getChangeType() {
        return this.changeType;
    }

    public Long getPoliciesVersion() {
        return this.policiesVersion;
    }

    @JsonIgnore
    public String getServiceType() {
        return this.policy != null ? this.policy.getServiceType() : null;
    }

    @JsonIgnore
    public Integer getPolicyType() {
        return this.policy != null ? this.policy.getPolicyType() : null;
    }

    @JsonIgnore
    public Long getPolicyId() {
        return this.policy != null ? this.policy.getId() : null;
    }

    @JsonIgnore
    public String getZoneName() {
        return this.policy != null ? this.policy.getZoneName() : null;
    }

    public RangerPolicy getPolicy() {
        return this.policy;
    }

    public void setId(Long id) {
        this.id = id;
    }

    private void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    private void setPoliciesVersion(Long policiesVersion) {
        this.policiesVersion = policiesVersion;
    }

    public void setPolicy(RangerPolicy policy) {
        this.policy = policy;
    }

    public void dedupStrings(Map<String, String> strTbl) {
        if (this.policy != null) {
            this.policy.dedupStrings(strTbl);
        }
    }

    public String toString() {
        return "id:" + this.id + ", changeType:" + changeTypeNames[this.changeType] + ", policiesVersion:" + this.getPoliciesVersion() + ", serviceType:" + this.getServiceType() + ", policyType:" + this.getPolicyType() + ", policyId:[" + this.getPolicyId() + "], policy:[" + this.policy + "]";
    }
}

