/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.general.GeneralDigestAlgorithm;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.Mac;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Register {
    private Register() {
    }

    static Digest createDigest(Algorithm algorithm) {
        if (algorithm instanceof FipsAlgorithm) {
            return (Digest)FipsRegister.getProvider((FipsAlgorithm)algorithm).createEngine();
        }
        return SecureHash.createDigest((GeneralDigestAlgorithm)algorithm);
    }

    static Mac createHMac(Algorithm algorithm) {
        if (algorithm instanceof FipsAlgorithm) {
            return (Mac)FipsRegister.getProvider((FipsAlgorithm)algorithm).createEngine();
        }
        return SecureHash.createHMac((GeneralDigestAlgorithm)algorithm);
    }
}

