/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyGenerator;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.pqc.jcajce.interfaces.MLKEMPublicKey;
import org.bouncycastle.pqc.jcajce.spec.MLKEMParameterSpec;
import org.bouncycastle.pqc.jcajce.spec.MLKEMPublicKeySpec;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCryptoProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class KemUtil {
    static JcaTlsCrypto kemCrypto = null;
    static final ASN1ObjectIdentifier nistAlgorithm = new ASN1ObjectIdentifier("2.16.840.1.101.3.4");
    static final ASN1ObjectIdentifier kems = nistAlgorithm.branch("4");
    static final ASN1ObjectIdentifier id_alg_ml_kem_512 = kems.branch("1");
    static final ASN1ObjectIdentifier id_alg_ml_kem_768 = kems.branch("2");
    static final ASN1ObjectIdentifier id_alg_ml_kem_1024 = kems.branch("3");

    KemUtil() {
    }

    private static synchronized void makeKemCrypto(JcaTlsCrypto jcaTlsCrypto) {
        if (kemCrypto == null) {
            try {
                kemCrypto = new JcaTlsCrypto((JcaJceHelper)new NamedJcaJceHelper("BCPQC"), jcaTlsCrypto.getSecureRandom(), new JcaTlsCryptoProvider.NonceEntropySource(jcaTlsCrypto.getHelper(), jcaTlsCrypto.getSecureRandom()));
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IllegalStateException("cannot use passed in crypto with KEM");
            }
            catch (Exception exception) {
                throw new IllegalStateException("BCPQC provider not present");
            }
        }
    }

    static PublicKey decodePublicKey(JcaTlsCrypto jcaTlsCrypto, String string, byte[] byArray) throws TlsFatalAlert {
        try {
            KemUtil.makeKemCrypto(jcaTlsCrypto);
            KeyFactory keyFactory = kemCrypto.getHelper().createKeyFactory(string);
            if (keyFactory.getProvider().getName().equals("BCPQC")) {
                try {
                    MLKEMParameterSpec mLKEMParameterSpec = MLKEMParameterSpec.fromName((String)string);
                    MLKEMPublicKeySpec mLKEMPublicKeySpec = new MLKEMPublicKeySpec(mLKEMParameterSpec, byArray);
                    return keyFactory.generatePublic((KeySpec)mLKEMPublicKeySpec);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            X509EncodedKeySpec x509EncodedKeySpec = KemUtil.createX509EncodedKeySpec(KemUtil.getAlgorithmOID(string), byArray);
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(47, (Throwable)exception);
        }
    }

    static byte[] encodePublicKey(PublicKey publicKey) throws TlsFatalAlert {
        if (publicKey instanceof MLKEMPublicKey) {
            return ((MLKEMPublicKey)publicKey).getPublicData();
        }
        if (!"X.509".equals(publicKey.getFormat())) {
            throw new TlsFatalAlert(80, "Public key format unrecognized");
        }
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            return subjectPublicKeyInfo.getPublicKeyData().getOctets();
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(80, (Throwable)exception);
        }
    }

    static KeyFactory getKeyFactory(JcaTlsCrypto jcaTlsCrypto, String string) {
        try {
            KemUtil.makeKemCrypto(jcaTlsCrypto);
            return kemCrypto.getHelper().createKeyFactory(string);
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static KeyGenerator getKeyGenerator(JcaTlsCrypto jcaTlsCrypto, String string) {
        try {
            KemUtil.makeKemCrypto(jcaTlsCrypto);
            return kemCrypto.getHelper().createKeyGenerator(string);
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static KeyPairGenerator getKeyPairGenerator(JcaTlsCrypto jcaTlsCrypto, String string) {
        try {
            KemUtil.makeKemCrypto(jcaTlsCrypto);
            KeyPairGenerator keyPairGenerator = kemCrypto.getHelper().createKeyPairGenerator("ML-KEM");
            keyPairGenerator.initialize((AlgorithmParameterSpec)MLKEMParameterSpec.fromName((String)string), kemCrypto.getSecureRandom());
            return keyPairGenerator;
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static boolean isKemSupported(JcaTlsCrypto jcaTlsCrypto, String string) {
        return string != null && KemUtil.getKeyFactory(jcaTlsCrypto, string) != null && KemUtil.getKeyGenerator(jcaTlsCrypto, string) != null && KemUtil.getKeyPairGenerator(jcaTlsCrypto, string) != null;
    }

    private static X509EncodedKeySpec createX509EncodedKeySpec(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier);
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, byArray);
        return new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded("DER"));
    }

    private static ASN1ObjectIdentifier getAlgorithmOID(String string) {
        if ("ML-KEM-512".equalsIgnoreCase(string)) {
            return id_alg_ml_kem_512;
        }
        if ("ML-KEM-768".equalsIgnoreCase(string)) {
            return id_alg_ml_kem_768;
        }
        if ("ML-KEM-1024".equalsIgnoreCase(string)) {
            return id_alg_ml_kem_1024;
        }
        throw new IllegalArgumentException("unknown kem name " + string);
    }
}

