/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JcaTlsRSAVerifier
implements TlsVerifier {
    private final JcaTlsCrypto crypto;
    private final PublicKey publicKey;
    private Signature rawVerifier = null;

    public JcaTlsRSAVerifier(JcaTlsCrypto jcaTlsCrypto, PublicKey publicKey) {
        if (null == jcaTlsCrypto) {
            throw new NullPointerException("crypto");
        }
        if (null == publicKey) {
            throw new NullPointerException("publicKey");
        }
        this.crypto = jcaTlsCrypto;
        this.publicKey = publicKey;
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm != null && signatureAndHashAlgorithm.getSignature() == 1 && JcaUtils.isSunMSCAPIProviderActive() && this.isSunMSCAPIRawVerifier()) {
            return this.crypto.createStreamVerifier(digitallySigned, this.publicKey);
        }
        return null;
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        try {
            Signature signature = this.getRawVerifier();
            if (signatureAndHashAlgorithm != null) {
                if (signatureAndHashAlgorithm.getSignature() != 1) {
                    throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
                }
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(TlsUtils.getOIDForHashAlgorithm(signatureAndHashAlgorithm.getHash()), (ASN1Encodable)DERNull.INSTANCE);
                byte[] byArray2 = new DigestInfo(algorithmIdentifier, byArray).getEncoded("DER");
                signature.update(byArray2, 0, byArray2.length);
            } else {
                signature.update(byArray, 0, byArray.length);
            }
            return signature.verify(digitallySigned.getSignature());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalStateException("unable to process signature: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    protected Signature getRawVerifier() throws GeneralSecurityException {
        if (this.rawVerifier == null) {
            this.rawVerifier = this.crypto.getHelper().createSignature("NoneWithRSA");
            this.rawVerifier.initVerify(this.publicKey);
        }
        return this.rawVerifier;
    }

    protected boolean isSunMSCAPIRawVerifier() throws IOException {
        try {
            Signature signature = this.getRawVerifier();
            return JcaUtils.isSunMSCAPIProvider(signature.getProvider());
        }
        catch (GeneralSecurityException generalSecurityException) {
            return true;
        }
    }
}

