/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SignatureScheme {
    public static final int rsa_pkcs1_sha1 = 513;
    public static final int ecdsa_sha1 = 515;
    public static final int rsa_pkcs1_sha256 = 1025;
    public static final int rsa_pkcs1_sha384 = 1281;
    public static final int rsa_pkcs1_sha512 = 1537;
    public static final int ecdsa_secp256r1_sha256 = 1027;
    public static final int ecdsa_secp384r1_sha384 = 1283;
    public static final int ecdsa_secp521r1_sha512 = 1539;
    public static final int rsa_pss_rsae_sha256 = 2052;
    public static final int rsa_pss_rsae_sha384 = 2053;
    public static final int rsa_pss_rsae_sha512 = 2054;
    public static final int ed25519 = 2055;
    public static final int ed448 = 2056;
    public static final int rsa_pss_pss_sha256 = 2057;
    public static final int rsa_pss_pss_sha384 = 2058;
    public static final int rsa_pss_pss_sha512 = 2059;
    public static final int ecdsa_brainpoolP256r1tls13_sha256 = 2074;
    public static final int ecdsa_brainpoolP384r1tls13_sha384 = 2075;
    public static final int ecdsa_brainpoolP512r1tls13_sha512 = 2076;
    public static final int sm2sig_sm3 = 1800;
    public static final int mldsa44 = 2308;
    public static final int mldsa65 = 2309;
    public static final int mldsa87 = 2310;
    public static final int DRAFT_mldsa44 = 2308;
    public static final int DRAFT_mldsa65 = 2309;
    public static final int DRAFT_mldsa87 = 2310;

    public static int from(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (null == signatureAndHashAlgorithm) {
            throw new NullPointerException();
        }
        return SignatureScheme.from(signatureAndHashAlgorithm.getHash(), signatureAndHashAlgorithm.getSignature());
    }

    public static int from(short s, short s2) {
        return (s & 0xFF) << 8 | s2 & 0xFF;
    }

    public static int getCryptoHashAlgorithm(int n) {
        switch (n) {
            case 2055: 
            case 2056: 
            case 2308: 
            case 2309: 
            case 2310: {
                return -1;
            }
            case 2052: 
            case 2057: 
            case 2074: {
                return 4;
            }
            case 2053: 
            case 2058: 
            case 2075: {
                return 5;
            }
            case 2054: 
            case 2059: 
            case 2076: {
                return 6;
            }
            case 1800: {
                return 7;
            }
        }
        short s = SignatureScheme.getHashAlgorithm(n);
        if (8 == s || !HashAlgorithm.isRecognized(s)) {
            return -1;
        }
        return TlsCryptoUtils.getHash(s);
    }

    public static int getCryptoHashAlgorithm(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        return SignatureScheme.getCryptoHashAlgorithm(SignatureScheme.from(signatureAndHashAlgorithm));
    }

    public static String getName(int n) {
        switch (n) {
            case 513: {
                return "rsa_pkcs1_sha1";
            }
            case 515: {
                return "ecdsa_sha1";
            }
            case 1025: {
                return "rsa_pkcs1_sha256";
            }
            case 1281: {
                return "rsa_pkcs1_sha384";
            }
            case 1537: {
                return "rsa_pkcs1_sha512";
            }
            case 1027: {
                return "ecdsa_secp256r1_sha256";
            }
            case 1283: {
                return "ecdsa_secp384r1_sha384";
            }
            case 1539: {
                return "ecdsa_secp521r1_sha512";
            }
            case 2052: {
                return "rsa_pss_rsae_sha256";
            }
            case 2053: {
                return "rsa_pss_rsae_sha384";
            }
            case 2054: {
                return "rsa_pss_rsae_sha512";
            }
            case 2055: {
                return "ed25519";
            }
            case 2056: {
                return "ed448";
            }
            case 2057: {
                return "rsa_pss_pss_sha256";
            }
            case 2058: {
                return "rsa_pss_pss_sha384";
            }
            case 2059: {
                return "rsa_pss_pss_sha512";
            }
            case 2074: {
                return "ecdsa_brainpoolP256r1tls13_sha256";
            }
            case 2075: {
                return "ecdsa_brainpoolP384r1tls13_sha384";
            }
            case 2076: {
                return "ecdsa_brainpoolP512r1tls13_sha512";
            }
            case 1800: {
                return "sm2sig_sm3";
            }
            case 2308: {
                return "mldsa44";
            }
            case 2309: {
                return "mldsa65";
            }
            case 2310: {
                return "mldsa87";
            }
        }
        return "UNKNOWN";
    }

    public static int getNamedGroup(int n) {
        switch (n) {
            case 2074: {
                return 31;
            }
            case 2075: {
                return 32;
            }
            case 2076: {
                return 33;
            }
            case 1027: {
                return 23;
            }
            case 1283: {
                return 24;
            }
            case 1539: {
                return 25;
            }
            case 1800: {
                return 41;
            }
        }
        return -1;
    }

    @Deprecated
    public static int getRSAPSSCryptoHashAlgorithm(int n) {
        switch (n) {
            case 2052: 
            case 2057: {
                return 4;
            }
            case 2053: 
            case 2058: {
                return 5;
            }
            case 2054: 
            case 2059: {
                return 6;
            }
        }
        return -1;
    }

    public static short getHashAlgorithm(int n) {
        return (short)(n >>> 8 & 0xFF);
    }

    public static short getSignatureAlgorithm(int n) {
        return (short)(n & 0xFF);
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(int n) {
        switch (n) {
            case 2055: {
                return SignatureAndHashAlgorithm.ed25519;
            }
            case 2056: {
                return SignatureAndHashAlgorithm.ed448;
            }
            case 2308: {
                return SignatureAndHashAlgorithm.mldsa44;
            }
            case 2309: {
                return SignatureAndHashAlgorithm.mldsa65;
            }
            case 2310: {
                return SignatureAndHashAlgorithm.mldsa87;
            }
        }
        return SignatureAndHashAlgorithm.getInstance(SignatureScheme.getHashAlgorithm(n), SignatureScheme.getSignatureAlgorithm(n));
    }

    public static String getText(int n) {
        return SignatureScheme.getName(n) + "(0x" + Integer.toHexString(n) + ")";
    }

    public static boolean isPrivate(int n) {
        return n >>> 9 == 254;
    }

    public static boolean isECDSA(int n) {
        switch (n) {
            case 2074: 
            case 2075: 
            case 2076: {
                return true;
            }
        }
        return 3 == SignatureScheme.getSignatureAlgorithm(n);
    }

    public static boolean isMLDSA(int n) {
        switch (n) {
            case 2308: 
            case 2309: 
            case 2310: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRSAPSS(int n) {
        switch (n) {
            case 2052: 
            case 2053: 
            case 2054: 
            case 2057: 
            case 2058: 
            case 2059: {
                return true;
            }
        }
        return false;
    }
}

