/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.UserGroupMapping;
import org.apache.hadoop.util.StringUtils;

public class UsersACLsManager {
    private Map<String, UserGroupMapping> usersAclMapping = new HashMap<String, UserGroupMapping>();
    private Map<String, UserGroupMapping> groupAclMapping = new HashMap<String, UserGroupMapping>();
    private Map<String, UserGroupMapping> invertedUsersAclMapping = new HashMap<String, UserGroupMapping>();
    private Map<String, UserGroupMapping> invertedGroupAclMapping = new HashMap<String, UserGroupMapping>();

    public UsersACLsManager(Configuration conf) {
        String userACLs = conf.get("hadoop.users.acl.mapping", "").trim();
        if (!userACLs.isEmpty()) {
            this.parseMapping(userACLs);
        }
    }

    private void parseMapping(String userACLs) {
        Collection<String> mappingParts = StringUtils.getStringCollection(userACLs, ";");
        for (String part : mappingParts) {
            UserGroupMapping userGroupValue;
            String[] mappingPart = StringUtils.getStrings(part.trim(), "=");
            if (mappingPart == null || mappingPart.length != 2) {
                throw new HadoopIllegalArgumentException("Configuration yarn.users.acl.mapping is invalid");
            }
            Map<UserGroupMapping.EntityType, List<String>> reqLists = UsersACLsManager.parseUserGroupLists(mappingPart[0]);
            Map<UserGroupMapping.EntityType, List<String>> mapLists = UsersACLsManager.parseUserGroupLists(mappingPart[1]);
            for (String userName : reqLists.get((Object)UserGroupMapping.EntityType.USER)) {
                userGroupValue = new UserGroupMapping(UserGroupMapping.EntityType.USER, userName, mapLists.get((Object)UserGroupMapping.EntityType.USER), mapLists.get((Object)UserGroupMapping.EntityType.GROUP));
                this.usersAclMapping.put(userName, userGroupValue);
            }
            for (String groupName : reqLists.get((Object)UserGroupMapping.EntityType.GROUP)) {
                userGroupValue = new UserGroupMapping(UserGroupMapping.EntityType.GROUP, groupName, mapLists.get((Object)UserGroupMapping.EntityType.USER), mapLists.get((Object)UserGroupMapping.EntityType.GROUP));
                this.groupAclMapping.put(groupName, userGroupValue);
            }
        }
        this.invertAclMappring(this.usersAclMapping);
        this.invertAclMappring(this.groupAclMapping);
    }

    private void invertAclMappring(Map<String, UserGroupMapping> mapAclMapping) {
        for (Map.Entry<String, UserGroupMapping> userSet : mapAclMapping.entrySet()) {
            List<String> ownerUserList = userSet.getValue().getUserList();
            for (String ownerUser : ownerUserList) {
                if (this.invertedUsersAclMapping.get(ownerUser) != null) {
                    if (userSet.getValue().getType().equals((Object)UserGroupMapping.EntityType.USER)) {
                        this.invertedUsersAclMapping.get(ownerUser).addToUserList(userSet.getKey());
                        continue;
                    }
                    if (!userSet.getValue().getType().equals((Object)UserGroupMapping.EntityType.GROUP)) continue;
                    this.invertedUsersAclMapping.get(ownerUser).addToGroupList(userSet.getKey());
                    continue;
                }
                UserGroupMapping userACLInfo = new UserGroupMapping(UserGroupMapping.EntityType.USER, ownerUser);
                if (userSet.getValue().getType().equals((Object)UserGroupMapping.EntityType.USER)) {
                    userACLInfo.addToUserList(userSet.getKey());
                } else if (userSet.getValue().getType().equals((Object)UserGroupMapping.EntityType.GROUP)) {
                    userACLInfo.addToGroupList(userSet.getKey());
                }
                this.invertedUsersAclMapping.put(ownerUser, userACLInfo);
            }
            List<String> ownerGroupList = userSet.getValue().getGroupList();
            for (String ownerGroup : ownerGroupList) {
                if (this.invertedGroupAclMapping.get(ownerGroup) != null) {
                    if (userSet.getValue().getType().equals((Object)UserGroupMapping.EntityType.USER)) {
                        this.invertedGroupAclMapping.get(ownerGroup).addToUserList(userSet.getKey());
                        continue;
                    }
                    if (!userSet.getValue().getType().equals((Object)UserGroupMapping.EntityType.GROUP)) continue;
                    this.invertedGroupAclMapping.get(ownerGroup).addToGroupList(userSet.getKey());
                    continue;
                }
                UserGroupMapping userACLInfo = new UserGroupMapping(UserGroupMapping.EntityType.GROUP, ownerGroup);
                if (userSet.getValue().getType().equals((Object)UserGroupMapping.EntityType.USER)) {
                    userACLInfo.addToUserList(userSet.getKey());
                } else if (userSet.getValue().getType().equals((Object)UserGroupMapping.EntityType.GROUP)) {
                    userACLInfo.addToGroupList(userSet.getKey());
                }
                this.invertedGroupAclMapping.put(ownerGroup, userACLInfo);
            }
        }
    }

    private static Map<UserGroupMapping.EntityType, List<String>> parseUserGroupLists(String userGroupStr) {
        HashMap<UserGroupMapping.EntityType, List<String>> parsedStringMap = new HashMap<UserGroupMapping.EntityType, List<String>>();
        ArrayList<String> userList = new ArrayList<String>();
        ArrayList<String> groupList = new ArrayList<String>();
        Collection<String> userGroupList = StringUtils.getStringCollection(userGroupStr.trim(), ",");
        for (String entity : userGroupList) {
            String[] reqEntity = StringUtils.getStrings(entity.trim(), ":");
            if (reqEntity == null) {
                throw new HadoopIllegalArgumentException("User/group entity is invalid: " + entity.trim());
            }
            if (reqEntity.length != 2 || !reqEntity[0].equals(UserGroupMapping.EntityType.USER.toString()) && !reqEntity[0].equals(UserGroupMapping.EntityType.GROUP.toString())) {
                throw new HadoopIllegalArgumentException("User/group entity is invalid: " + reqEntity[0]);
            }
            if (reqEntity[0].equals(UserGroupMapping.EntityType.USER.toString())) {
                userList.add(reqEntity[1]);
            }
            if (!reqEntity[0].equals(UserGroupMapping.EntityType.GROUP.toString())) continue;
            groupList.add(reqEntity[1]);
        }
        parsedStringMap.put(UserGroupMapping.EntityType.USER, userList);
        parsedStringMap.put(UserGroupMapping.EntityType.GROUP, groupList);
        return parsedStringMap;
    }

    public boolean isUsersACLEnable() {
        return !this.usersAclMapping.isEmpty() || !this.groupAclMapping.isEmpty();
    }

    public boolean checkUserAccess(String reqUser, String owner) {
        return this.checkUserAccess(UserGroupInformation.createRemoteUser(reqUser), owner);
    }

    public boolean checkUserAccess(UserGroupInformation reqUser, String owner) {
        if (!this.usersAclMapping.isEmpty() && this.usersAclMapping.get(reqUser.getShortUserName()) != null && !this.usersAclMapping.get(reqUser.getShortUserName()).getUserList().isEmpty() && this.usersAclMapping.get(reqUser.getShortUserName()).getUserList().contains(owner)) {
            return true;
        }
        List<String> ownerGroups = UserGroupInformation.createRemoteUser(owner).getGroups();
        if (!this.usersAclMapping.isEmpty() && this.usersAclMapping.get(reqUser.getShortUserName()) != null && !this.usersAclMapping.get(reqUser.getShortUserName()).getGroupList().isEmpty()) {
            for (String expectedGroup : ownerGroups) {
                if (!this.usersAclMapping.get(reqUser.getShortUserName()).getGroupList().contains(expectedGroup)) continue;
                return true;
            }
        }
        if (!this.groupAclMapping.isEmpty()) {
            List<String> reqGroups = reqUser.getGroups();
            for (String group : reqGroups) {
                if (this.groupAclMapping.get(group) == null || !this.groupAclMapping.get(group).getUserList().contains(owner)) continue;
                return true;
            }
            for (String group : reqGroups) {
                if (this.groupAclMapping.get(group) == null) continue;
                for (String expectedGroup : ownerGroups) {
                    if (!this.groupAclMapping.get(group).getGroupList().contains(expectedGroup)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String buildACEStrForUser(String owner) {
        ArrayList<String> accessUser = new ArrayList<String>();
        ArrayList<String> accessGroup = new ArrayList<String>();
        if (this.invertedUsersAclMapping.get(owner) != null) {
            if (this.invertedUsersAclMapping.get(owner).getUserList() != null) {
                accessUser.addAll(this.invertedUsersAclMapping.get(owner).getUserList());
            }
            if (this.invertedUsersAclMapping.get(owner).getGroupList() != null) {
                accessGroup.addAll(this.invertedUsersAclMapping.get(owner).getGroupList());
            }
        }
        List<String> ownerGroups = UserGroupInformation.createRemoteUser(owner).getGroups();
        for (String group : ownerGroups) {
            if (this.invertedGroupAclMapping.get(group) == null) continue;
            if (this.invertedGroupAclMapping.get(group).getUserList() != null) {
                accessUser.addAll(this.invertedGroupAclMapping.get(group).getUserList());
            }
            if (this.invertedGroupAclMapping.get(group).getGroupList() == null) continue;
            accessGroup.addAll(this.invertedGroupAclMapping.get(group).getGroupList());
        }
        if (accessUser.isEmpty() && accessGroup.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append((Object)ACE.READ_FILE);
        sb.append(":(");
        if (accessUser != null) {
            for (String user : accessUser) {
                sb.append("u:").append(user).append("|");
            }
        }
        if (accessGroup != null) {
            for (String user : accessGroup) {
                sb.append("g:").append(user).append("|");
            }
        }
        sb.append("u:").append(owner).append(")");
        sb.append(",").append((Object)ACE.WRITE_FILE);
        sb.append(":(u:").append(owner).append(")");
        sb.append(",").append((Object)ACE.EXECUTE_FILE);
        sb.append(":(u:").append(owner).append(")");
        sb.append(",").append((Object)ACE.READ_DIR);
        sb.append(":(");
        if (accessUser != null) {
            for (String user : accessUser) {
                sb.append("u:").append(user).append("|");
            }
        }
        if (accessGroup != null) {
            for (String user : accessGroup) {
                sb.append("g:").append(user).append("|");
            }
        }
        sb.append("u:").append(owner).append(")");
        sb.append(",").append((Object)ACE.LOOKUP_DIR);
        sb.append(":(");
        if (accessUser != null) {
            for (String user : accessUser) {
                sb.append("u:").append(user).append("|");
            }
        }
        if (accessGroup != null) {
            for (String user : accessGroup) {
                sb.append("g:").append(user).append("|");
            }
        }
        sb.append("u:").append(owner).append(")");
        sb.append(",").append((Object)ACE.ADD_CHILD);
        sb.append(":(u:").append(owner).append(")");
        sb.append(",").append((Object)ACE.DELETE_CHILD);
        sb.append(":(u:").append(owner).append(")");
        return sb.toString();
    }

    public static enum ACE {
        READ_FILE("rf"),
        WRITE_FILE("wf"),
        EXECUTE_FILE("ef"),
        READ_DIR("rd"),
        LOOKUP_DIR("ld"),
        ADD_CHILD("ac"),
        DELETE_CHILD("dc");

        private final String name;

        private ACE(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

