/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocolPB;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Function;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.utils.ClientCommandsUtils;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public final class ContainerCommandResponseBuilders {
    public static ContainerProtos.ContainerCommandResponseProto.Builder getContainerCommandResponse(ContainerProtos.ContainerCommandRequestProto request, ContainerProtos.Result result, String message) {
        return ContainerProtos.ContainerCommandResponseProto.newBuilder().setCmdType(request.getCmdType()).setTraceID(request.getTraceID()).setResult(result).setMessage(message);
    }

    public static ContainerProtos.ContainerCommandResponseProto.Builder getSuccessResponseBuilder(ContainerProtos.ContainerCommandRequestProto request) {
        return ContainerProtos.ContainerCommandResponseProto.newBuilder().setCmdType(request.getCmdType()).setTraceID(request.getTraceID()).setResult(ContainerProtos.Result.SUCCESS);
    }

    public static ContainerProtos.ContainerCommandResponseProto getSuccessResponse(ContainerProtos.ContainerCommandRequestProto request) {
        return ContainerCommandResponseBuilders.getSuccessResponseBuilder(request).setMessage("").build();
    }

    public static ContainerProtos.ContainerCommandResponseProto malformedRequest(ContainerProtos.ContainerCommandRequestProto request) {
        return ContainerCommandResponseBuilders.getContainerCommandResponse(request, ContainerProtos.Result.MALFORMED_REQUEST, "Cmd type does not match the payload.").build();
    }

    public static ContainerProtos.ContainerCommandResponseProto unsupportedRequest(ContainerProtos.ContainerCommandRequestProto request) {
        return ContainerCommandResponseBuilders.getContainerCommandResponse(request, ContainerProtos.Result.UNSUPPORTED_REQUEST, "Server does not support this command yet.").build();
    }

    public static ContainerProtos.ContainerCommandResponseProto putBlockResponseSuccess(ContainerProtos.ContainerCommandRequestProto msg, ContainerProtos.BlockData blockData) {
        ContainerProtos.PutBlockResponseProto.Builder putBlock = ContainerProtos.PutBlockResponseProto.newBuilder().setCommittedBlockLength(ContainerCommandResponseBuilders.getCommittedBlockLengthResponseBuilder(blockData.getSize(), blockData.getBlockID()));
        return ContainerCommandResponseBuilders.getSuccessResponseBuilder(msg).setPutBlock(putBlock).build();
    }

    public static ContainerProtos.ContainerCommandResponseProto getBlockResponseSuccess(ContainerProtos.ContainerCommandRequestProto msg) {
        return ContainerCommandResponseBuilders.getSuccessResponse(msg);
    }

    public static ContainerProtos.ContainerCommandResponseProto getBlockDataResponse(ContainerProtos.ContainerCommandRequestProto msg, ContainerProtos.BlockData data) {
        ContainerProtos.GetBlockResponseProto.Builder getBlock = ContainerProtos.GetBlockResponseProto.newBuilder().setBlockData(data);
        return ContainerCommandResponseBuilders.getSuccessResponseBuilder(msg).setGetBlock(getBlock).build();
    }

    public static ContainerProtos.ContainerCommandResponseProto getListBlockResponse(ContainerProtos.ContainerCommandRequestProto msg, List<ContainerProtos.BlockData> data) {
        ContainerProtos.ListBlockResponseProto.Builder builder = ContainerProtos.ListBlockResponseProto.newBuilder();
        builder.addAllBlockData(data);
        return ContainerCommandResponseBuilders.getSuccessResponseBuilder(msg).setListBlock(builder).build();
    }

    public static ContainerProtos.ContainerCommandResponseProto getBlockLengthResponse(ContainerProtos.ContainerCommandRequestProto msg, long blockLength) {
        ContainerProtos.GetCommittedBlockLengthResponseProto.Builder committedBlockLength = ContainerCommandResponseBuilders.getCommittedBlockLengthResponseBuilder(blockLength, msg.getGetCommittedBlockLength().getBlockID());
        return ContainerCommandResponseBuilders.getSuccessResponseBuilder(msg).setGetCommittedBlockLength(committedBlockLength).build();
    }

    public static ContainerProtos.GetCommittedBlockLengthResponseProto.Builder getCommittedBlockLengthResponseBuilder(long blockLength, ContainerProtos.DatanodeBlockID blockID) {
        return ContainerProtos.GetCommittedBlockLengthResponseProto.newBuilder().setBlockLength(blockLength).setBlockID(blockID);
    }

    public static ContainerProtos.ContainerCommandResponseProto getPutFileResponseSuccess(ContainerProtos.ContainerCommandRequestProto msg, ContainerProtos.BlockData blockData) {
        ContainerProtos.PutSmallFileResponseProto.Builder putSmallFile = ContainerProtos.PutSmallFileResponseProto.newBuilder().setCommittedBlockLength(ContainerCommandResponseBuilders.getCommittedBlockLengthResponseBuilder(blockData.getSize(), blockData.getBlockID()));
        return ContainerCommandResponseBuilders.getSuccessResponseBuilder(msg).setCmdType(ContainerProtos.Type.PutSmallFile).setPutSmallFile(putSmallFile).build();
    }

    public static ContainerProtos.ContainerCommandResponseProto getGetSmallFileResponseSuccess(ContainerProtos.ContainerCommandRequestProto request, List<ByteString> dataBuffers, ContainerProtos.ChunkInfo info) {
        ContainerProtos.ReadChunkResponseProto.Builder readChunk;
        Preconditions.checkNotNull((Object)request);
        boolean isReadChunkV0 = ClientCommandsUtils.getReadChunkVersion(request.getGetSmallFile()).equals((Object)ContainerProtos.ReadChunkVersion.V0);
        if (isReadChunkV0) {
            ByteString combinedData = ByteString.EMPTY;
            for (ByteString buffer : dataBuffers) {
                combinedData = combinedData.concat(buffer);
            }
            readChunk = ContainerProtos.ReadChunkResponseProto.newBuilder().setChunkData(info).setData(combinedData).setBlockID(request.getGetSmallFile().getBlock().getBlockID());
        } else {
            readChunk = ContainerProtos.ReadChunkResponseProto.newBuilder().setChunkData(info).setDataBuffers(ContainerProtos.DataBuffers.newBuilder().addAllBuffers(dataBuffers).build()).setBlockID(request.getGetSmallFile().getBlock().getBlockID());
        }
        ContainerProtos.GetSmallFileResponseProto.Builder getSmallFile = ContainerProtos.GetSmallFileResponseProto.newBuilder().setData(readChunk);
        return ContainerCommandResponseBuilders.getSuccessResponseBuilder(request).setCmdType(ContainerProtos.Type.GetSmallFile).setGetSmallFile(getSmallFile).build();
    }

    public static ContainerProtos.ContainerCommandResponseProto getReadContainerResponse(ContainerProtos.ContainerCommandRequestProto request, ContainerProtos.ContainerDataProto containerData) {
        Preconditions.checkNotNull((Object)containerData);
        ContainerProtos.ReadContainerResponseProto.Builder response = ContainerProtos.ReadContainerResponseProto.newBuilder().setContainerData(containerData);
        return ContainerCommandResponseBuilders.getSuccessResponseBuilder(request).setReadContainer(response).build();
    }

    public static ContainerProtos.ContainerCommandResponseProto getReadChunkResponse(ContainerProtos.ContainerCommandRequestProto request, ChunkBuffer data, Function<ByteBuffer, ByteString> byteBufferToByteString) {
        boolean isReadChunkV0 = ClientCommandsUtils.getReadChunkVersion(request.getReadChunk()).equals((Object)ContainerProtos.ReadChunkVersion.V0);
        ContainerProtos.ReadChunkResponseProto.Builder response = isReadChunkV0 ? ContainerProtos.ReadChunkResponseProto.newBuilder().setChunkData(request.getReadChunk().getChunkData()).setData(data.toByteString(byteBufferToByteString)).setBlockID(request.getReadChunk().getBlockID()) : ContainerProtos.ReadChunkResponseProto.newBuilder().setChunkData(request.getReadChunk().getChunkData()).setDataBuffers(ContainerProtos.DataBuffers.newBuilder().addAllBuffers(data.toByteStringList(byteBufferToByteString)).build()).setBlockID(request.getReadChunk().getBlockID());
        return ContainerCommandResponseBuilders.getSuccessResponseBuilder(request).setReadChunk(response).build();
    }

    private ContainerCommandResponseBuilders() {
        throw new UnsupportedOperationException("no instances");
    }
}

