/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.jackson.datatype.joda.deser;

import io.prestosql.jdbc.$internal.jackson.core.JsonParser;
import io.prestosql.jdbc.$internal.jackson.core.JsonToken;
import io.prestosql.jdbc.$internal.jackson.databind.DeserializationContext;
import io.prestosql.jdbc.$internal.jackson.datatype.joda.cfg.FormatConfig;
import io.prestosql.jdbc.$internal.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import io.prestosql.jdbc.$internal.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import io.prestosql.jdbc.$internal.joda.time.Instant;
import java.io.IOException;

public class InstantDeserializer
extends JodaDateDeserializerBase<Instant> {
    private static final long serialVersionUID = 1L;

    public InstantDeserializer() {
        this(FormatConfig.DEFAULT_DATETIME_PARSER);
    }

    public InstantDeserializer(JacksonJodaDateFormat format) {
        super(Instant.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new InstantDeserializer(format);
    }

    @Override
    public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Instant(p.getLongValue());
        }
        if (t == JsonToken.VALUE_STRING) {
            String str = p.getText().trim();
            if (str.length() == 0) {
                return null;
            }
            return Instant.parse(str, this._format.createParser(ctxt));
        }
        return (Instant)this._handleNotNumberOrString(p, ctxt);
    }
}

