/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorPageSource;
import java.util.Iterator;
import java.util.Objects;

public class FixedPageSource
implements ConnectorPageSource {
    private final Iterator<Page> pages;
    private final long memoryUsageBytes;
    private long completedBytes;
    private boolean closed;

    public FixedPageSource(Iterable<Page> pages) {
        this.pages = Objects.requireNonNull(pages, "pages is null").iterator();
        long memoryUsageBytes = 0L;
        for (Page page : pages) {
            memoryUsageBytes += page.getRetainedSizeInBytes();
        }
        this.memoryUsageBytes = memoryUsageBytes;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public long getCompletedBytes() {
        return this.completedBytes;
    }

    @Override
    public long getReadTimeNanos() {
        return 0L;
    }

    @Override
    public boolean isFinished() {
        return this.closed || !this.pages.hasNext();
    }

    @Override
    public Page getNextPage() {
        if (this.isFinished()) {
            return null;
        }
        Page page = this.pages.next();
        this.completedBytes += page.getSizeInBytes();
        return page;
    }

    @Override
    public long getMemoryUsage() {
        return this.memoryUsageBytes;
    }
}

