/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.SortItem;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class AggregateFunction {
    private final String functionName;
    private final Type outputType;
    private final List<ConnectorExpression> arguments;
    private final List<SortItem> sortItems;
    private final boolean isDistinct;
    private final Optional<ConnectorExpression> filter;

    public AggregateFunction(String aggregateFunctionName, Type outputType, List<ConnectorExpression> arguments, List<SortItem> sortItems, boolean isDistinct, Optional<ConnectorExpression> filter) {
        if (isDistinct && arguments.isEmpty()) {
            throw new IllegalArgumentException("DISTINCT requires arguments");
        }
        this.functionName = Objects.requireNonNull(aggregateFunctionName, "aggregateFunctionName is null");
        this.outputType = Objects.requireNonNull(outputType, "outputType is null");
        Objects.requireNonNull(arguments, "arguments is null");
        Objects.requireNonNull(sortItems, "sortItems is null");
        this.arguments = List.copyOf(arguments);
        this.sortItems = List.copyOf(sortItems);
        this.isDistinct = isDistinct;
        this.filter = Objects.requireNonNull(filter, "filter is null");
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<ConnectorExpression> getArguments() {
        return this.arguments;
    }

    public Type getOutputType() {
        return this.outputType;
    }

    public List<SortItem> getSortItems() {
        return this.sortItems;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public Optional<ConnectorExpression> getFilter() {
        return this.filter;
    }

    public String toString() {
        return new StringJoiner(", ", AggregateFunction.class.getSimpleName() + "[", "]").add("aggregationName='" + this.functionName + "'").add("arguments=" + this.arguments).add("outputType=" + this.outputType).add("sortOrder=" + this.sortItems).add("isDistinct=" + this.isDistinct).add("filter=" + this.filter).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateFunction that = (AggregateFunction)o;
        return this.isDistinct == that.isDistinct && Objects.equals(this.functionName, that.functionName) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.outputType, that.outputType) && Objects.equals(this.sortItems, that.sortItems) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.functionName, this.arguments, this.outputType, this.sortItems, this.isDistinct, this.filter);
    }
}

