/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.sqoop.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.services.sqoop.client.json.model.SqoopConnectorResponse;
import org.apache.ranger.services.sqoop.client.json.model.SqoopConnectorsResponse;
import org.apache.ranger.services.sqoop.client.json.model.SqoopJobResponse;
import org.apache.ranger.services.sqoop.client.json.model.SqoopJobsResponse;
import org.apache.ranger.services.sqoop.client.json.model.SqoopLinkResponse;
import org.apache.ranger.services.sqoop.client.json.model.SqoopLinksResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopClient
extends BaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(SqoopClient.class);
    private static final String EXPECTED_MIME_TYPE = "application/json";
    private static final String SQOOP_CONNECTOR_API_ENDPOINT = "/sqoop/v1/connector/all";
    private static final String SQOOP_LINK_API_ENDPOINT = "/sqoop/v1/link/all";
    private static final String SQOOP_JOB_API_ENDPOINT = "/sqoop/v1/job/all";
    private static final String ERROR_MESSAGE = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger-admin logs in $RANGER_HOME/ranger-admin/ews/log/ for more info.";
    private String sqoopUrl;
    private String userName;

    public SqoopClient(String serviceName, Map<String, String> configs) {
        super(serviceName, configs, "sqoop-client");
        this.sqoopUrl = configs.get("sqoop.url");
        this.userName = configs.get("username");
        if (StringUtils.isEmpty((String)this.sqoopUrl)) {
            LOG.error("No value found for configuration 'sqoop.url'. Sqoop resource lookup will fail.");
        }
        if (StringUtils.isEmpty((String)this.userName)) {
            LOG.error("No value found for configuration 'username'. Sqoop resource lookup will fail.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sqoop Client is build with url [" + this.sqoopUrl + "], user: [" + this.userName + "].");
        }
    }

    public List<String> getConnectorList(final String connectorMatching, final List<String> existingConnectors) {
        Subject subj;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get sqoop connector list for connectorMatching: " + connectorMatching + ", existingConnectors: " + existingConnectors);
        }
        if ((subj = this.getLoginSubject()) == null) {
            return Collections.emptyList();
        }
        List<String> ret = Subject.doAs(subj, new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                ClientResponse response = SqoopClient.getClientResponse(SqoopClient.this.sqoopUrl, SqoopClient.SQOOP_CONNECTOR_API_ENDPOINT, SqoopClient.this.userName);
                SqoopConnectorsResponse sqoopConnectorsResponse = (SqoopConnectorsResponse)SqoopClient.this.getSqoopResourceResponse(response, SqoopConnectorsResponse.class);
                if (sqoopConnectorsResponse == null || CollectionUtils.isEmpty(sqoopConnectorsResponse.getConnectors())) {
                    return Collections.emptyList();
                }
                ArrayList<String> connectorResponses = new ArrayList<String>();
                for (SqoopConnectorResponse sqoopConnectorResponse : sqoopConnectorsResponse.getConnectors()) {
                    connectorResponses.add(sqoopConnectorResponse.getName());
                }
                List connectors = null;
                if (CollectionUtils.isNotEmpty(connectorResponses)) {
                    connectors = SqoopClient.filterResourceFromResponse(connectorMatching, existingConnectors, connectorResponses);
                }
                return connectors;
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get sqoop connector list result: " + ret);
        }
        return ret;
    }

    public List<String> getLinkList(final String linkMatching, final List<String> existingLinks) {
        Subject subj;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get sqoop link list for linkMatching: " + linkMatching + ", existingLinks: " + existingLinks);
        }
        if ((subj = this.getLoginSubject()) == null) {
            return Collections.emptyList();
        }
        List<String> ret = Subject.doAs(subj, new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                ClientResponse response = SqoopClient.getClientResponse(SqoopClient.this.sqoopUrl, SqoopClient.SQOOP_LINK_API_ENDPOINT, SqoopClient.this.userName);
                SqoopLinksResponse sqoopLinksResponse = (SqoopLinksResponse)SqoopClient.this.getSqoopResourceResponse(response, SqoopLinksResponse.class);
                if (sqoopLinksResponse == null || CollectionUtils.isEmpty(sqoopLinksResponse.getLinks())) {
                    return Collections.emptyList();
                }
                ArrayList<String> linkResponses = new ArrayList<String>();
                for (SqoopLinkResponse sqoopLinkResponse : sqoopLinksResponse.getLinks()) {
                    linkResponses.add(sqoopLinkResponse.getName());
                }
                List links = null;
                if (CollectionUtils.isNotEmpty(linkResponses)) {
                    links = SqoopClient.filterResourceFromResponse(linkMatching, existingLinks, linkResponses);
                }
                return links;
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get sqoop link list result: " + ret);
        }
        return ret;
    }

    public List<String> getJobList(final String jobMatching, final List<String> existingJobs) {
        Subject subj;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get sqoop job list for jobMatching: " + jobMatching + ", existingJobs: " + existingJobs);
        }
        if ((subj = this.getLoginSubject()) == null) {
            return Collections.emptyList();
        }
        List<String> ret = Subject.doAs(subj, new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                ClientResponse response = SqoopClient.getClientResponse(SqoopClient.this.sqoopUrl, SqoopClient.SQOOP_JOB_API_ENDPOINT, SqoopClient.this.userName);
                SqoopJobsResponse sqoopJobsResponse = (SqoopJobsResponse)SqoopClient.this.getSqoopResourceResponse(response, SqoopJobsResponse.class);
                if (sqoopJobsResponse == null || CollectionUtils.isEmpty(sqoopJobsResponse.getJobs())) {
                    return Collections.emptyList();
                }
                ArrayList<String> jobResponses = new ArrayList<String>();
                for (SqoopJobResponse sqoopJobResponse : sqoopJobsResponse.getJobs()) {
                    jobResponses.add(sqoopJobResponse.getName());
                }
                List jobs = null;
                if (CollectionUtils.isNotEmpty(jobResponses)) {
                    jobs = SqoopClient.filterResourceFromResponse(jobMatching, existingJobs, jobResponses);
                }
                return jobs;
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get sqoop job list result: " + ret);
        }
        return ret;
    }

    private static ClientResponse getClientResponse(String sqoopUrl, String sqoopApi, String userName) {
        ClientResponse response = null;
        Object[] sqoopUrls = sqoopUrl.trim().split("[,;]");
        if (ArrayUtils.isEmpty((Object[])sqoopUrls)) {
            return null;
        }
        Client client = Client.create();
        for (Object currentUrl : sqoopUrls) {
            if (StringUtils.isBlank((String)currentUrl)) continue;
            String url = ((String)currentUrl).trim() + sqoopApi + "?" + "user.name" + "=" + userName;
            try {
                response = SqoopClient.getClientResponse(url, client);
                if (response == null) continue;
                if (response.getStatus() == 200) break;
                response.close();
            }
            catch (Throwable t) {
                String msgDesc = "Exception while getting sqoop response, sqoopUrl: " + url;
                LOG.error(msgDesc, t);
            }
        }
        client.destroy();
        return response;
    }

    private static ClientResponse getClientResponse(String url, Client client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getClientResponse():calling " + url);
        }
        WebResource webResource = client.resource(url);
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{EXPECTED_MIME_TYPE}).get(ClientResponse.class);
        if (response != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getClientResponse():response.getStatus()= " + response.getStatus());
            }
            if (response.getStatus() != 200) {
                LOG.warn("getClientResponse():response.getStatus()= " + response.getStatus() + " for URL " + url + ", failed to get sqoop resource list.");
                String jsonString = (String)response.getEntity(String.class);
                LOG.warn(jsonString);
            }
        }
        return response;
    }

    private <T> T getSqoopResourceResponse(ClientResponse response, Class<T> classOfT) {
        Object resource;
        block9: {
            resource = null;
            try {
                if (response != null) {
                    if (response.getStatus() == 200) {
                        String jsonString = (String)response.getEntity(String.class);
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        resource = gson.fromJson(jsonString, classOfT);
                        break block9;
                    }
                    String msgDesc = "Unable to get a valid response for expected mime type : [application/json], sqoopUrl: " + this.sqoopUrl + " - got http response code " + response.getStatus();
                    LOG.error(msgDesc);
                    HadoopException hdpException = new HadoopException(msgDesc);
                    hdpException.generateResponseDataMap(false, msgDesc, msgDesc + ERROR_MESSAGE, null, null);
                    throw hdpException;
                }
                String msgDesc = "Unable to get a valid response for expected mime type : [application/json], sqoopUrl: " + this.sqoopUrl + " - got null response.";
                LOG.error(msgDesc);
                HadoopException hdpException = new HadoopException(msgDesc);
                hdpException.generateResponseDataMap(false, msgDesc, msgDesc + ERROR_MESSAGE, null, null);
                throw hdpException;
            }
            catch (HadoopException he) {
                throw he;
            }
            catch (Throwable t) {
                String msgDesc = "Exception while getting sqoop resource response, sqoopUrl: " + this.sqoopUrl;
                HadoopException hdpException = new HadoopException(msgDesc, t);
                LOG.error(msgDesc, t);
                hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)t), msgDesc + ERROR_MESSAGE, null, null);
                throw hdpException;
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        return (T)resource;
    }

    private static List<String> filterResourceFromResponse(String resourceMatching, List<String> existingResources, List<String> resourceResponses) {
        ArrayList<String> resources = new ArrayList<String>();
        for (String resourceResponse : resourceResponses) {
            if (CollectionUtils.isNotEmpty(existingResources) && existingResources.contains(resourceResponse) || !StringUtils.isEmpty((String)resourceMatching) && !resourceMatching.startsWith("*") && !resourceResponse.toLowerCase().startsWith(resourceMatching.toLowerCase())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("filterResourceFromResponse(): Adding sqoop resource " + resourceResponse);
            }
            resources.add(resourceResponse);
        }
        return resources;
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) {
        SqoopClient sqoopClient = SqoopClient.getSqoopClient(serviceName, configs);
        List<String> strList = sqoopClient.getConnectorList(null, null);
        boolean connectivityStatus = false;
        if (CollectionUtils.isNotEmpty(strList)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ConnectionTest list size " + strList.size() + " sqoop connectors.");
            }
            connectivityStatus = true;
        }
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        if (connectivityStatus) {
            String successMsg = "ConnectionTest Successful.";
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)successMsg, (String)successMsg, null, null, responseData);
        } else {
            String failureMsg = "Unable to retrieve any sqoop connectors using given parameters.";
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)failureMsg, (String)(failureMsg + ERROR_MESSAGE), null, null, responseData);
        }
        return responseData;
    }

    public static SqoopClient getSqoopClient(String serviceName, Map<String, String> configs) {
        SqoopClient sqoopClient = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting SqoopClient for datasource: " + serviceName);
        }
        if (MapUtils.isEmpty(configs)) {
            String msgDesc = "Could not connect sqoop as Connection ConfigMap is empty.";
            LOG.error(msgDesc);
            HadoopException hdpException = new HadoopException(msgDesc);
            hdpException.generateResponseDataMap(false, msgDesc, msgDesc + ERROR_MESSAGE, null, null);
            throw hdpException;
        }
        sqoopClient = new SqoopClient(serviceName, configs);
        return sqoopClient;
    }
}

