/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockBuilderStatus;
import io.prestosql.spi.block.Int96ArrayBlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.SqlTimestamp;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampTypes;

class LongTimestampType
extends TimestampType {
    public LongTimestampType(int precision) {
        super(precision, LongTimestamp.class);
        if (precision < 7 || precision > 12) {
            throw new IllegalArgumentException(String.format("Precision must be in the range [%s, %s]", 7, 12));
        }
    }

    @Override
    public int getFixedSize() {
        return 12;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Int96ArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Int96ArrayBlockBuilder(null, positionCount);
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return this.compareTo(leftBlock, leftPosition, rightBlock, rightPosition) == 0;
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long leftEpochMicros = LongTimestampType.getEpochMicros(leftBlock, leftPosition);
        int leftFraction = LongTimestampType.getFraction(leftBlock, leftPosition);
        long rightEpochMicros = LongTimestampType.getEpochMicros(rightBlock, rightPosition);
        int rightFraction = LongTimestampType.getFraction(rightBlock, rightPosition);
        int value = Long.compare(leftEpochMicros, rightEpochMicros);
        if (value != 0) {
            return value;
        }
        return Integer.compareUnsigned(leftFraction, rightFraction);
    }

    @Override
    public long hash(Block block, int position) {
        return TimestampTypes.hashLongTimestamp(LongTimestampType.getEpochMicros(block, position), LongTimestampType.getFraction(block, position));
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(LongTimestampType.getEpochMicros(block, position));
            blockBuilder.writeInt(LongTimestampType.getFraction(block, position));
            blockBuilder.closeEntry();
        }
    }

    @Override
    public Object getObject(Block block, int position) {
        return new LongTimestamp(LongTimestampType.getEpochMicros(block, position), LongTimestampType.getFraction(block, position));
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        LongTimestamp timestamp = (LongTimestamp)value;
        this.write(blockBuilder, timestamp.getEpochMicros(), timestamp.getPicosOfMicro());
    }

    public void write(BlockBuilder blockBuilder, long epochMicros, int fraction) {
        blockBuilder.writeLong(epochMicros);
        blockBuilder.writeInt(fraction);
        blockBuilder.closeEntry();
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        long epochMicros = LongTimestampType.getEpochMicros(block, position);
        int fraction = LongTimestampType.getFraction(block, position);
        if (session.isLegacyTimestamp()) {
            return SqlTimestamp.newLegacyInstance(this.getPrecision(), epochMicros, fraction, session.getTimeZoneKey());
        }
        return SqlTimestamp.newInstance(this.getPrecision(), epochMicros, fraction);
    }

    private static long getEpochMicros(Block block, int position) {
        return block.getLong(position, 0);
    }

    private static int getFraction(Block block, int position) {
        return block.getInt(position, 8);
    }
}

