/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.test;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.iceberg.view.BaseView;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewBuilder;
import org.apache.iceberg.view.ViewCatalogTests;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogProperties;
import org.apache.polaris.core.admin.model.PolarisCatalog;
import org.apache.polaris.core.admin.model.PrincipalWithCredentials;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.service.it.env.ClientCredentials;
import org.apache.polaris.service.it.env.IcebergHelper;
import org.apache.polaris.service.it.env.ManagementApi;
import org.apache.polaris.service.it.env.PolarisApiEndpoints;
import org.apache.polaris.service.it.env.PolarisClient;
import org.apache.polaris.service.it.ext.PolarisIntegrationTestExtension;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.configuration.PreferredAssumptionException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={PolarisIntegrationTestExtension.class})
public abstract class PolarisRestCatalogViewIntegrationBase
extends ViewCatalogTests<RESTCatalog> {
    public static Map<String, String> DEFAULT_REST_CATALOG_CONFIG;
    private static ClientCredentials adminCredentials;
    private static PolarisApiEndpoints endpoints;
    private static PolarisClient client;
    private static ManagementApi managementApi;
    private RESTCatalog restCatalog;

    @BeforeAll
    static void setup(PolarisApiEndpoints apiEndpoints, ClientCredentials credentials) {
        adminCredentials = credentials;
        endpoints = apiEndpoints;
        client = PolarisClient.polarisClient(endpoints);
        managementApi = client.managementApi(credentials);
    }

    @AfterAll
    static void close() throws Exception {
        client.close();
    }

    @BeforeEach
    public void before(TestInfo testInfo) {
        Assumptions.assumeThat((boolean)this.shouldSkip()).isFalse();
        String principalName = client.newEntityName("snowman-rest");
        String principalRoleName = client.newEntityName("rest-admin");
        PrincipalWithCredentials principalCredentials = managementApi.createPrincipalWithRole(principalName, principalRoleName);
        Method method = (Method)testInfo.getTestMethod().orElseThrow();
        String catalogName = client.newEntityName(method.getName());
        StorageConfigInfo storageConfig = this.getStorageConfigInfo();
        String defaultBaseLocation = (String)storageConfig.getAllowedLocations().getFirst() + "/" + System.getenv("USER") + "/path/to/data";
        CatalogProperties props = CatalogProperties.builder((String)defaultBaseLocation).addProperty("replace-new-location-prefix-with-catalog-default", "file:").addProperty(FeatureConfiguration.ALLOW_EXTERNAL_TABLE_LOCATION.catalogConfig(), "true").addProperty(FeatureConfiguration.ALLOW_UNSTRUCTURED_TABLE_LOCATION.catalogConfig(), "true").addProperty(FeatureConfiguration.DROP_WITH_PURGE_ENABLED.catalogConfig(), "true").build();
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(catalogName).setProperties(props).setStorageConfigInfo(storageConfig).build();
        managementApi.createCatalog(principalRoleName, (Catalog)catalog);
        this.restCatalog = IcebergHelper.restCatalog(client, endpoints, principalCredentials, catalogName, DEFAULT_REST_CATALOG_CONFIG);
    }

    @AfterEach
    public void cleanUp() {
        client.cleanUp(adminCredentials);
    }

    protected abstract StorageConfigInfo getStorageConfigInfo();

    protected abstract boolean shouldSkip();

    protected RESTCatalog catalog() {
        return this.restCatalog;
    }

    protected org.apache.iceberg.catalog.Catalog tableCatalog() {
        return this.restCatalog;
    }

    protected boolean requiresNamespaceCreate() {
        return true;
    }

    protected boolean supportsServerSideRetry() {
        return true;
    }

    protected boolean overridesRequestedLocation() {
        return true;
    }

    @Test
    public void createViewWithCustomMetadataLocation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> super.createViewWithCustomMetadataLocation()).isInstanceOf(ForbiddenException.class)).hasMessageContaining("Forbidden: Invalid locations");
    }

    @Test
    public void createViewWithCustomMetadataLocationUsingPolaris(@TempDir Path tempDir) {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"ns", "view"});
        String location = Paths.get(tempDir.toUri().toString(), new String[0]).toString();
        String customLocation = Paths.get(tempDir.toUri().toString(), "custom-location").toString();
        String customLocation2 = Paths.get(tempDir.toUri().toString(), "custom-location2").toString();
        String customLocationChild = Paths.get(tempDir.toUri().toString(), "custom-location/child").toString();
        this.catalog().createNamespace(identifier.namespace(), (Map)ImmutableMap.of((Object)"write.metadata.path", (Object)location));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.catalog().viewExists(identifier)).as("View should not exist", new Object[0])).isFalse();
        View view = ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)this.catalog().buildView(identifier).withSchema(SCHEMA)).withDefaultNamespace(identifier.namespace())).withDefaultCatalog(this.catalog().name())).withQuery("spark", "select * from ns.tbl")).withProperty("write.metadata.path", customLocation).withLocation(location).create();
        Assertions.assertThat((Object)view).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.catalog().viewExists(identifier)).as("View should exist", new Object[0])).isTrue();
        Assertions.assertThat((Map)view.properties()).containsEntry((Object)"write.metadata.path", (Object)customLocation);
        ((AbstractStringAssert)Assertions.assertThat((String)((BaseView)view).operations().current().metadataFileLocation()).isNotNull()).startsWith((CharSequence)customLocation);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog().loadView(identifier).updateProperties().set("write.metadata.path", customLocation2).commit()).isInstanceOf(ForbiddenException.class)).hasMessageContaining("Forbidden: Invalid locations");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog().loadView(identifier).updateProperties().set("write.metadata.path", customLocationChild).commit()).isInstanceOf(ForbiddenException.class)).hasMessageContaining("Forbidden: Invalid locations");
    }

    static {
        Assumptions.setPreferredAssumptionException((PreferredAssumptionException)PreferredAssumptionException.JUNIT5);
        DEFAULT_REST_CATALOG_CONFIG = Map.of("view-default.key1", "catalog-default-key1", "view-default.key2", "catalog-default-key2", "view-default.key3", "catalog-default-key3", "view-override.key3", "catalog-override-key3", "view-override.key4", "catalog-override-key4");
    }
}

