/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.test;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.BaseTransaction;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.catalog.CatalogTests;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableCommit;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.ResolvingFileIO;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.view.ViewBuilder;
import org.apache.polaris.core.admin.model.AwsStorageConfigInfo;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogGrant;
import org.apache.polaris.core.admin.model.CatalogPrivilege;
import org.apache.polaris.core.admin.model.CatalogProperties;
import org.apache.polaris.core.admin.model.FileStorageConfigInfo;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.GrantResources;
import org.apache.polaris.core.admin.model.NamespaceGrant;
import org.apache.polaris.core.admin.model.NamespacePrivilege;
import org.apache.polaris.core.admin.model.PolarisCatalog;
import org.apache.polaris.core.admin.model.PrincipalWithCredentials;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import org.apache.polaris.core.admin.model.TableGrant;
import org.apache.polaris.core.admin.model.TablePrivilege;
import org.apache.polaris.core.admin.model.ViewGrant;
import org.apache.polaris.core.admin.model.ViewPrivilege;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.service.it.env.CatalogApi;
import org.apache.polaris.service.it.env.ClientCredentials;
import org.apache.polaris.service.it.env.GenericTableApi;
import org.apache.polaris.service.it.env.IcebergHelper;
import org.apache.polaris.service.it.env.IntegrationTestsHelper;
import org.apache.polaris.service.it.env.ManagementApi;
import org.apache.polaris.service.it.env.PolarisApiEndpoints;
import org.apache.polaris.service.it.env.PolarisClient;
import org.apache.polaris.service.it.ext.PolarisIntegrationTestExtension;
import org.apache.polaris.service.types.CreateGenericTableRequest;
import org.apache.polaris.service.types.GenericTable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.configuration.PreferredAssumptionException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={PolarisIntegrationTestExtension.class})
public class PolarisRestCatalogIntegrationTest
extends CatalogTests<RESTCatalog> {
    private static final String TEST_ROLE_ARN = Optional.ofNullable(System.getenv("INTEGRATION_TEST_ROLE_ARN")).orElse("arn:aws:iam::123456789012:role/my-role");
    private static URI s3BucketBase;
    private static URI externalCatalogBase;
    protected static final String VIEW_QUERY = "select * from ns1.layer1_table";
    private static ClientCredentials adminCredentials;
    private static PolarisApiEndpoints endpoints;
    private static PolarisClient client;
    private static ManagementApi managementApi;
    private PrincipalWithCredentials principalCredentials;
    private CatalogApi catalogApi;
    private GenericTableApi genericTableApi;
    private RESTCatalog restCatalog;
    private String currentCatalogName;
    private Map<String, String> restCatalogConfig;
    private final String catalogBaseLocation = String.valueOf(s3BucketBase) + "/" + System.getenv("USER") + "/path/to/data";
    private static final Map<String, String> DEFAULT_REST_CATALOG_CONFIG;
    private static final String[] DEFAULT_CATALOG_PROPERTIES;

    @BeforeAll
    static void setup(PolarisApiEndpoints apiEndpoints, ClientCredentials credentials, @TempDir Path tempDir) {
        adminCredentials = credentials;
        endpoints = apiEndpoints;
        client = PolarisClient.polarisClient(endpoints);
        managementApi = client.managementApi(credentials);
        URI testRootUri = IntegrationTestsHelper.getTemporaryDirectory(tempDir);
        s3BucketBase = testRootUri.resolve("my-bucket");
        externalCatalogBase = testRootUri.resolve("external-catalog");
    }

    @AfterAll
    static void close() throws Exception {
        client.close();
    }

    @BeforeEach
    public void before(TestInfo testInfo) {
        String principalName = client.newEntityName("snowman-rest");
        String principalRoleName = client.newEntityName("rest-admin");
        this.principalCredentials = managementApi.createPrincipalWithRole(principalName, principalRoleName);
        this.catalogApi = client.catalogApi(this.principalCredentials);
        this.genericTableApi = client.genericTableApi(this.principalCredentials);
        Method method = (Method)testInfo.getTestMethod().orElseThrow();
        this.currentCatalogName = client.newEntityName(method.getName());
        AwsStorageConfigInfo awsConfigModel = AwsStorageConfigInfo.builder().setRoleArn(TEST_ROLE_ARN).setExternalId("externalId").setUserArn("a:user:arn").setStorageType(StorageConfigInfo.StorageTypeEnum.S3).setAllowedLocations(List.of("s3://my-old-bucket/path/to/data")).build();
        Optional<CatalogConfig> catalogConfig = Optional.ofNullable(method.getAnnotation(CatalogConfig.class));
        CatalogProperties.Builder catalogPropsBuilder = CatalogProperties.builder((String)this.catalogBaseLocation);
        String[] properties = catalogConfig.map(CatalogConfig::properties).orElse(DEFAULT_CATALOG_PROPERTIES);
        for (int i = 0; i < properties.length; i += 2) {
            catalogPropsBuilder.addProperty(properties[i], properties[i + 1]);
        }
        catalogPropsBuilder.addProperty(FeatureConfiguration.DROP_WITH_PURGE_ENABLED.catalogConfig(), "true");
        if (!s3BucketBase.getScheme().equals("file")) {
            catalogPropsBuilder.addProperty("replace-new-location-prefix-with-catalog-default", "file:");
        }
        PolarisCatalog catalog = PolarisCatalog.builder().setType(catalogConfig.map(CatalogConfig::value).orElse(Catalog.TypeEnum.INTERNAL)).setName(this.currentCatalogName).setProperties(catalogPropsBuilder.build()).setStorageConfigInfo((StorageConfigInfo)(s3BucketBase.getScheme().equals("file") ? new FileStorageConfigInfo(StorageConfigInfo.StorageTypeEnum.FILE, List.of("file://")) : awsConfigModel)).build();
        managementApi.createCatalog(principalRoleName, (Catalog)catalog);
        Map dynamicConfig = testInfo.getTestMethod().map(m -> m.getAnnotation(RestCatalogConfig.class)).map(RestCatalogConfig::value).map(values -> {
            if (((String[])values).length % 2 != 0) {
                throw new IllegalArgumentException(String.format("Missing value for config '%s'", values[((String[])values).length - 1]));
            }
            HashMap<String, String> config = new HashMap<String, String>();
            for (int i = 0; i < ((String[])values).length; i += 2) {
                config.put(values[i], values[i + 1]);
            }
            return config;
        }).orElse((Map)ImmutableMap.of());
        this.restCatalogConfig = ImmutableMap.builder().putAll(DEFAULT_REST_CATALOG_CONFIG).putAll(dynamicConfig).build();
        this.restCatalog = this.initCatalog(this.currentCatalogName, (Map<String, String>)ImmutableMap.of());
    }

    @AfterEach
    public void cleanUp() {
        client.cleanUp(adminCredentials);
    }

    protected RESTCatalog catalog() {
        return this.restCatalog;
    }

    protected RESTCatalog initCatalog(String catalogName, Map<String, String> additionalProperties) {
        ImmutableMap.Builder extraPropertiesBuilder = ImmutableMap.builder();
        extraPropertiesBuilder.putAll(this.restCatalogConfig);
        extraPropertiesBuilder.putAll(additionalProperties);
        return IcebergHelper.restCatalog(client, endpoints, this.principalCredentials, this.currentCatalogName, (Map<String, String>)extraPropertiesBuilder.buildKeepingLast());
    }

    protected boolean requiresNamespaceCreate() {
        return true;
    }

    protected boolean supportsNestedNamespaces() {
        return true;
    }

    protected boolean supportsServerSideRetry() {
        return true;
    }

    protected boolean overridesRequestedLocation() {
        return true;
    }

    @Test
    public void testListGrantsOnCatalogObjectsToCatalogRoles() {
        this.restCatalog.createNamespace(Namespace.of((String[])new String[]{"ns1"}));
        this.restCatalog.createNamespace(Namespace.of((String[])new String[]{"ns1", "ns1a"}));
        this.restCatalog.createNamespace(Namespace.of((String[])new String[]{"ns2"}));
        this.restCatalog.buildTable(TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"ns1"}), (String)"tbl1"), SCHEMA).create();
        this.restCatalog.buildTable(TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"ns1", "ns1a"}), (String)"tbl1"), SCHEMA).create();
        this.restCatalog.buildTable(TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"ns2"}), (String)"tbl2"), SCHEMA).create();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)this.restCatalog.buildView(TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"ns1"}), (String)"view1")).withSchema(SCHEMA)).withDefaultNamespace(Namespace.of((String[])new String[]{"ns1"}))).withQuery("spark", VIEW_QUERY)).create();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)this.restCatalog.buildView(TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"ns1", "ns1a"}), (String)"view1")).withSchema(SCHEMA)).withDefaultNamespace(Namespace.of((String[])new String[]{"ns1"}))).withQuery("spark", VIEW_QUERY)).create();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)this.restCatalog.buildView(TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"ns2"}), (String)"view2")).withSchema(SCHEMA)).withDefaultNamespace(Namespace.of((String[])new String[]{"ns1"}))).withQuery("spark", VIEW_QUERY)).create();
        CatalogGrant catalogGrant1 = new CatalogGrant(CatalogPrivilege.CATALOG_MANAGE_CONTENT, GrantResource.TypeEnum.CATALOG);
        CatalogGrant catalogGrant2 = new CatalogGrant(CatalogPrivilege.NAMESPACE_FULL_METADATA, GrantResource.TypeEnum.CATALOG);
        CatalogGrant catalogGrant3 = new CatalogGrant(CatalogPrivilege.VIEW_FULL_METADATA, GrantResource.TypeEnum.CATALOG);
        NamespaceGrant namespaceGrant1 = new NamespaceGrant(List.of("ns1"), NamespacePrivilege.NAMESPACE_FULL_METADATA, GrantResource.TypeEnum.NAMESPACE);
        NamespaceGrant namespaceGrant2 = new NamespaceGrant(List.of("ns1", "ns1a"), NamespacePrivilege.TABLE_CREATE, GrantResource.TypeEnum.NAMESPACE);
        NamespaceGrant namespaceGrant3 = new NamespaceGrant(List.of("ns2"), NamespacePrivilege.VIEW_READ_PROPERTIES, GrantResource.TypeEnum.NAMESPACE);
        TableGrant tableGrant1 = new TableGrant(List.of("ns1"), "tbl1", TablePrivilege.TABLE_FULL_METADATA, GrantResource.TypeEnum.TABLE);
        TableGrant tableGrant2 = new TableGrant(List.of("ns1", "ns1a"), "tbl1", TablePrivilege.TABLE_READ_DATA, GrantResource.TypeEnum.TABLE);
        TableGrant tableGrant3 = new TableGrant(List.of("ns2"), "tbl2", TablePrivilege.TABLE_WRITE_DATA, GrantResource.TypeEnum.TABLE);
        ViewGrant viewGrant1 = new ViewGrant(List.of("ns1"), "view1", ViewPrivilege.VIEW_FULL_METADATA, GrantResource.TypeEnum.VIEW);
        ViewGrant viewGrant2 = new ViewGrant(List.of("ns1", "ns1a"), "view1", ViewPrivilege.VIEW_READ_PROPERTIES, GrantResource.TypeEnum.VIEW);
        ViewGrant viewGrant3 = new ViewGrant(List.of("ns2"), "view2", ViewPrivilege.VIEW_WRITE_PROPERTIES, GrantResource.TypeEnum.VIEW);
        managementApi.createCatalogRole(this.currentCatalogName, "catalogrole1");
        managementApi.createCatalogRole(this.currentCatalogName, "catalogrole2");
        List<ViewGrant> role1Grants = List.of(catalogGrant1, catalogGrant2, namespaceGrant1, namespaceGrant2, tableGrant1, tableGrant2, viewGrant1, viewGrant2);
        role1Grants.forEach(grant -> managementApi.addGrant(this.currentCatalogName, "catalogrole1", (GrantResource)grant));
        List<ViewGrant> role2Grants = List.of(catalogGrant1, catalogGrant3, namespaceGrant1, namespaceGrant3, tableGrant1, tableGrant3, viewGrant1, viewGrant3);
        role2Grants.forEach(grant -> managementApi.addGrant(this.currentCatalogName, "catalogrole2", (GrantResource)grant));
        ((ListAssert)Assertions.assertThat((Object)managementApi.listGrants(this.currentCatalogName, "catalogrole1")).extracting(GrantResources::getGrants).asInstanceOf(InstanceOfAssertFactories.list(GrantResource.class))).containsExactlyInAnyOrder((Object[])role1Grants.toArray(new GrantResource[0]));
        ((ListAssert)Assertions.assertThat((Object)managementApi.listGrants(this.currentCatalogName, "catalogrole2")).extracting(GrantResources::getGrants).asInstanceOf(InstanceOfAssertFactories.list(GrantResource.class))).containsExactlyInAnyOrder((Object[])role2Grants.toArray(new GrantResource[0]));
    }

    @Test
    public void testListGrantsAfterRename() {
        this.restCatalog.createNamespace(Namespace.of((String[])new String[]{"ns1"}));
        this.restCatalog.createNamespace(Namespace.of((String[])new String[]{"ns1", "ns1a"}));
        this.restCatalog.createNamespace(Namespace.of((String[])new String[]{"ns2"}));
        this.restCatalog.buildTable(TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"ns1", "ns1a"}), (String)"tbl1"), SCHEMA).create();
        TableGrant tableGrant1 = new TableGrant(List.of("ns1", "ns1a"), "tbl1", TablePrivilege.TABLE_FULL_METADATA, GrantResource.TypeEnum.TABLE);
        managementApi.createCatalogRole(this.currentCatalogName, "catalogrole1");
        managementApi.addGrant(this.currentCatalogName, "catalogrole1", (GrantResource)tableGrant1);
        this.restCatalog.renameTable(TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"ns1", "ns1a"}), (String)"tbl1"), TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"ns2"}), (String)"newtable"));
        TableGrant expectedGrant = new TableGrant(List.of("ns2"), "newtable", TablePrivilege.TABLE_FULL_METADATA, GrantResource.TypeEnum.TABLE);
        ((ListAssert)Assertions.assertThat((Object)managementApi.listGrants(this.currentCatalogName, "catalogrole1")).extracting(GrantResources::getGrants).asInstanceOf(InstanceOfAssertFactories.list(GrantResource.class))).containsExactly((Object[])new GrantResource[]{expectedGrant});
    }

    @Test
    public void testCreateTableWithOverriddenBaseLocation() {
        Catalog catalog = managementApi.getCatalog(this.currentCatalogName);
        HashMap<String, String> catalogProps = new HashMap<String, String>(catalog.getProperties().toMap());
        catalogProps.put(FeatureConfiguration.ALLOW_UNSTRUCTURED_TABLE_LOCATION.catalogConfig(), "false");
        managementApi.updateCatalog(catalog, catalogProps);
        this.restCatalog.createNamespace(Namespace.of((String[])new String[]{"ns1"}));
        this.restCatalog.createNamespace(Namespace.of((String[])new String[]{"ns1", "ns1a"}), (Map)ImmutableMap.of((Object)"location", (Object)(this.catalogBaseLocation + "/ns1/ns1a-override")));
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"ns1", "ns1a"}), (String)"tbl1");
        this.restCatalog.buildTable(tableIdentifier, SCHEMA).withLocation(this.catalogBaseLocation + "/ns1/ns1a-override/tbl1-override").create();
        Table table = this.restCatalog.loadTable(tableIdentifier);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)table).isNotNull()).isInstanceOf(BaseTable.class)).asInstanceOf(InstanceOfAssertFactories.type(BaseTable.class))).returns((Object)(this.catalogBaseLocation + "/ns1/ns1a-override/tbl1-override"), BaseTable::location);
    }

    @Test
    public void testCreateTableWithOverriddenBaseLocationCannotOverlapSibling() {
        Catalog catalog = managementApi.getCatalog(this.currentCatalogName);
        HashMap<String, String> catalogProps = new HashMap<String, String>(catalog.getProperties().toMap());
        catalogProps.put(FeatureConfiguration.ALLOW_UNSTRUCTURED_TABLE_LOCATION.catalogConfig(), "false");
        managementApi.updateCatalog(catalog, catalogProps);
        this.restCatalog.createNamespace(Namespace.of((String[])new String[]{"ns1"}));
        this.restCatalog.createNamespace(Namespace.of((String[])new String[]{"ns1", "ns1a"}), (Map)ImmutableMap.of((Object)"location", (Object)(this.catalogBaseLocation + "/ns1/ns1a-override")));
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"ns1", "ns1a"}), (String)"tbl1");
        this.restCatalog.buildTable(tableIdentifier, SCHEMA).withLocation(this.catalogBaseLocation + "/ns1/ns1a-override/tbl1-override").create();
        Table table = this.restCatalog.loadTable(tableIdentifier);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)table).isNotNull()).isInstanceOf(BaseTable.class)).asInstanceOf(InstanceOfAssertFactories.type(BaseTable.class))).returns((Object)(this.catalogBaseLocation + "/ns1/ns1a-override/tbl1-override"), BaseTable::location);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.restCatalog.buildTable(TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"ns1", "ns1a"}), (String)"tbl2"), SCHEMA).withLocation(this.catalogBaseLocation + "/ns1/ns1a-override/tbl1-override").create()).isInstanceOf(ForbiddenException.class)).hasMessageContaining("because it conflicts with existing table or namespace");
    }

    @Test
    public void testCreateTableWithOverriddenBaseLocationMustResideInNsDirectory() {
        Catalog catalog = managementApi.getCatalog(this.currentCatalogName);
        HashMap<String, String> catalogProps = new HashMap<String, String>(catalog.getProperties().toMap());
        catalogProps.put(FeatureConfiguration.ALLOW_UNSTRUCTURED_TABLE_LOCATION.catalogConfig(), "false");
        managementApi.updateCatalog(catalog, catalogProps);
        this.restCatalog.createNamespace(Namespace.of((String[])new String[]{"ns1"}));
        this.restCatalog.createNamespace(Namespace.of((String[])new String[]{"ns1", "ns1a"}), (Map)ImmutableMap.of((Object)"location", (Object)(this.catalogBaseLocation + "/ns1/ns1a-override")));
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"ns1", "ns1a"}), (String)"tbl1");
        Assertions.assertThatThrownBy(() -> this.restCatalog.buildTable(tableIdentifier, SCHEMA).withLocation(this.catalogBaseLocation + "/ns1/ns1a/tbl1-override").create()).isInstanceOf(ForbiddenException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CatalogConfig(value=Catalog.TypeEnum.EXTERNAL)
    @RestCatalogConfig(value={"header.X-Iceberg-Access-Delegation", "vended-credentials"})
    @Test
    public void testLoadTableWithAccessDelegationForExternalCatalogWithConfigDisabled() {
        Namespace ns1 = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(ns1);
        TableMetadata tableMetadata = TableMetadata.newTableMetadata((Schema)new Schema(List.of(Types.NestedField.required((int)1, (String)"col1", (Type)new Types.StringType()))), (PartitionSpec)PartitionSpec.unpartitioned(), (String)(String.valueOf(externalCatalogBase) + "/ns1/my_table"), Map.of());
        try (ResolvingFileIO resolvingFileIO = new ResolvingFileIO();){
            resolvingFileIO.initialize(Map.of());
            resolvingFileIO.setConf(new Configuration());
            String fileLocation = String.valueOf(externalCatalogBase) + "/ns1/my_table/metadata/v1.metadata.json";
            TableMetadataParser.write((TableMetadata)tableMetadata, (OutputFile)resolvingFileIO.newOutputFile(fileLocation));
            this.restCatalog.registerTable(TableIdentifier.of((Namespace)ns1, (String)"my_table"), fileLocation);
            try {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.restCatalog.loadTable(TableIdentifier.of((Namespace)ns1, (String)"my_table"))).isInstanceOf(ForbiddenException.class)).hasMessageContaining("Access Delegation is not enabled for this catalog").hasMessageContaining(FeatureConfiguration.ALLOW_EXTERNAL_CATALOG_CREDENTIAL_VENDING.catalogConfig());
            }
            finally {
                resolvingFileIO.deleteFile(fileLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CatalogConfig(value=Catalog.TypeEnum.EXTERNAL)
    @Test
    public void testLoadTableWithoutAccessDelegationForExternalCatalogWithConfigDisabled() {
        Namespace ns1 = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(ns1);
        TableMetadata tableMetadata = TableMetadata.newTableMetadata((Schema)new Schema(List.of(Types.NestedField.required((int)1, (String)"col1", (Type)new Types.StringType()))), (PartitionSpec)PartitionSpec.unpartitioned(), (String)(String.valueOf(externalCatalogBase) + "/ns1/my_table"), Map.of());
        try (ResolvingFileIO resolvingFileIO = new ResolvingFileIO();){
            resolvingFileIO.initialize(Map.of());
            resolvingFileIO.setConf(new Configuration());
            String fileLocation = String.valueOf(externalCatalogBase) + "/ns1/my_table/metadata/v1.metadata.json";
            TableMetadataParser.write((TableMetadata)tableMetadata, (OutputFile)resolvingFileIO.newOutputFile(fileLocation));
            this.restCatalog.registerTable(TableIdentifier.of((Namespace)ns1, (String)"my_table"), fileLocation);
            try {
                this.restCatalog.loadTable(TableIdentifier.of((Namespace)ns1, (String)"my_table"));
            }
            finally {
                resolvingFileIO.deleteFile(fileLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CatalogConfig(value=Catalog.TypeEnum.EXTERNAL, properties={"enable.credential.vending", "true"})
    @RestCatalogConfig(value={"header.X-Iceberg-Access-Delegation", "vended-credentials"})
    @Test
    public void testLoadTableWithAccessDelegationForExternalCatalogWithConfigEnabledForCatalog() {
        Namespace ns1 = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(ns1);
        TableMetadata tableMetadata = TableMetadata.newTableMetadata((Schema)new Schema(List.of(Types.NestedField.required((int)1, (String)"col1", (Type)new Types.StringType()))), (PartitionSpec)PartitionSpec.unpartitioned(), (String)(String.valueOf(externalCatalogBase) + "/ns1/my_table"), Map.of());
        try (ResolvingFileIO resolvingFileIO = new ResolvingFileIO();){
            resolvingFileIO.initialize(Map.of());
            resolvingFileIO.setConf(new Configuration());
            String fileLocation = String.valueOf(externalCatalogBase) + "/ns1/my_table/metadata/v1.metadata.json";
            TableMetadataParser.write((TableMetadata)tableMetadata, (OutputFile)resolvingFileIO.newOutputFile(fileLocation));
            this.restCatalog.registerTable(TableIdentifier.of((Namespace)ns1, (String)"my_table"), fileLocation);
            try {
                this.restCatalog.loadTable(TableIdentifier.of((Namespace)ns1, (String)"my_table"));
            }
            finally {
                resolvingFileIO.deleteFile(fileLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Disabled(value="Enable once ETag support is available in the API for loadTable.")
    public void testLoadTableTwiceWithETag() {
        Namespace ns1 = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(ns1);
        TableMetadata tableMetadata = TableMetadata.newTableMetadata((Schema)new Schema(List.of(Types.NestedField.required((int)1, (String)"col1", (Type)new Types.StringType()))), (PartitionSpec)PartitionSpec.unpartitioned(), (String)"file:///tmp/ns1/my_table", Map.of());
        try (ResolvingFileIO resolvingFileIO = new ResolvingFileIO();){
            resolvingFileIO.initialize(Map.of());
            resolvingFileIO.setConf(new Configuration());
            String fileLocation = "file:///tmp/ns1/my_table/metadata/v1.metadata.json";
            TableMetadataParser.write((TableMetadata)tableMetadata, (OutputFile)resolvingFileIO.newOutputFile(fileLocation));
            this.restCatalog.registerTable(TableIdentifier.of((Namespace)ns1, (String)"my_table_etagged"), fileLocation);
            Invocation invocation = this.catalogApi.request("v1/" + this.currentCatalogName + "/namespaces/ns1/tables/my_table_etagged").build("GET");
            try (Response initialLoadTable = invocation.invoke();){
                Assertions.assertThat((Map)initialLoadTable.getHeaders()).containsKey((Object)"ETag");
                String etag = initialLoadTable.getHeaders().getFirst((Object)"ETag").toString();
                Invocation etaggedInvocation = this.catalogApi.request("v1/" + this.currentCatalogName + "/namespaces/ns1/tables/my_table_etagged").header("If-None-Match", (Object)etag).build("GET");
                try (Response etaggedLoadTable = etaggedInvocation.invoke();){
                    Assertions.assertThat((int)etaggedLoadTable.getStatus()).isEqualTo(Response.Status.NOT_MODIFIED.getStatusCode());
                }
            }
            finally {
                resolvingFileIO.deleteFile(fileLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Disabled(value="Enable once ETag support is available in the API for loadTable.")
    public void testRegisterAndLoadTableWithReturnedETag() {
        Namespace ns1 = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(ns1);
        TableMetadata tableMetadata = TableMetadata.newTableMetadata((Schema)new Schema(List.of(Types.NestedField.required((int)1, (String)"col1", (Type)new Types.StringType()))), (PartitionSpec)PartitionSpec.unpartitioned(), (String)"file:///tmp/ns1/my_table", Map.of());
        try (ResolvingFileIO resolvingFileIO = new ResolvingFileIO();){
            resolvingFileIO.initialize(Map.of());
            resolvingFileIO.setConf(new Configuration());
            String fileLocation = "file:///tmp/ns1/my_table/metadata/v1.metadata.json";
            TableMetadataParser.write((TableMetadata)tableMetadata, (OutputFile)resolvingFileIO.newOutputFile(fileLocation));
            Invocation registerInvocation = this.catalogApi.request("v1/" + this.currentCatalogName + "/namespaces/ns1/register").buildPost(Entity.json(Map.of("name", "my_etagged_table", "metadata-location", fileLocation)));
            try (Response registerResponse = registerInvocation.invoke();){
                Assertions.assertThat((Map)registerResponse.getHeaders()).containsKey((Object)"ETag");
                String etag = registerResponse.getHeaders().getFirst((Object)"ETag").toString();
                Invocation etaggedInvocation = this.catalogApi.request("v1/" + this.currentCatalogName + "/namespaces/ns1/tables/my_etagged_table").header("If-None-Match", (Object)etag).build("GET");
                try (Response etaggedLoadTable = etaggedInvocation.invoke();){
                    Assertions.assertThat((int)etaggedLoadTable.getStatus()).isEqualTo(Response.Status.NOT_MODIFIED.getStatusCode());
                }
            }
            finally {
                resolvingFileIO.deleteFile(fileLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Disabled(value="Enable once ETag support is available in the API for loadTable.")
    public void testCreateAndLoadTableWithReturnedEtag() {
        Namespace ns1 = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(ns1);
        TableMetadata tableMetadata = TableMetadata.newTableMetadata((Schema)new Schema(List.of(Types.NestedField.required((int)1, (String)"col1", (Type)new Types.StringType()))), (PartitionSpec)PartitionSpec.unpartitioned(), (String)"file:///tmp/ns1/my_table", Map.of());
        try (ResolvingFileIO resolvingFileIO = new ResolvingFileIO();){
            resolvingFileIO.initialize(Map.of());
            resolvingFileIO.setConf(new Configuration());
            String fileLocation = "file:///tmp/ns1/my_table/metadata/v1.metadata.json";
            TableMetadataParser.write((TableMetadata)tableMetadata, (OutputFile)resolvingFileIO.newOutputFile(fileLocation));
            Invocation createInvocation = this.catalogApi.request("v1/" + this.currentCatalogName + "/namespaces/ns1/tables").buildPost(Entity.json((Object)CreateTableRequest.builder().withName("my_etagged_table").withLocation(tableMetadata.location()).withPartitionSpec(tableMetadata.spec()).withSchema(tableMetadata.schema()).withWriteOrder(tableMetadata.sortOrder()).build()));
            try (Response createResponse = createInvocation.invoke();){
                Assertions.assertThat((Map)createResponse.getHeaders()).containsKey((Object)"ETag");
                String etag = createResponse.getHeaders().getFirst((Object)"ETag").toString();
                Invocation etaggedInvocation = this.catalogApi.request("v1/" + this.currentCatalogName + "/namespaces/ns1/tables/my_etagged_table").header("If-None-Match", (Object)etag).build("GET");
                try (Response etaggedLoadTable = etaggedInvocation.invoke();){
                    Assertions.assertThat((int)etaggedLoadTable.getStatus()).isEqualTo(Response.Status.NOT_MODIFIED.getStatusCode());
                }
            }
            finally {
                resolvingFileIO.deleteFile(fileLocation);
            }
        }
    }

    @Test
    public void testSendNotificationInternalCatalog() {
        ImmutableMap payload = ImmutableMap.builder().put((Object)"table-name", (Object)"tbl1").put((Object)"timestamps", (Object)("" + System.currentTimeMillis())).put((Object)"table-uuid", (Object)UUID.randomUUID().toString()).put((Object)"metadata-location", (Object)"s3://my-bucket/path/to/metadata.json").build();
        this.restCatalog.createNamespace(Namespace.of((String[])new String[]{"ns1"}));
        Invocation.Builder notificationEndpoint = this.catalogApi.request("v1/{cat}/namespaces/ns1/tables/tbl1/notifications", Map.of("cat", this.currentCatalogName));
        try (Response response = notificationEndpoint.post(Entity.json(Map.of("notification-type", "CREATE", "payload", payload)));){
            ((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus)).extracting(r -> (ErrorResponse)r.readEntity(ErrorResponse.class)).returns((Object)"Cannot update internal catalog via notifications", ErrorResponse::message);
        }
        response = notificationEndpoint.post(Entity.json(Map.of("notification-type", "VALIDATE", "payload", payload)));
        try {
            ((ObjectAssert)Assertions.assertThat((Object)response).returns((Object)Response.Status.BAD_REQUEST.getStatusCode(), Response::getStatus)).extracting(r -> (ErrorResponse)r.readEntity(ErrorResponse.class)).returns((Object)"Cannot update internal catalog via notifications", ErrorResponse::message);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void diffAgainstSingleTable() {
        Namespace namespace = Namespace.of((String[])new String[]{"namespace"});
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)"multipleDiffsAgainstSingleTable");
        if (this.requiresNamespaceCreate()) {
            this.catalog().createNamespace(namespace);
        }
        Table table = this.catalog().buildTable(identifier, SCHEMA).create();
        Transaction transaction = table.newTransaction();
        UpdateSchema updateSchema = transaction.updateSchema().addColumn("new_col", (Type)Types.LongType.get());
        Schema expectedSchema = (Schema)updateSchema.apply();
        updateSchema.commit();
        UpdatePartitionSpec updateSpec = transaction.updateSpec().addField("shard", (Term)Expressions.bucket((String)"id", (int)16));
        PartitionSpec expectedSpec = (PartitionSpec)updateSpec.apply();
        updateSpec.commit();
        TableCommit tableCommit = TableCommit.create((TableIdentifier)identifier, (TableMetadata)((BaseTransaction)transaction).startMetadata(), (TableMetadata)((BaseTransaction)transaction).currentMetadata());
        this.restCatalog.commitTransaction(new TableCommit[]{tableCommit});
        Table loaded = this.catalog().loadTable(identifier);
        Assertions.assertThat((Object)loaded.schema().asStruct()).isEqualTo((Object)expectedSchema.asStruct());
        Assertions.assertThat((List)loaded.spec().fields()).isEqualTo((Object)expectedSpec.fields());
    }

    @Test
    public void multipleDiffsAgainstMultipleTables() {
        Namespace namespace = Namespace.of((String[])new String[]{"multiDiffNamespace"});
        TableIdentifier identifier1 = TableIdentifier.of((Namespace)namespace, (String)"multiDiffTable1");
        TableIdentifier identifier2 = TableIdentifier.of((Namespace)namespace, (String)"multiDiffTable2");
        if (this.requiresNamespaceCreate()) {
            this.catalog().createNamespace(namespace);
        }
        Table table1 = this.catalog().buildTable(identifier1, SCHEMA).create();
        Table table2 = this.catalog().buildTable(identifier2, SCHEMA).create();
        Transaction t1Transaction = table1.newTransaction();
        Transaction t2Transaction = table2.newTransaction();
        UpdateSchema updateSchema = t1Transaction.updateSchema().addColumn("new_col", (Type)Types.LongType.get());
        Schema expectedSchema = (Schema)updateSchema.apply();
        updateSchema.commit();
        UpdateSchema updateSchema2 = t2Transaction.updateSchema().addColumn("new_col2", (Type)Types.LongType.get());
        Schema expectedSchema2 = (Schema)updateSchema2.apply();
        updateSchema2.commit();
        TableCommit tableCommit1 = TableCommit.create((TableIdentifier)identifier1, (TableMetadata)((BaseTransaction)t1Transaction).startMetadata(), (TableMetadata)((BaseTransaction)t1Transaction).currentMetadata());
        TableCommit tableCommit2 = TableCommit.create((TableIdentifier)identifier2, (TableMetadata)((BaseTransaction)t2Transaction).startMetadata(), (TableMetadata)((BaseTransaction)t2Transaction).currentMetadata());
        this.restCatalog.commitTransaction(new TableCommit[]{tableCommit1, tableCommit2});
        Assertions.assertThat((Object)this.catalog().loadTable(identifier1).schema().asStruct()).isEqualTo((Object)expectedSchema.asStruct());
        Assertions.assertThat((Object)this.catalog().loadTable(identifier2).schema().asStruct()).isEqualTo((Object)expectedSchema2.asStruct());
    }

    @Test
    public void multipleDiffsAgainstMultipleTablesLastFails() {
        Namespace namespace = Namespace.of((String[])new String[]{"multiDiffNamespace"});
        TableIdentifier identifier1 = TableIdentifier.of((Namespace)namespace, (String)"multiDiffTable1");
        TableIdentifier identifier2 = TableIdentifier.of((Namespace)namespace, (String)"multiDiffTable2");
        if (this.requiresNamespaceCreate()) {
            this.catalog().createNamespace(namespace);
        }
        this.catalog().createTable(identifier1, SCHEMA);
        this.catalog().createTable(identifier2, SCHEMA);
        Table table1 = this.catalog().loadTable(identifier1);
        Table table2 = this.catalog().loadTable(identifier2);
        Schema originalSchemaOne = table1.schema();
        Transaction t1Transaction = this.catalog().loadTable(identifier1).newTransaction();
        t1Transaction.updateSchema().addColumn("new_col1", (Type)Types.LongType.get()).commit();
        Transaction t2Transaction = this.catalog().loadTable(identifier2).newTransaction();
        t2Transaction.updateSchema().renameColumn("data", "new-column").commit();
        table2.updateSchema().deleteColumn("data").commit();
        Schema updatedSchemaTwo = table2.schema();
        TableCommit tableCommit1 = TableCommit.create((TableIdentifier)identifier1, (TableMetadata)((BaseTransaction)t1Transaction).startMetadata(), (TableMetadata)((BaseTransaction)t1Transaction).currentMetadata());
        TableCommit tableCommit2 = TableCommit.create((TableIdentifier)identifier2, (TableMetadata)((BaseTransaction)t2Transaction).startMetadata(), (TableMetadata)((BaseTransaction)t2Transaction).currentMetadata());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.restCatalog.commitTransaction(new TableCommit[]{tableCommit1, tableCommit2})).isInstanceOf(CommitFailedException.class)).hasMessageContaining("Requirement failed: current schema changed: expected id 0 != 1");
        Schema schema1 = this.catalog().loadTable(identifier1).schema();
        Assertions.assertThat((Object)schema1.asStruct()).isEqualTo((Object)originalSchemaOne.asStruct());
        Schema schema2 = this.catalog().loadTable(identifier2).schema();
        Assertions.assertThat((Object)schema2.asStruct()).isEqualTo((Object)updatedSchemaTwo.asStruct());
        Assertions.assertThat((Object)schema2.findField("data")).isNull();
        Assertions.assertThat((Object)schema2.findField("new-column")).isNull();
        Assertions.assertThat((List)schema2.columns()).hasSize(1);
    }

    @Test
    public void testMultipleConflictingCommitsToSingleTableInTransaction() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)"multipleConflictingCommitsAgainstSingleTable");
        if (this.requiresNamespaceCreate()) {
            this.catalog().createNamespace(namespace);
        }
        Table table = this.catalog().buildTable(identifier, SCHEMA).create();
        Schema originalSchema = this.catalog().loadTable(identifier).schema();
        Transaction transaction1 = table.newTransaction();
        Transaction transaction2 = table.newTransaction();
        transaction1.updateSchema().renameColumn("data", "new-column1").commit();
        transaction2.updateSchema().renameColumn("data", "new-column2").commit();
        TableCommit tableCommit1 = TableCommit.create((TableIdentifier)identifier, (TableMetadata)((BaseTransaction)transaction1).startMetadata(), (TableMetadata)((BaseTransaction)transaction1).currentMetadata());
        TableCommit tableCommit2 = TableCommit.create((TableIdentifier)identifier, (TableMetadata)((BaseTransaction)transaction2).startMetadata(), (TableMetadata)((BaseTransaction)transaction2).currentMetadata());
        Assertions.assertThatThrownBy(() -> this.restCatalog.commitTransaction(new TableCommit[]{tableCommit1, tableCommit2})).isInstanceOf(CommitFailedException.class);
        Schema latestCommittedSchema = this.catalog().loadTable(identifier).schema();
        Assertions.assertThat((Object)latestCommittedSchema.asStruct()).isEqualTo((Object)originalSchema.asStruct());
    }

    @Test
    public void testTableExistsStatus() {
        String tableName = "tbl1";
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)tableName);
        if (this.requiresNamespaceCreate()) {
            this.catalog().createNamespace(namespace);
        }
        this.catalog().buildTable(identifier, SCHEMA).create();
        try (Response response = this.catalogApi.request("v1/{cat}/namespaces/{ns}/tables/{table}", Map.of("cat", this.currentCatalogName, "ns", namespace.toString(), "table", tableName)).head();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testDropTableStatus() {
        String tableName = "tbl1";
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)tableName);
        if (this.requiresNamespaceCreate()) {
            this.catalog().createNamespace(namespace);
        }
        this.catalog().buildTable(identifier, SCHEMA).create();
        try (Response response = this.catalogApi.request("v1/{cat}/namespaces/{ns}/tables/{table}", Map.of("cat", this.currentCatalogName, "ns", namespace.toString(), "table", tableName)).delete();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testViewExistsStatus() {
        String tableName = "tbl1";
        String viewName = "view1";
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)tableName);
        if (this.requiresNamespaceCreate()) {
            this.catalog().createNamespace(namespace);
        }
        this.catalog().buildTable(identifier, SCHEMA).create();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)this.restCatalog.buildView(TableIdentifier.of((Namespace)namespace, (String)viewName)).withSchema(SCHEMA)).withDefaultNamespace(namespace)).withQuery("spark", VIEW_QUERY)).create();
        try (Response response = this.catalogApi.request("v1/{cat}/namespaces/{ns}/views/{view}", Map.of("cat", this.currentCatalogName, "ns", namespace.toString(), "view", viewName)).head();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testDropViewStatus() {
        String tableName = "tbl1";
        String viewName = "view1";
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)tableName);
        if (this.requiresNamespaceCreate()) {
            this.catalog().createNamespace(namespace);
        }
        this.catalog().buildTable(identifier, SCHEMA).create();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)this.restCatalog.buildView(TableIdentifier.of((Namespace)namespace, (String)viewName)).withSchema(SCHEMA)).withDefaultNamespace(namespace)).withQuery("spark", VIEW_QUERY)).create();
        try (Response response = this.catalogApi.request("v1/{cat}/namespaces/{ns}/views/{view}", Map.of("cat", this.currentCatalogName, "ns", namespace.toString(), "view", viewName)).delete();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
    }

    @Test
    public void testRenameViewStatus() {
        String tableName = "tbl1";
        String viewName = "view1";
        String newViewName = "view2";
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)tableName);
        if (this.requiresNamespaceCreate()) {
            this.catalog().createNamespace(namespace);
        }
        this.catalog().buildTable(identifier, SCHEMA).create();
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)this.restCatalog.buildView(TableIdentifier.of((Namespace)namespace, (String)viewName)).withSchema(SCHEMA)).withDefaultNamespace(namespace)).withQuery("spark", VIEW_QUERY)).create();
        Map<String, Map<String, String>> payload = Map.of("source", Map.of("namespace", List.of(namespace.toString()), "name", viewName), "destination", Map.of("namespace", List.of(namespace.toString()), "name", newViewName));
        try (Response response = this.catalogApi.request("v1/{cat}/views/rename", Map.of("cat", this.currentCatalogName)).post(Entity.json(payload));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
        response = this.catalogApi.request("v1/{cat}/namespaces/{ns}/views/{view}", Map.of("cat", this.currentCatalogName, "ns", namespace.toString(), "view", viewName)).head();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NOT_FOUND.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        response = this.catalogApi.request("v1/{cat}/namespaces/{ns}/views/{view}", Map.of("cat", this.currentCatalogName, "ns", namespace.toString(), "view", newViewName)).head();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.NO_CONTENT.getStatusCode(), Response::getStatus);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testLoadCredentials() {
        String tableName = "tbl1";
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)tableName);
        this.catalog().createNamespace(namespace);
        this.catalog().buildTable(identifier, SCHEMA).create();
        try (Response response = this.catalogApi.request("v1/{cat}/namespaces/{ns}/tables/{table}/credentials", Map.of("cat", this.currentCatalogName, "ns", namespace.toString(), "table", tableName)).head();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateGenericTable() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(namespace);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)"tbl1");
        try {
            GenericTable createResponse = this.genericTableApi.createGenericTable(this.currentCatalogName, tableIdentifier, "format", Map.of());
            Assertions.assertThat((String)createResponse.getFormat()).isEqualTo("format");
        }
        finally {
            this.genericTableApi.purge(this.currentCatalogName, namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadGenericTable() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(namespace);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)"tbl1");
        try {
            this.genericTableApi.createGenericTable(this.currentCatalogName, tableIdentifier, "format", Map.of());
            GenericTable loadResponse = this.genericTableApi.getGenericTable(this.currentCatalogName, tableIdentifier);
            Assertions.assertThat((String)loadResponse.getFormat()).isEqualTo("format");
        }
        finally {
            this.genericTableApi.purge(this.currentCatalogName, namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListGenericTables() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(namespace);
        TableIdentifier tableIdentifier1 = TableIdentifier.of((Namespace)namespace, (String)"tbl1");
        TableIdentifier tableIdentifier2 = TableIdentifier.of((Namespace)namespace, (String)"tbl2");
        try {
            this.genericTableApi.createGenericTable(this.currentCatalogName, tableIdentifier1, "format", Map.of());
            this.genericTableApi.createGenericTable(this.currentCatalogName, tableIdentifier2, "format", Map.of());
            List<TableIdentifier> identifiers = this.genericTableApi.listGenericTables(this.currentCatalogName, namespace);
            Assertions.assertThat(identifiers).hasSize(2);
            Assertions.assertThat(identifiers).containsExactlyInAnyOrder((Object[])new TableIdentifier[]{tableIdentifier1, tableIdentifier2});
        }
        finally {
            this.genericTableApi.purge(this.currentCatalogName, namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropGenericTable() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(namespace);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)"tbl1");
        try {
            this.genericTableApi.createGenericTable(this.currentCatalogName, tableIdentifier, "format", Map.of());
            GenericTable loadResponse = this.genericTableApi.getGenericTable(this.currentCatalogName, tableIdentifier);
            Assertions.assertThat((String)loadResponse.getFormat()).isEqualTo("format");
            this.genericTableApi.dropGenericTable(this.currentCatalogName, tableIdentifier);
            Assertions.assertThatCode(() -> this.genericTableApi.getGenericTable(this.currentCatalogName, tableIdentifier)).isInstanceOf(ProcessingException.class);
        }
        finally {
            this.genericTableApi.purge(this.currentCatalogName, namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGrantsOnGenericTable() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(namespace);
        try {
            TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)"tbl1");
            this.genericTableApi.createGenericTable(this.currentCatalogName, tableIdentifier, "format", Map.of());
            managementApi.createCatalogRole(this.currentCatalogName, "catalogrole1");
            Stream<TableGrant> tableGrants = Arrays.stream(TablePrivilege.values()).map(p -> new TableGrant(List.of("ns1"), "tbl1", p, GrantResource.TypeEnum.TABLE));
            tableGrants.forEach(g -> managementApi.addGrant(this.currentCatalogName, "catalogrole1", (GrantResource)g));
        }
        finally {
            this.genericTableApi.purge(this.currentCatalogName, namespace);
        }
    }

    @Test
    public void testGrantsOnNonExistingGenericTable() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(namespace);
        try {
            managementApi.createCatalogRole(this.currentCatalogName, "catalogrole1");
            Stream<TableGrant> tableGrants = Arrays.stream(TablePrivilege.values()).map(p -> new TableGrant(List.of("ns1"), "tbl1", p, GrantResource.TypeEnum.TABLE));
            tableGrants.forEach(g -> {
                try (Response response = managementApi.request("v1/catalogs/{cat}/catalog-roles/{role}/grants", Map.of("cat", this.currentCatalogName, "role", "catalogrole1")).put(Entity.json((Object)g));){
                    Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
                }
            });
        }
        finally {
            this.genericTableApi.purge(this.currentCatalogName, namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropNonExistingGenericTable() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(namespace);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)"tbl1");
        try {
            String ns = RESTUtil.encodeNamespace((Namespace)tableIdentifier.namespace());
            try (Response res = this.genericTableApi.request("polaris/v1/{cat}/namespaces/{ns}/generic-tables/{table}", Map.of("cat", this.currentCatalogName, "table", tableIdentifier.name(), "ns", ns)).delete();){
                Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
            }
        }
        finally {
            this.genericTableApi.purge(this.currentCatalogName, namespace);
        }
    }

    @Test
    public void testLoadTableWithSnapshots() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(namespace);
        try {
            TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)"tbl1");
            this.restCatalog.createTable(tableIdentifier, SCHEMA);
            Assertions.assertThatCode(() -> this.catalogApi.loadTable(this.currentCatalogName, tableIdentifier, "ALL")).doesNotThrowAnyException();
            Assertions.assertThatCode(() -> this.catalogApi.loadTable(this.currentCatalogName, tableIdentifier, "all")).doesNotThrowAnyException();
            Assertions.assertThatCode(() -> this.catalogApi.loadTable(this.currentCatalogName, tableIdentifier, "refs")).doesNotThrowAnyException();
            Assertions.assertThatCode(() -> this.catalogApi.loadTable(this.currentCatalogName, tableIdentifier, "REFS")).doesNotThrowAnyException();
            ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.catalogApi.loadTable(this.currentCatalogName, tableIdentifier, "not-real")).isInstanceOf(RESTException.class)).hasMessageContaining("Unrecognized snapshots").hasMessageContaining("code=" + Response.Status.BAD_REQUEST.getStatusCode());
        }
        finally {
            this.genericTableApi.purge(this.currentCatalogName, namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadTableWithRefFiltering() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(namespace);
        try {
            TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)"tbl1");
            this.restCatalog.createTable(tableIdentifier, SCHEMA);
            Table table = this.restCatalog.loadTable(tableIdentifier);
            table.newAppend().appendFile(FILE_A).commit();
            long snapshotIdA = table.currentSnapshot().snapshotId();
            table.newAppend().appendFile(FILE_B).commit();
            table.manageSnapshots().setCurrentSnapshot(snapshotIdA).commit();
            List allSnapshots = this.catalogApi.loadTable(this.currentCatalogName, tableIdentifier, "ALL").tableMetadata().snapshots();
            Assertions.assertThat((List)allSnapshots).hasSize(2);
            List refsSnapshots = this.catalogApi.loadTable(this.currentCatalogName, tableIdentifier, "REFS").tableMetadata().snapshots();
            Assertions.assertThat((List)refsSnapshots).hasSize(1);
            Assertions.assertThat((long)((Snapshot)refsSnapshots.getFirst()).snapshotId()).isEqualTo(snapshotIdA);
        }
        finally {
            this.genericTableApi.purge(this.currentCatalogName, namespace);
        }
    }

    @Test
    public void testCreateGenericTableWithReservedProperty() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(namespace);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)"tbl1");
        String ns = RESTUtil.encodeNamespace((Namespace)tableIdentifier.namespace());
        try (Response res = this.genericTableApi.request("polaris/v1/{cat}/namespaces/{ns}/generic-tables/", Map.of("cat", this.currentCatalogName, "ns", ns)).post(Entity.json((Object)CreateGenericTableRequest.builder().setName(tableIdentifier.name()).setFormat("format").setDoc("doc").setProperties(Map.of("polaris.reserved", "true")).build()));){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.BAD_REQUEST.getStatusCode());
            Assertions.assertThat((String)((String)res.readEntity(String.class))).contains(new CharSequence[]{"reserved prefix"});
        }
        this.genericTableApi.purge(this.currentCatalogName, namespace);
    }

    @Test
    public void testCreateNamespaceWithReservedProperty() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.restCatalog.createNamespace(namespace, (Map)ImmutableMap.of((Object)"polaris.reserved", (Object)"true"))).isInstanceOf(BadRequestException.class)).hasMessageContaining("reserved prefix");
    }

    @Test
    public void testUpdateNamespaceWithReservedProperty() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(namespace, (Map)ImmutableMap.of((Object)"a", (Object)"b"));
        this.restCatalog.setProperties(namespace, (Map)ImmutableMap.of((Object)"c", (Object)"d"));
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.restCatalog.setProperties(namespace, (Map)ImmutableMap.of((Object)"polaris.reserved", (Object)"true"))).isInstanceOf(BadRequestException.class)).hasMessageContaining("reserved prefix");
        this.genericTableApi.purge(this.currentCatalogName, namespace);
    }

    @Test
    public void testRemoveReservedPropertyFromNamespace() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(namespace, (Map)ImmutableMap.of((Object)"a", (Object)"b"));
        this.restCatalog.removeProperties(namespace, (Set)Sets.newHashSet((Object[])new String[]{"a"}));
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.restCatalog.removeProperties(namespace, (Set)Sets.newHashSet((Object[])new String[]{"polaris.reserved"}))).isInstanceOf(BadRequestException.class)).hasMessageContaining("reserved prefix");
        this.genericTableApi.purge(this.currentCatalogName, namespace);
    }

    @Test
    public void testCreateTableWithReservedProperty() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(namespace);
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)"t1");
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.restCatalog.createTable(identifier, SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of((Object)"polaris.reserved", (Object)""))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("reserved prefix");
        this.genericTableApi.purge(this.currentCatalogName, namespace);
    }

    @Test
    public void testUpdateTableWithReservedProperty() {
        Namespace namespace = Namespace.of((String[])new String[]{"ns1"});
        this.restCatalog.createNamespace(namespace);
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)"t1");
        this.restCatalog.createTable(identifier, SCHEMA);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> {
            Transaction txn = this.restCatalog.newReplaceTableTransaction(identifier, SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of((Object)"polaris.reserved", (Object)""), false);
            txn.commitTransaction();
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("reserved prefix");
        this.genericTableApi.purge(this.currentCatalogName, namespace);
    }

    static {
        DEFAULT_REST_CATALOG_CONFIG = Map.of("table-default.default-key1", "catalog-default-key1", "table-default.default-key2", "catalog-default-key2", "table-default.override-key3", "catalog-default-key3", "table-override.override-key3", "catalog-override-key3", "table-override.override-key4", "catalog-override-key4");
        DEFAULT_CATALOG_PROPERTIES = new String[]{"polaris.config.allow.unstructured.table.location", "true", "polaris.config.allow.external.table.location", "true"};
        Assumptions.setPreferredAssumptionException((PreferredAssumptionException)PreferredAssumptionException.JUNIT5);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface CatalogConfig {
        public Catalog.TypeEnum value() default Catalog.TypeEnum.INTERNAL;

        public String[] properties() default {"polaris.config.allow.unstructured.table.location", "true", "polaris.config.allow.external.table.location", "true"};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface RestCatalogConfig {
        public String[] value() default {};
    }
}

