/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.test;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.ResolvingFileIO;
import org.apache.iceberg.rest.RESTSessionCatalog;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.EnvironmentUtil;
import org.apache.polaris.core.admin.model.AwsStorageConfigInfo;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogProperties;
import org.apache.polaris.core.admin.model.CatalogRole;
import org.apache.polaris.core.admin.model.ExternalCatalog;
import org.apache.polaris.core.admin.model.FileStorageConfigInfo;
import org.apache.polaris.core.admin.model.PolarisCatalog;
import org.apache.polaris.core.admin.model.PrincipalRole;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.service.it.env.ClientCredentials;
import org.apache.polaris.service.it.env.ClientPrincipal;
import org.apache.polaris.service.it.env.IntegrationTestsHelper;
import org.apache.polaris.service.it.env.PolarisApiEndpoints;
import org.apache.polaris.service.it.env.PolarisClient;
import org.apache.polaris.service.it.env.RestApi;
import org.apache.polaris.service.it.ext.PolarisIntegrationTestExtension;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={PolarisIntegrationTestExtension.class})
public class PolarisApplicationIntegrationTest {
    public static final String PRINCIPAL_ROLE_ALL = "PRINCIPAL_ROLE:ALL";
    private static String realm;
    private static RestApi managementApi;
    private static PolarisApiEndpoints endpoints;
    private static PolarisClient client;
    private static ClientCredentials clientCredentials;
    private static ClientPrincipal admin;
    private static String authToken;
    private static URI baseLocation;
    private String principalRoleName;
    private String internalCatalogName;

    @BeforeAll
    public static void setup(PolarisApiEndpoints apiEndpoints, ClientPrincipal adminCredentials, @TempDir Path tempDir) {
        endpoints = apiEndpoints;
        client = PolarisClient.polarisClient(endpoints);
        realm = endpoints.realmId();
        admin = adminCredentials;
        clientCredentials = adminCredentials.credentials();
        authToken = client.obtainToken(clientCredentials);
        managementApi = client.managementApi(clientCredentials);
        baseLocation = IntegrationTestsHelper.getTemporaryDirectory(tempDir).resolve(realm + "/");
    }

    @AfterAll
    public static void close() throws Exception {
        client.close();
    }

    @BeforeEach
    public void before(TestInfo testInfo) {
        this.principalRoleName = client.newEntityName("admin");
        PrincipalRole principalRole = new PrincipalRole(this.principalRoleName);
        try (Response createPrResponse = managementApi.request("v1/principal-roles").post(Entity.json((Object)principalRole));){
            Assertions.assertThat((Object)createPrResponse).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        try (Response assignPrResponse = managementApi.request("v1/principals/{name}/principal-roles", Map.of("name", admin.principalName())).put(Entity.json((Object)principalRole));){
            Assertions.assertThat((Object)assignPrResponse).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        this.internalCatalogName = client.newEntityName(((Method)testInfo.getTestMethod().orElseThrow()).getName());
        PolarisApplicationIntegrationTest.createCatalog(this.internalCatalogName, Catalog.TypeEnum.INTERNAL, this.principalRoleName);
    }

    @AfterEach
    public void cleanUp() {
        client.cleanUp(clientCredentials);
    }

    private static void createCatalog(String catalogName, Catalog.TypeEnum catalogType, String principalRoleName) {
        PolarisApplicationIntegrationTest.createCatalog(catalogName, catalogType, principalRoleName, (StorageConfigInfo)AwsStorageConfigInfo.builder().setRoleArn("arn:aws:iam::123456789012:role/my-role").setExternalId("externalId").setStorageType(StorageConfigInfo.StorageTypeEnum.S3).setAllowedLocations(List.of("s3://my-old-bucket/path/to/data")).build(), "s3://my-bucket/path/to/data");
    }

    private static void createCatalog(String catalogName, Catalog.TypeEnum catalogType, String principalRoleName, StorageConfigInfo storageConfig, String defaultBaseLocation) {
        CatalogProperties props = CatalogProperties.builder((String)defaultBaseLocation).addProperty("replace-new-location-prefix-with-catalog-default", "file:/").build();
        PolarisCatalog catalog = catalogType.equals((Object)Catalog.TypeEnum.INTERNAL) ? PolarisCatalog.builder().setName(catalogName).setType(catalogType).setProperties(props).setStorageConfigInfo(storageConfig).build() : ExternalCatalog.builder().setName(catalogName).setType(catalogType).setProperties(props).setStorageConfigInfo(storageConfig).build();
        try (Response response = managementApi.request("v1/catalogs").post(Entity.json((Object)catalog));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
        response = managementApi.request("v1/catalogs/{cat}/catalog-roles/{role}", Map.of("cat", catalogName, "role", PolarisEntityConstants.getNameOfCatalogAdminRole())).get();
        try {
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            CatalogRole catalogRole = (CatalogRole)response.readEntity(CatalogRole.class);
            try (Response assignResponse = managementApi.request("v1/principal-roles/{prin-role}/catalog-roles/{cat}", Map.of("cat", catalogName, "prin-role", principalRoleName)).put(Entity.json((Object)catalogRole));){
                Assertions.assertThat((Object)assignResponse).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    private static RESTSessionCatalog newSessionCatalog(String catalog) {
        RESTSessionCatalog sessionCatalog = new RESTSessionCatalog();
        sessionCatalog.initialize("polaris_catalog_test", Map.of("uri", endpoints.catalogApiEndpoint().toString(), "token", authToken, "warehouse", catalog, "header." + endpoints.realmHeaderName(), realm));
        return sessionCatalog;
    }

    @Test
    public void testIcebergListNamespaces() throws IOException {
        try (RESTSessionCatalog sessionCatalog = PolarisApplicationIntegrationTest.newSessionCatalog(this.internalCatalogName);){
            SessionCatalog.SessionContext sessionContext = SessionCatalog.SessionContext.createEmpty();
            List namespaces = sessionCatalog.listNamespaces(sessionContext);
            ((ListAssert)Assertions.assertThat((List)namespaces).isNotNull()).isEmpty();
        }
    }

    @Test
    public void testConfigureCatalogCaseSensitive() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PolarisApplicationIntegrationTest.newSessionCatalog("TESTCONFIGURECATALOGCASESENSITIVE")).isInstanceOf(RESTException.class)).hasMessage("Unable to process: Unable to find warehouse TESTCONFIGURECATALOGCASESENSITIVE");
    }

    @Test
    public void testIcebergListNamespacesNotFound() throws IOException {
        try (RESTSessionCatalog sessionCatalog = PolarisApplicationIntegrationTest.newSessionCatalog(this.internalCatalogName);){
            SessionCatalog.SessionContext sessionContext = SessionCatalog.SessionContext.createEmpty();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sessionCatalog.listNamespaces(sessionContext, Namespace.of((String[])new String[]{"whoops"}))).isInstanceOf(NoSuchNamespaceException.class)).hasMessage("Namespace does not exist: whoops");
        }
    }

    @Test
    public void testIcebergListNamespacesNestedNotFound() throws IOException {
        try (RESTSessionCatalog sessionCatalog = PolarisApplicationIntegrationTest.newSessionCatalog(this.internalCatalogName);){
            SessionCatalog.SessionContext sessionContext = SessionCatalog.SessionContext.createEmpty();
            Namespace topLevelNamespace = Namespace.of((String[])new String[]{"top_level"});
            sessionCatalog.createNamespace(sessionContext, topLevelNamespace);
            sessionCatalog.loadNamespaceMetadata(sessionContext, Namespace.of((String[])new String[]{"top_level"}));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sessionCatalog.listNamespaces(sessionContext, Namespace.of((String[])new String[]{"top_level", "whoops"}))).isInstanceOf(NoSuchNamespaceException.class)).hasMessage("Namespace does not exist: top_level.whoops");
        }
    }

    @Test
    public void testIcebergListTablesNamespaceNotFound() throws IOException {
        try (RESTSessionCatalog sessionCatalog = PolarisApplicationIntegrationTest.newSessionCatalog(this.internalCatalogName);){
            SessionCatalog.SessionContext sessionContext = SessionCatalog.SessionContext.createEmpty();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sessionCatalog.listTables(sessionContext, Namespace.of((String[])new String[]{"whoops"}))).isInstanceOf(NoSuchNamespaceException.class)).hasMessage("Namespace does not exist: whoops");
        }
    }

    @Test
    public void testIcebergCreateNamespace() throws IOException {
        try (RESTSessionCatalog sessionCatalog = PolarisApplicationIntegrationTest.newSessionCatalog(this.internalCatalogName);){
            SessionCatalog.SessionContext sessionContext = SessionCatalog.SessionContext.createEmpty();
            Namespace topLevelNamespace = Namespace.of((String[])new String[]{"top_level"});
            sessionCatalog.createNamespace(sessionContext, topLevelNamespace);
            List namespaces = sessionCatalog.listNamespaces(sessionContext);
            ((ListAssert)((ListAssert)Assertions.assertThat((List)namespaces).isNotNull()).hasSize(1)).containsExactly((Object[])new Namespace[]{topLevelNamespace});
            Namespace nestedNamespace = Namespace.of((String[])new String[]{"top_level", "second_level"});
            sessionCatalog.createNamespace(sessionContext, nestedNamespace);
            namespaces = sessionCatalog.listNamespaces(sessionContext, topLevelNamespace);
            ((ListAssert)((ListAssert)Assertions.assertThat((List)namespaces).isNotNull()).hasSize(1)).containsExactly((Object[])new Namespace[]{nestedNamespace});
        }
    }

    @Test
    public void testIcebergCreateNamespaceInExternalCatalog() throws IOException {
        String catalogName = client.newEntityName("testIcebergCreateNamespaceInExternalCatalogExternal");
        PolarisApplicationIntegrationTest.createCatalog(catalogName, Catalog.TypeEnum.EXTERNAL, this.principalRoleName);
        try (RESTSessionCatalog sessionCatalog = PolarisApplicationIntegrationTest.newSessionCatalog(catalogName);){
            SessionCatalog.SessionContext sessionContext = SessionCatalog.SessionContext.createEmpty();
            Namespace ns = Namespace.of((String[])new String[]{"db1"});
            sessionCatalog.createNamespace(sessionContext, ns);
            List namespaces = sessionCatalog.listNamespaces(sessionContext);
            ((ListAssert)((ListAssert)Assertions.assertThat((List)namespaces).isNotNull()).hasSize(1)).containsExactly((Object[])new Namespace[]{ns});
            Map metadata = sessionCatalog.loadNamespaceMetadata(sessionContext, ns);
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)metadata).isNotNull()).isNotEmpty()).containsEntry((Object)"location", (Object)"s3://my-bucket/path/to/data/db1/");
        }
    }

    @Test
    public void testIcebergDropNamespaceInExternalCatalog() throws IOException {
        String catalogName = client.newEntityName("testIcebergDropNamespaceInExternalCatalogExternal");
        PolarisApplicationIntegrationTest.createCatalog(catalogName, Catalog.TypeEnum.EXTERNAL, this.principalRoleName);
        try (RESTSessionCatalog sessionCatalog = PolarisApplicationIntegrationTest.newSessionCatalog(catalogName);){
            SessionCatalog.SessionContext sessionContext = SessionCatalog.SessionContext.createEmpty();
            Namespace ns = Namespace.of((String[])new String[]{"db1"});
            sessionCatalog.createNamespace(sessionContext, ns);
            List namespaces = sessionCatalog.listNamespaces(sessionContext);
            ((ListAssert)((ListAssert)Assertions.assertThat((List)namespaces).isNotNull()).hasSize(1)).containsExactly((Object[])new Namespace[]{ns});
            sessionCatalog.dropNamespace(sessionContext, ns);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sessionCatalog.loadNamespaceMetadata(sessionContext, ns)).isInstanceOf(NoSuchNamespaceException.class)).hasMessage("Namespace does not exist: db1");
        }
    }

    @Test
    public void testIcebergCreateTablesInExternalCatalog() throws IOException {
        String catalogName = client.newEntityName("testIcebergCreateTablesInExternalCatalogExternal");
        PolarisApplicationIntegrationTest.createCatalog(catalogName, Catalog.TypeEnum.EXTERNAL, this.principalRoleName);
        try (RESTSessionCatalog sessionCatalog = PolarisApplicationIntegrationTest.newSessionCatalog(catalogName);){
            SessionCatalog.SessionContext sessionContext = SessionCatalog.SessionContext.createEmpty();
            Namespace ns = Namespace.of((String[])new String[]{"db1"});
            sessionCatalog.createNamespace(sessionContext, ns);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sessionCatalog.buildTable(sessionContext, TableIdentifier.of((Namespace)ns, (String)"the_table"), new Schema(List.of(Types.NestedField.required((int)1, (String)"theField", (Type)Types.StringType.get())))).withLocation("file:///tmp/tables").withSortOrder(SortOrder.unsorted()).withPartitionSpec(PartitionSpec.unpartitioned()).create()).isInstanceOf(BadRequestException.class)).hasMessage("Malformed request: Cannot create table on static-facade external catalogs.");
        }
    }

    @Test
    public void testIcebergCreateTablesWithWritePathBlocked() throws IOException {
        String catalogName = client.newEntityName("testIcebergCreateTablesWithWritePathBlockedInternal");
        PolarisApplicationIntegrationTest.createCatalog(catalogName, Catalog.TypeEnum.INTERNAL, this.principalRoleName);
        try (RESTSessionCatalog sessionCatalog = PolarisApplicationIntegrationTest.newSessionCatalog(catalogName);){
            SessionCatalog.SessionContext sessionContext = SessionCatalog.SessionContext.createEmpty();
            Namespace ns = Namespace.of((String[])new String[]{"db1"});
            sessionCatalog.createNamespace(sessionContext, ns);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sessionCatalog.buildTable(sessionContext, TableIdentifier.of((Namespace)ns, (String)"the_table"), new Schema(List.of(Types.NestedField.required((int)1, (String)"theField", (Type)Types.StringType.get())))).withSortOrder(SortOrder.unsorted()).withPartitionSpec(PartitionSpec.unpartitioned()).withProperties(Map.of("write.data.path", "s3://my-bucket/path/to/data")).create()).isInstanceOf(ForbiddenException.class)).hasMessageContaining("Forbidden: Invalid locations");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sessionCatalog.buildTable(sessionContext, TableIdentifier.of((Namespace)ns, (String)"the_table"), new Schema(List.of(Types.NestedField.required((int)1, (String)"theField", (Type)Types.StringType.get())))).withSortOrder(SortOrder.unsorted()).withPartitionSpec(PartitionSpec.unpartitioned()).withProperties(Map.of("write.metadata.path", "s3://my-bucket/path/to/data")).create()).isInstanceOf(ForbiddenException.class)).hasMessageContaining("Forbidden: Invalid locations");
        }
    }

    @Test
    public void testIcebergRegisterTableInExternalCatalog() throws IOException {
        String catalogName = client.newEntityName("testIcebergRegisterTableInExternalCatalogExternal");
        PolarisApplicationIntegrationTest.createCatalog(catalogName, Catalog.TypeEnum.EXTERNAL, this.principalRoleName, (StorageConfigInfo)FileStorageConfigInfo.builder((StorageConfigInfo.StorageTypeEnum)StorageConfigInfo.StorageTypeEnum.FILE).setAllowedLocations(List.of(baseLocation.toString())).build(), baseLocation.toString());
        try (RESTSessionCatalog sessionCatalog = PolarisApplicationIntegrationTest.newSessionCatalog(catalogName);
             HadoopFileIO fileIo = new HadoopFileIO(new Configuration());){
            SessionCatalog.SessionContext sessionContext = SessionCatalog.SessionContext.createEmpty();
            Namespace ns = Namespace.of((String[])new String[]{"db1"});
            sessionCatalog.createNamespace(sessionContext, ns);
            TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)ns, (String)"the_table");
            String location = baseLocation.resolve("testIcebergRegisterTableInExternalCatalog").toString();
            String metadataLocation = location + "/metadata/000001-494949494949494949.metadata.json";
            TableMetadata tableMetadata = TableMetadata.buildFromEmpty().setLocation(location).assignUUID().addPartitionSpec(PartitionSpec.unpartitioned()).addSortOrder(SortOrder.unsorted()).addSchema(new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"col1", (Type)Types.StringType.get())})).build();
            TableMetadataParser.write((TableMetadata)tableMetadata, (OutputFile)fileIo.newOutputFile(metadataLocation));
            sessionCatalog.registerTable(sessionContext, tableIdentifier, metadataLocation);
            Table table = sessionCatalog.loadTable(sessionContext, tableIdentifier);
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)table).isNotNull()).isInstanceOf(BaseTable.class)).asInstanceOf(InstanceOfAssertFactories.type(BaseTable.class))).returns((Object)tableMetadata.location(), BaseTable::location)).returns((Object)tableMetadata.uuid(), bt -> bt.uuid().toString())).returns((Object)tableMetadata.schema().columns(), bt -> bt.schema().columns());
        }
    }

    @Test
    public void testIcebergUpdateTableInExternalCatalog() throws IOException {
        String catalogName = client.newEntityName("testIcebergUpdateTableInExternalCatalogExternal");
        PolarisApplicationIntegrationTest.createCatalog(catalogName, Catalog.TypeEnum.EXTERNAL, this.principalRoleName, (StorageConfigInfo)FileStorageConfigInfo.builder((StorageConfigInfo.StorageTypeEnum)StorageConfigInfo.StorageTypeEnum.FILE).setAllowedLocations(List.of(baseLocation.toString())).build(), baseLocation.toString());
        try (RESTSessionCatalog sessionCatalog = PolarisApplicationIntegrationTest.newSessionCatalog(catalogName);
             HadoopFileIO fileIo = new HadoopFileIO(new Configuration());){
            SessionCatalog.SessionContext sessionContext = SessionCatalog.SessionContext.createEmpty();
            Namespace ns = Namespace.of((String[])new String[]{"db1"});
            sessionCatalog.createNamespace(sessionContext, ns);
            TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)ns, (String)"the_table");
            String location = baseLocation.resolve("testIcebergUpdateTableInExternalCatalog").toString();
            String metadataLocation = location + "/metadata/000001-494949494949494949.metadata.json";
            Types.NestedField col1 = Types.NestedField.required((int)1, (String)"col1", (Type)Types.StringType.get());
            TableMetadata tableMetadata = TableMetadata.buildFromEmpty().setLocation(location).assignUUID().addPartitionSpec(PartitionSpec.unpartitioned()).addSortOrder(SortOrder.unsorted()).addSchema(new Schema(new Types.NestedField[]{col1})).build();
            TableMetadataParser.write((TableMetadata)tableMetadata, (OutputFile)fileIo.newOutputFile(metadataLocation));
            sessionCatalog.registerTable(sessionContext, tableIdentifier, metadataLocation);
            Table table = sessionCatalog.loadTable(sessionContext, tableIdentifier);
            ((ResolvingFileIO)table.io()).setConf(new Configuration());
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> table.newAppend().appendFile((DataFile)new TestHelpers.TestDataFile(location + "/path/to/file.parquet", (StructLike)new PartitionData(PartitionSpec.unpartitioned().partitionType()), 10L)).commit()).isInstanceOf(BadRequestException.class)).hasMessage("Malformed request: Cannot update table on static-facade external catalogs.");
        }
    }

    @Test
    public void testIcebergDropTableInExternalCatalog() throws IOException {
        String catalogName = client.newEntityName("testIcebergDropTableInExternalCatalogExternal");
        PolarisApplicationIntegrationTest.createCatalog(catalogName, Catalog.TypeEnum.EXTERNAL, this.principalRoleName, (StorageConfigInfo)FileStorageConfigInfo.builder((StorageConfigInfo.StorageTypeEnum)StorageConfigInfo.StorageTypeEnum.FILE).setAllowedLocations(List.of(baseLocation.toString())).build(), baseLocation.toString());
        try (RESTSessionCatalog sessionCatalog = PolarisApplicationIntegrationTest.newSessionCatalog(catalogName);
             HadoopFileIO fileIo = new HadoopFileIO(new Configuration());){
            SessionCatalog.SessionContext sessionContext = SessionCatalog.SessionContext.createEmpty();
            Namespace ns = Namespace.of((String[])new String[]{"db1"});
            sessionCatalog.createNamespace(sessionContext, ns);
            TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)ns, (String)"the_table");
            String location = baseLocation.resolve("testIcebergDropTableInExternalCatalog").toString();
            String metadataLocation = location + "/metadata/000001-494949494949494949.metadata.json";
            TableMetadata tableMetadata = TableMetadata.buildFromEmpty().setLocation(location).assignUUID().addPartitionSpec(PartitionSpec.unpartitioned()).addSortOrder(SortOrder.unsorted()).addSchema(new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"col1", (Type)Types.StringType.get())})).build();
            TableMetadataParser.write((TableMetadata)tableMetadata, (OutputFile)fileIo.newOutputFile(metadataLocation));
            sessionCatalog.registerTable(sessionContext, tableIdentifier, metadataLocation);
            Table table = sessionCatalog.loadTable(sessionContext, tableIdentifier);
            Assertions.assertThat((Object)table).isNotNull();
            sessionCatalog.dropTable(sessionContext, tableIdentifier);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sessionCatalog.loadTable(sessionContext, tableIdentifier)).isInstanceOf(NoSuchTableException.class)).hasMessage("Table does not exist: db1.the_table");
        }
    }

    @Test
    public void testWarehouseNotSpecified() throws IOException {
        try (RESTSessionCatalog sessionCatalog = new RESTSessionCatalog();){
            String emptyEnvironmentVariable = "env:__NULL_ENV_VARIABLE__";
            Assertions.assertThat((String)((String)EnvironmentUtil.resolveAll(Map.of("", emptyEnvironmentVariable)).get(""))).isNull();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sessionCatalog.initialize("polaris_catalog_test", Map.of("uri", endpoints.catalogApiEndpoint().toString(), "token", authToken, "warehouse", emptyEnvironmentVariable, "header." + endpoints.realmHeaderName(), realm))).isInstanceOf(BadRequestException.class)).hasMessage("Malformed request: Please specify a warehouse");
        }
    }

    @Test
    public void testRequestHeaderTooLarge() throws Exception {
        try (PolarisClient localClient = PolarisClient.polarisClient(endpoints);){
            Awaitility.await().atMost(Duration.of(1L, ChronoUnit.MINUTES)).untilAsserted(() -> {
                Invocation.Builder request = localClient.managementApi(clientCredentials).request("v1/principal-roles");
                for (int i = 0; i < 1500; ++i) {
                    request = request.header("header" + i, (Object)("" + i));
                }
                try (Response response = request.post(Entity.json((Object)new PrincipalRole("r")));){
                    Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.REQUEST_HEADER_FIELDS_TOO_LARGE.getStatusCode());
                }
                catch (ProcessingException processingException) {
                    // empty catch block
                }
            });
        }
    }

    @Test
    public void testRequestBodyTooLarge() throws Exception {
        try (PolarisClient localClient = PolarisClient.polarisClient(endpoints);){
            Awaitility.await().atMost(Duration.of(1L, ChronoUnit.MINUTES)).untilAsserted(() -> {
                Entity largeRequest = Entity.json((Object)new PrincipalRole("r".repeat(1000001)));
                try (Response response = localClient.managementApi(clientCredentials).request("v1/principal-roles").post(largeRequest);){
                    Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.REQUEST_ENTITY_TOO_LARGE.getStatusCode());
                }
                catch (ProcessingException processingException) {
                    // empty catch block
                }
            });
        }
    }
}

