/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.env;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.polaris.core.policy.PolicyType;
import org.apache.polaris.core.policy.exceptions.PolicyInUseException;
import org.apache.polaris.service.it.env.PolarisApiEndpoints;
import org.apache.polaris.service.it.env.RestApi;
import org.apache.polaris.service.types.ApplicablePolicy;
import org.apache.polaris.service.types.AttachPolicyRequest;
import org.apache.polaris.service.types.CreatePolicyRequest;
import org.apache.polaris.service.types.DetachPolicyRequest;
import org.apache.polaris.service.types.GetApplicablePoliciesResponse;
import org.apache.polaris.service.types.ListPoliciesResponse;
import org.apache.polaris.service.types.LoadPolicyResponse;
import org.apache.polaris.service.types.Policy;
import org.apache.polaris.service.types.PolicyAttachmentTarget;
import org.apache.polaris.service.types.PolicyIdentifier;
import org.apache.polaris.service.types.UpdatePolicyRequest;
import org.assertj.core.api.Assertions;

public class PolicyApi
extends RestApi {
    PolicyApi(Client client, PolarisApiEndpoints endpoints, String authToken, URI uri) {
        super(client, endpoints, authToken, uri);
    }

    public void purge(String catalog, Namespace ns) {
        this.listPolicies(catalog, ns).forEach(t -> this.dropPolicy(catalog, (PolicyIdentifier)t));
    }

    public List<PolicyIdentifier> listPolicies(String catalog, Namespace namespace) {
        return this.listPolicies(catalog, namespace, null);
    }

    public List<PolicyIdentifier> listPolicies(String catalog, Namespace namespace, PolicyType type) {
        String ns = RESTUtil.encodeNamespace((Namespace)namespace);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (type != null) {
            queryParams.put("policyType", type.getName());
        }
        try (Response res = this.request("polaris/v1/{cat}/namespaces/{ns}/policies", Map.of("cat", catalog, "ns", ns), queryParams).get();){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
            List<PolicyIdentifier> list = ((ListPoliciesResponse)res.readEntity(ListPoliciesResponse.class)).getIdentifiers().stream().toList();
            return list;
        }
    }

    public void dropPolicy(String catalog, PolicyIdentifier policyIdentifier) {
        this.dropPolicy(catalog, policyIdentifier, null);
    }

    public void dropPolicy(String catalog, PolicyIdentifier policyIdentifier, Boolean detachAll) {
        String ns = RESTUtil.encodeNamespace((Namespace)policyIdentifier.getNamespace());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (detachAll != null) {
            queryParams.put("detach-all", detachAll.toString());
        }
        try (Response res = this.request("polaris/v1/{cat}/namespaces/{ns}/policies/{policy}", Map.of("cat", catalog, "ns", ns, "policy", policyIdentifier.getName()), queryParams).delete();){
            if (res.getStatus() == Response.Status.BAD_REQUEST.getStatusCode()) {
                throw new PolicyInUseException("Policy in use", new Object[0]);
            }
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NO_CONTENT.getStatusCode());
        }
    }

    public Policy loadPolicy(String catalog, PolicyIdentifier policyIdentifier) {
        String ns = RESTUtil.encodeNamespace((Namespace)policyIdentifier.getNamespace());
        try (Response res = this.request("polaris/v1/{cat}/namespaces/{ns}/policies/{policy}", Map.of("cat", catalog, "ns", ns, "policy", policyIdentifier.getName())).get();){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
            Policy policy = ((LoadPolicyResponse)res.readEntity(LoadPolicyResponse.class)).getPolicy();
            return policy;
        }
    }

    public Policy createPolicy(String catalog, PolicyIdentifier policyIdentifier, PolicyType policyType, String content, String description) {
        String ns = RESTUtil.encodeNamespace((Namespace)policyIdentifier.getNamespace());
        CreatePolicyRequest request = CreatePolicyRequest.builder().setType(policyType.getName()).setName(policyIdentifier.getName()).setDescription(description).setContent(content).build();
        try (Response res = this.request("polaris/v1/{cat}/namespaces/{ns}/policies", Map.of("cat", catalog, "ns", ns)).post(Entity.json((Object)request));){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
            Policy policy = ((LoadPolicyResponse)res.readEntity(LoadPolicyResponse.class)).getPolicy();
            return policy;
        }
    }

    public Policy updatePolicy(String catalog, PolicyIdentifier policyIdentifier, String newContent, String newDescription, int currentPolicyVersion) {
        String ns = RESTUtil.encodeNamespace((Namespace)policyIdentifier.getNamespace());
        UpdatePolicyRequest request = UpdatePolicyRequest.builder().setContent(newContent).setDescription(newDescription).setCurrentPolicyVersion(Integer.valueOf(currentPolicyVersion)).build();
        try (Response res = this.request("polaris/v1/{cat}/namespaces/{ns}/policies/{policy}", Map.of("cat", catalog, "ns", ns, "policy", policyIdentifier.getName())).put(Entity.json((Object)request));){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
            Policy policy = ((LoadPolicyResponse)res.readEntity(LoadPolicyResponse.class)).getPolicy();
            return policy;
        }
    }

    public void attachPolicy(String catalog, PolicyIdentifier policyIdentifier, PolicyAttachmentTarget target, Map<String, String> parameters) {
        String ns = RESTUtil.encodeNamespace((Namespace)policyIdentifier.getNamespace());
        AttachPolicyRequest request = AttachPolicyRequest.builder().setTarget(target).setParameters(parameters).build();
        try (Response res = this.request("polaris/v1/{cat}/namespaces/{ns}/policies/{policy}/mappings", Map.of("cat", catalog, "ns", ns, "policy", policyIdentifier.getName())).put(Entity.json((Object)request));){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NO_CONTENT.getStatusCode());
        }
    }

    public void detachPolicy(String catalog, PolicyIdentifier policyIdentifier, PolicyAttachmentTarget target) {
        String ns = RESTUtil.encodeNamespace((Namespace)policyIdentifier.getNamespace());
        DetachPolicyRequest request = DetachPolicyRequest.builder().setTarget(target).build();
        try (Response res = this.request("polaris/v1/{cat}/namespaces/{ns}/policies/{policy}/mappings", Map.of("cat", catalog, "ns", ns, "policy", policyIdentifier.getName())).post(Entity.json((Object)request));){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.NO_CONTENT.getStatusCode());
        }
    }

    public List<ApplicablePolicy> getApplicablePolicies(String catalog, Namespace namespace, String targetName, PolicyType policyType) {
        String ns = namespace != null ? RESTUtil.encodeNamespace((Namespace)namespace) : null;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (ns != null) {
            queryParams.put("namespace", ns);
        }
        if (targetName != null) {
            queryParams.put("target-name", targetName);
        }
        if (policyType != null) {
            queryParams.put("policyType", policyType.getName());
        }
        try (Response res = this.request("polaris/v1/{cat}/applicable-policies", Map.of("cat", catalog), queryParams).get();){
            Assertions.assertThat((int)res.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
            List<ApplicablePolicy> list = ((GetApplicablePoliciesResponse)res.readEntity(GetApplicablePoliciesResponse.class)).getApplicablePolicies().stream().toList();
            return list;
        }
    }
}

