/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.env;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogGrant;
import org.apache.polaris.core.admin.model.CatalogPrivilege;
import org.apache.polaris.core.admin.model.CatalogRole;
import org.apache.polaris.core.admin.model.CatalogRoles;
import org.apache.polaris.core.admin.model.Catalogs;
import org.apache.polaris.core.admin.model.CreatePrincipalRequest;
import org.apache.polaris.core.admin.model.GrantCatalogRoleRequest;
import org.apache.polaris.core.admin.model.GrantPrincipalRoleRequest;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.GrantResources;
import org.apache.polaris.core.admin.model.Principal;
import org.apache.polaris.core.admin.model.PrincipalRole;
import org.apache.polaris.core.admin.model.PrincipalRoles;
import org.apache.polaris.core.admin.model.PrincipalWithCredentials;
import org.apache.polaris.core.admin.model.Principals;
import org.apache.polaris.core.admin.model.UpdateCatalogRequest;
import org.apache.polaris.service.it.env.PolarisApiEndpoints;
import org.apache.polaris.service.it.env.RestApi;
import org.assertj.core.api.Assertions;

public class ManagementApi
extends RestApi {
    public ManagementApi(Client client, PolarisApiEndpoints endpoints, String authToken, URI uri) {
        super(client, endpoints, authToken, uri);
    }

    public PrincipalWithCredentials createPrincipalWithRole(String principalName, String roleName) {
        PrincipalWithCredentials credentials = this.createPrincipal(principalName);
        this.createPrincipalRole(roleName);
        this.assignPrincipalRole(principalName, roleName);
        return credentials;
    }

    public PrincipalWithCredentials createPrincipal(String name) {
        try (Response createPResponse = this.request("v1/principals").post(Entity.json((Object)new Principal(name)));){
            Assertions.assertThat((Object)createPResponse).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
            PrincipalWithCredentials principalWithCredentials = (PrincipalWithCredentials)createPResponse.readEntity(PrincipalWithCredentials.class);
            return principalWithCredentials;
        }
    }

    public PrincipalWithCredentials createPrincipal(CreatePrincipalRequest request) {
        try (Response createPResponse = this.request("v1/principals").post(Entity.json((Object)request));){
            Assertions.assertThat((Object)createPResponse).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
            PrincipalWithCredentials principalWithCredentials = (PrincipalWithCredentials)createPResponse.readEntity(PrincipalWithCredentials.class);
            return principalWithCredentials;
        }
    }

    public void createPrincipalRole(String name) {
        this.createPrincipalRole(new PrincipalRole(name));
    }

    public void createPrincipalRole(PrincipalRole role) {
        try (Response createPrResponse = this.request("v1/principal-roles").post(Entity.json((Object)role));){
            Assertions.assertThat((Object)createPrResponse).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
    }

    public void assignPrincipalRole(String principalName, String roleName) {
        try (Response assignPrResponse = this.request("v1/principals/{prince}/principal-roles", Map.of("prince", principalName)).put(Entity.json((Object)new GrantPrincipalRoleRequest(new PrincipalRole(roleName))));){
            Assertions.assertThat((Object)assignPrResponse).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
    }

    public void createCatalogRole(String catalogName, String catalogRoleName) {
        try (Response response = this.request("v1/catalogs/{cat}/catalog-roles", Map.of("cat", catalogName)).post(Entity.json((Object)new CatalogRole(catalogRoleName)));){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.CREATED.getStatusCode());
        }
    }

    public void addGrant(String catalogName, String catalogRoleName, GrantResource grant) {
        try (Response response = this.request("v1/catalogs/{cat}/catalog-roles/{role}/grants", Map.of("cat", catalogName, "role", catalogRoleName)).put(Entity.json((Object)grant));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
    }

    public void revokeGrant(String catalogName, String catalogRoleName, GrantResource grant) {
        try (Response response = this.request("v1/catalogs/{cat}/catalog-roles/{role}/grants", Map.of("cat", catalogName, "role", catalogRoleName)).post(Entity.json((Object)grant));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
    }

    public void grantCatalogRoleToPrincipalRole(String principalRoleName, String catalogName, CatalogRole catalogRole) {
        try (Response response = this.request("v1/principal-roles/{role}/catalog-roles/{cat}", Map.of("role", principalRoleName, "cat", catalogName)).put(Entity.json((Object)new GrantCatalogRoleRequest(catalogRole)));){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.CREATED.getStatusCode(), Response::getStatus);
        }
    }

    public GrantResources listGrants(String catalogName, String catalogRoleName) {
        try (Response response = this.request("v1/catalogs/{cat}/catalog-roles/{role}/grants", Map.of("cat", catalogName, "role", catalogRoleName)).get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            GrantResources grantResources = (GrantResources)response.readEntity(GrantResources.class);
            return grantResources;
        }
    }

    public void createCatalog(String principalRoleName, Catalog catalog) {
        this.createCatalog(catalog);
        String catalogRoleName = "custom-admin";
        this.createCatalogRole(catalog.getName(), catalogRoleName);
        CatalogGrant grantResource = new CatalogGrant(CatalogPrivilege.CATALOG_MANAGE_CONTENT, GrantResource.TypeEnum.CATALOG);
        Map<String, String> catalogVars = Map.of("cat", catalog.getName(), "role", catalogRoleName);
        try (Response response = this.request("v1/catalogs/{cat}/catalog-roles/{role}/grants", catalogVars).put(Entity.json((Object)grantResource));){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.CREATED.getStatusCode());
        }
        CatalogGrant grantAccessResource = new CatalogGrant(CatalogPrivilege.CATALOG_MANAGE_ACCESS, GrantResource.TypeEnum.CATALOG);
        try (Response response = this.request("v1/catalogs/{cat}/catalog-roles/{role}/grants", catalogVars).put(Entity.json((Object)grantAccessResource));){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.CREATED.getStatusCode());
        }
        response = this.request("v1/principal-roles/{role}/catalog-roles/{cat}", Map.of("role", principalRoleName, "cat", catalog.getName())).put(Entity.json((Object)new CatalogRole(catalogRoleName)));
        try {
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.CREATED.getStatusCode());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public void createCatalog(Catalog catalog) {
        try (Response response = this.request("v1/catalogs").post(Entity.json((Object)catalog));){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.CREATED.getStatusCode());
        }
    }

    public Catalog getCatalog(String name) {
        try (Response response = this.request("v1/catalogs/{name}", Map.of("name", name)).get();){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
            Catalog catalog = (Catalog)response.readEntity(Catalog.class);
            return catalog;
        }
    }

    public void updateCatalog(Catalog catalog, Map<String, String> catalogProps) {
        try (Response response = this.request("v1/catalogs/{name}", Map.of("name", catalog.getName())).put(Entity.json((Object)new UpdateCatalogRequest(catalog.getEntityVersion(), catalogProps, catalog.getStorageConfigInfo())));){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
        }
    }

    public void deleteCatalog(String catalogName) {
        try (Response response = this.request("v1/catalogs/{cat}", Map.of("cat", catalogName)).delete();){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.NO_CONTENT.getStatusCode());
        }
    }

    public CatalogRole getCatalogRole(String catalogName, String roleName) {
        try (Response response = this.request("v1/catalogs/{cat}/catalog-roles/{role}", Map.of("cat", catalogName, "role", roleName)).get();){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
            CatalogRole catalogRole = (CatalogRole)response.readEntity(CatalogRole.class);
            return catalogRole;
        }
    }

    public List<CatalogRole> listCatalogRoles(String catalogName) {
        try (Response response = this.request("v1/catalogs/{cat}/catalog-roles", Map.of("cat", catalogName)).get();){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
            List list = ((CatalogRoles)response.readEntity(CatalogRoles.class)).getRoles();
            return list;
        }
    }

    public List<Principal> listPrincipals() {
        try (Response response = this.request("v1/principals").get();){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
            List list = ((Principals)response.readEntity(Principals.class)).getPrincipals();
            return list;
        }
    }

    public List<PrincipalRole> listPrincipalRoles() {
        try (Response response = this.request("v1/principal-roles").get();){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
            List list = ((PrincipalRoles)response.readEntity(PrincipalRoles.class)).getRoles();
            return list;
        }
    }

    public List<Catalog> listCatalogs() {
        try (Response response = this.request("v1/catalogs").get();){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
            List list = ((Catalogs)response.readEntity(Catalogs.class)).getCatalogs();
            return list;
        }
    }

    public void deleteCatalogRole(String catalogName, CatalogRole role) {
        this.deleteCatalogRole(catalogName, role.getName());
    }

    public void deleteCatalogRole(String catalogName, String roleName) {
        try (Response response = this.request("v1/catalogs/{cat}/catalog-roles/{role}", Map.of("cat", catalogName, "role", roleName)).delete();){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.NO_CONTENT.getStatusCode());
        }
    }

    public void deletePrincipal(Principal principal) {
        this.deletePrincipal(principal.getName());
    }

    public void deletePrincipal(String principalName) {
        try (Response response = this.request("v1/principals/{name}", Map.of("name", principalName)).delete();){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.NO_CONTENT.getStatusCode());
        }
    }

    public void deletePrincipalRole(PrincipalRole role) {
        try (Response response = this.request("v1/principal-roles/{name}", Map.of("name", role.getName())).delete();){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(Response.Status.NO_CONTENT.getStatusCode());
        }
    }

    public void dropCatalog(String catalogName) {
        this.listCatalogRoles(catalogName).stream().filter(cr -> !cr.getName().equals("catalog_admin")).forEach(role -> this.deleteCatalogRole(catalogName, (CatalogRole)role));
        this.deleteCatalog(catalogName);
    }
}

