/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.test;

import com.google.common.collect.ImmutableMap;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.rest.requests.ImmutableRegisterTableRequest;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.polaris.service.it.ext.PolarisSparkIntegrationTestBase;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class PolarisSparkIntegrationTest
extends PolarisSparkIntegrationTestBase {
    @Test
    public void testCreateTable() {
        long namespaceCount = PolarisSparkIntegrationTest.onSpark("SHOW NAMESPACES").count();
        Assertions.assertThat((long)namespaceCount).isEqualTo(0L);
        PolarisSparkIntegrationTest.onSpark("CREATE NAMESPACE ns1");
        PolarisSparkIntegrationTest.onSpark("USE ns1");
        PolarisSparkIntegrationTest.onSpark("CREATE TABLE tb1 (col1 integer, col2 string)");
        PolarisSparkIntegrationTest.onSpark("INSERT INTO tb1 VALUES (1, 'a'), (2, 'b'), (3, 'c')");
        long recordCount = PolarisSparkIntegrationTest.onSpark("SELECT * FROM tb1").count();
        Assertions.assertThat((long)recordCount).isEqualTo(3L);
    }

    @Test
    public void testCreateAndUpdateExternalTable() {
        long namespaceCount = PolarisSparkIntegrationTest.onSpark("SHOW NAMESPACES").count();
        Assertions.assertThat((long)namespaceCount).isEqualTo(0L);
        PolarisSparkIntegrationTest.onSpark("CREATE NAMESPACE ns1");
        PolarisSparkIntegrationTest.onSpark("USE ns1");
        PolarisSparkIntegrationTest.onSpark("CREATE TABLE tb1 (col1 integer, col2 string)");
        PolarisSparkIntegrationTest.onSpark("INSERT INTO tb1 VALUES (1, 'a'), (2, 'b'), (3, 'c')");
        long recordCount = PolarisSparkIntegrationTest.onSpark("SELECT * FROM tb1").count();
        Assertions.assertThat((long)recordCount).isEqualTo(3L);
        PolarisSparkIntegrationTest.onSpark("USE " + this.externalCatalogName);
        List existingNamespaces = PolarisSparkIntegrationTest.onSpark("SHOW NAMESPACES").collectAsList();
        Assertions.assertThat((List)existingNamespaces).isEmpty();
        PolarisSparkIntegrationTest.onSpark("CREATE NAMESPACE externalns1");
        PolarisSparkIntegrationTest.onSpark("USE externalns1");
        List existingTables = PolarisSparkIntegrationTest.onSpark("SHOW TABLES").collectAsList();
        Assertions.assertThat((List)existingTables).isEmpty();
        LoadTableResponse tableResponse = this.loadTable(this.catalogName, "ns1", "tb1");
        try (Response registerResponse = this.catalogApi.request("v1/{cat}/namespaces/externalns1/register", Map.of("cat", this.externalCatalogName)).post(Entity.json((Object)ImmutableRegisterTableRequest.builder().name("mytb1").metadataLocation(tableResponse.metadataLocation()).build()));){
            Assertions.assertThat((Object)registerResponse).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
        }
        long tableCount = PolarisSparkIntegrationTest.onSpark("SHOW TABLES").count();
        Assertions.assertThat((long)tableCount).isEqualTo(1L);
        List tables = PolarisSparkIntegrationTest.onSpark("SHOW TABLES").collectAsList();
        ((ListAssert)Assertions.assertThat((List)tables).hasSize(1)).extracting(row -> row.getString(1)).containsExactly((Object[])new String[]{"mytb1"});
        long rowCount = PolarisSparkIntegrationTest.onSpark("SELECT * FROM mytb1").count();
        Assertions.assertThat((long)rowCount).isEqualTo(3L);
        Assertions.assertThatThrownBy(() -> PolarisSparkIntegrationTest.onSpark("INSERT INTO mytb1 VALUES (20, 'new_text')")).isInstanceOf(Exception.class);
        PolarisSparkIntegrationTest.onSpark("INSERT INTO " + this.catalogName + ".ns1.tb1 VALUES (20, 'new_text')");
        tableResponse = this.loadTable(this.catalogName, "ns1", "tb1");
        ImmutableMap updateNotification = ImmutableMap.builder().put((Object)"table-name", (Object)"mytb1").put((Object)"timestamp", (Object)("" + Instant.now().toEpochMilli())).put((Object)"table-uuid", (Object)tableResponse.tableMetadata().uuid()).put((Object)"metadata-location", (Object)tableResponse.metadataLocation()).put((Object)"metadata", (Object)tableResponse.tableMetadata()).build();
        ImmutableMap notificationRequest = ImmutableMap.builder().put((Object)"payload", (Object)updateNotification).put((Object)"notification-type", (Object)"UPDATE").build();
        try (Response notifyResponse = this.catalogApi.request("v1/{cat}/namespaces/externalns1/tables/mytb1/notifications", Map.of("cat", this.externalCatalogName)).post(Entity.json((Object)notificationRequest));){
            Assertions.assertThat((Object)notifyResponse).extracting(Response::getStatus).isEqualTo((Object)Response.Status.NO_CONTENT.getStatusCode());
        }
        PolarisSparkIntegrationTest.onSpark("REFRESH TABLE mytb1");
        rowCount = PolarisSparkIntegrationTest.onSpark("SELECT * FROM mytb1").count();
        Assertions.assertThat((long)rowCount).isEqualTo(4L);
    }

    @Test
    public void testCreateView() {
        long namespaceCount = PolarisSparkIntegrationTest.onSpark("SHOW NAMESPACES").count();
        Assertions.assertThat((long)namespaceCount).isEqualTo(0L);
        PolarisSparkIntegrationTest.onSpark("CREATE NAMESPACE ns1");
        PolarisSparkIntegrationTest.onSpark("USE ns1");
        PolarisSparkIntegrationTest.onSpark("CREATE TABLE tb1 (col1 integer, col2 string)");
        PolarisSparkIntegrationTest.onSpark("INSERT INTO tb1 VALUES (1, 'a'), (2, 'b'), (3, 'c')");
        PolarisSparkIntegrationTest.onSpark("CREATE VIEW view1 AS SELECT * FROM tb1");
        long recordCount = PolarisSparkIntegrationTest.onSpark("SELECT * FROM view1").count();
        Assertions.assertThat((long)recordCount).isEqualTo(3L);
    }

    private LoadTableResponse loadTable(String catalog, String namespace, String table) {
        try (Response response = this.catalogApi.request("v1/{cat}/namespaces/{ns}/tables/{table}", Map.of("cat", catalog, "ns", namespace, "table", table)).get();){
            Assertions.assertThat((Object)response).returns((Object)Response.Status.OK.getStatusCode(), Response::getStatus);
            LoadTableResponse loadTableResponse = (LoadTableResponse)response.readEntity(LoadTableResponse.class);
            return loadTableResponse;
        }
    }
}

