/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.ext;

import com.adobe.testing.s3mock.testcontainers.S3MockContainer;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.polaris.core.admin.model.AwsStorageConfigInfo;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogProperties;
import org.apache.polaris.core.admin.model.ExternalCatalog;
import org.apache.polaris.core.admin.model.PolarisCatalog;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import org.apache.polaris.service.it.env.CatalogApi;
import org.apache.polaris.service.it.env.ClientCredentials;
import org.apache.polaris.service.it.env.IntegrationTestsHelper;
import org.apache.polaris.service.it.env.ManagementApi;
import org.apache.polaris.service.it.env.PolarisApiEndpoints;
import org.apache.polaris.service.it.env.PolarisClient;
import org.apache.polaris.service.it.ext.PolarisIntegrationTestExtension;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.LoggerFactory;

@ExtendWith(value={PolarisIntegrationTestExtension.class})
public abstract class PolarisSparkIntegrationTestBase {
    protected static final S3MockContainer s3Container = new S3MockContainer("3.11.0").withInitialBuckets("my-bucket,my-old-bucket");
    protected static SparkSession spark;
    protected PolarisApiEndpoints endpoints;
    protected PolarisClient client;
    protected ManagementApi managementApi;
    protected CatalogApi catalogApi;
    protected String sparkToken;
    protected String catalogName;
    protected String externalCatalogName;
    protected URI warehouseDir;

    @BeforeAll
    public static void setup() throws IOException {
        s3Container.start();
    }

    @AfterAll
    public static void cleanup() {
        s3Container.stop();
    }

    @BeforeEach
    public void before(PolarisApiEndpoints apiEndpoints, ClientCredentials credentials, @TempDir Path tempDir) {
        this.endpoints = apiEndpoints;
        this.client = PolarisClient.polarisClient(this.endpoints);
        this.sparkToken = this.client.obtainToken(credentials);
        this.managementApi = this.client.managementApi(credentials);
        this.catalogApi = this.client.catalogApi(credentials);
        this.warehouseDir = IntegrationTestsHelper.getTemporaryDirectory(tempDir).resolve("spark-warehouse");
        this.catalogName = this.client.newEntityName("spark_catalog");
        this.externalCatalogName = this.client.newEntityName("spark_ext_catalog");
        AwsStorageConfigInfo awsConfigModel = AwsStorageConfigInfo.builder().setRoleArn("arn:aws:iam::123456789012:role/my-role").setExternalId("externalId").setUserArn("userArn").setStorageType(StorageConfigInfo.StorageTypeEnum.S3).setAllowedLocations(List.of("s3://my-old-bucket/path/to/data")).build();
        CatalogProperties props = new CatalogProperties("s3://my-bucket/path/to/data");
        props.putAll(Map.of("table-default.s3.endpoint", s3Container.getHttpEndpoint(), "table-default.s3.path-style-access", "true", "table-default.s3.access-key-id", "foo", "table-default.s3.secret-access-key", "bar", "s3.endpoint", s3Container.getHttpEndpoint(), "s3.path-style-access", "true", "s3.access-key-id", "foo", "s3.secret-access-key", "bar", "polaris.config.drop-with-purge.enabled", "true"));
        PolarisCatalog catalog = PolarisCatalog.builder().setType(Catalog.TypeEnum.INTERNAL).setName(this.catalogName).setProperties(props).setStorageConfigInfo((StorageConfigInfo)awsConfigModel).build();
        this.managementApi.createCatalog((Catalog)catalog);
        CatalogProperties externalProps = new CatalogProperties("s3://my-bucket/path/to/data");
        externalProps.putAll(Map.of("table-default.s3.endpoint", s3Container.getHttpEndpoint(), "table-default.s3.path-style-access", "true", "table-default.s3.access-key-id", "foo", "table-default.s3.secret-access-key", "bar", "s3.endpoint", s3Container.getHttpEndpoint(), "s3.path-style-access", "true", "s3.access-key-id", "foo", "s3.secret-access-key", "bar", "polaris.config.drop-with-purge.enabled", "true"));
        ExternalCatalog externalCatalog = ExternalCatalog.builder().setType(Catalog.TypeEnum.EXTERNAL).setName(this.externalCatalogName).setProperties(externalProps).setStorageConfigInfo((StorageConfigInfo)awsConfigModel).build();
        this.managementApi.createCatalog((Catalog)externalCatalog);
        SparkSession.Builder sessionBuilder = SparkSession.builder().master("local[1]").config("spark.hadoop.fs.s3.impl", "org.apache.hadoop.fs.s3a.S3AFileSystem").config("spark.hadoop.fs.s3.aws.credentials.provider", "org.apache.hadoop.fs.s3.TemporaryAWSCredentialsProvider").config("spark.hadoop.fs.s3.access.key", "foo").config("spark.hadoop.fs.s3.secret.key", "bar").config("spark.sql.extensions", "org.apache.iceberg.spark.extensions.IcebergSparkSessionExtensions").config("spark.ui.showConsoleProgress", false).config("spark.ui.enabled", "false");
        spark = this.withCatalog(this.withCatalog(sessionBuilder, this.catalogName), this.externalCatalogName).getOrCreate();
        PolarisSparkIntegrationTestBase.onSpark("USE " + this.catalogName);
    }

    protected SparkSession.Builder withCatalog(SparkSession.Builder builder, String catalogName) {
        return builder.config(String.format("spark.sql.catalog.%s", catalogName), "org.apache.iceberg.spark.SparkCatalog").config("spark.sql.warehouse.dir", this.warehouseDir.toString()).config(String.format("spark.sql.catalog.%s.type", catalogName), "rest").config(String.format("spark.sql.catalog.%s.uri", catalogName), this.endpoints.catalogApiEndpoint().toString()).config(String.format("spark.sql.catalog.%s.warehouse", catalogName), catalogName).config(String.format("spark.sql.catalog.%s.scope", catalogName), "PRINCIPAL_ROLE:ALL").config(String.format("spark.sql.catalog.%s.header.realm", catalogName), this.endpoints.realmId()).config(String.format("spark.sql.catalog.%s.token", catalogName), this.sparkToken).config(String.format("spark.sql.catalog.%s.s3.access-key-id", catalogName), "fakekey").config(String.format("spark.sql.catalog.%s.s3.secret-access-key", catalogName), "fakesecret").config(String.format("spark.sql.catalog.%s.s3.region", catalogName), "us-west-2");
    }

    @AfterEach
    public void after() throws Exception {
        this.cleanupCatalog(this.catalogName);
        this.cleanupCatalog(this.externalCatalogName);
        try {
            SparkSession.clearDefaultSession();
            SparkSession.clearActiveSession();
            spark.close();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Unable to close spark session", (Throwable)e);
        }
        this.client.close();
    }

    protected void cleanupCatalog(String catalogName) {
        PolarisSparkIntegrationTestBase.onSpark("USE " + catalogName);
        List namespaces = PolarisSparkIntegrationTestBase.onSpark("SHOW NAMESPACES").collectAsList();
        for (Row namespace : namespaces) {
            List tables = PolarisSparkIntegrationTestBase.onSpark("SHOW TABLES IN " + namespace.getString(0)).collectAsList();
            for (Row table : tables) {
                PolarisSparkIntegrationTestBase.onSpark("DROP TABLE " + namespace.getString(0) + "." + table.getString(1));
            }
            List views = PolarisSparkIntegrationTestBase.onSpark("SHOW VIEWS IN " + namespace.getString(0)).collectAsList();
            for (Row view : views) {
                PolarisSparkIntegrationTestBase.onSpark("DROP VIEW " + namespace.getString(0) + "." + view.getString(1));
            }
            PolarisSparkIntegrationTestBase.onSpark("DROP NAMESPACE " + namespace.getString(0));
        }
        this.managementApi.deleteCatalog(catalogName);
    }

    protected static Dataset<Row> onSpark(@Language(value="SQL") String sql) {
        return spark.sql(sql);
    }
}

