/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.env;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.polaris.service.it.env.PolarisApiEndpoints;

public class RestApi {
    private final Client client;
    private final PolarisApiEndpoints endpoints;
    private final String authToken;
    private final URI uri;

    RestApi(Client client, PolarisApiEndpoints endpoints, String authToken, URI uri) {
        this.client = client;
        this.endpoints = endpoints;
        this.authToken = authToken;
        this.uri = uri;
    }

    public Invocation.Builder request(String path) {
        return this.request(path, Map.of());
    }

    public Invocation.Builder request(String path, Map<String, String> templateValues) {
        return this.request(path, templateValues, Map.of());
    }

    protected Map<String, String> defaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(this.endpoints.realmHeaderName(), this.endpoints.realmId());
        if (this.authToken != null) {
            headers.put("Authorization", "Bearer " + this.authToken);
        }
        return headers;
    }

    public Invocation.Builder request(String path, Map<String, String> templateValues, Map<String, String> queryParams) {
        return this.request(path, templateValues, queryParams, this.defaultHeaders());
    }

    public Invocation.Builder request(String path, Map<String, String> templateValues, Map<String, String> queryParams, Map<String, String> headers) {
        WebTarget target = this.client.target(this.uri).path(path);
        for (Map.Entry<String, String> entry : templateValues.entrySet()) {
            target = target.resolveTemplate(entry.getKey(), (Object)entry.getValue());
        }
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            target = target.queryParam(entry.getKey(), new Object[]{entry.getValue()});
        }
        Invocation.Builder request = target.request(new String[]{"application/json"});
        headers.forEach((arg_0, arg_1) -> ((Invocation.Builder)request).header(arg_0, arg_1));
        return request;
    }
}

