/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.env;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.nio.file.Path;
import java.util.function.Function;

public final class IntegrationTestsHelper {
    public static final String INTEGRATION_TEST_TEMP_DIR_ENV_VAR = "INTEGRATION_TEST_TEMP_DIR";

    private IntegrationTestsHelper() {
    }

    public static URI getTemporaryDirectory(Path defaultLocalDirectory) {
        return IntegrationTestsHelper.getTemporaryDirectory(System::getenv, defaultLocalDirectory);
    }

    @VisibleForTesting
    static URI getTemporaryDirectory(Function<String, String> getenv, Path defaultLocalDirectory) {
        Object envVar = getenv.apply(INTEGRATION_TEST_TEMP_DIR_ENV_VAR);
        envVar = envVar != null ? envVar : defaultLocalDirectory.toString();
        envVar = ((String)envVar).startsWith("/") ? "file://" + (String)envVar : envVar;
        return URI.create((String)envVar + "/").normalize();
    }
}

