/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.it.env;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.polaris.core.admin.model.PrincipalWithCredentials;
import org.apache.polaris.service.it.env.PolarisApiEndpoints;
import org.apache.polaris.service.it.env.PolarisClient;

public final class IcebergHelper {
    private IcebergHelper() {
    }

    public static RESTCatalog restCatalog(PolarisClient client, PolarisApiEndpoints endpoints, PrincipalWithCredentials credentials, String catalog, Map<String, String> extraProperties) {
        String authToken = client.obtainToken(credentials);
        RESTCatalog restCatalog = new RESTCatalog();
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder().put((Object)"uri", (Object)endpoints.catalogApiEndpoint().toString()).put((Object)"token", (Object)authToken).put((Object)"io-impl", (Object)"org.apache.iceberg.inmemory.InMemoryFileIO").put((Object)"warehouse", (Object)catalog).put((Object)("header." + endpoints.realmHeaderName()), (Object)endpoints.realmId()).putAll(extraProperties);
        restCatalog.initialize("polaris", (Map)propertiesBuilder.buildKeepingLast());
        return restCatalog;
    }
}

