/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.spark.utils;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.iceberg.rest.RESTSessionCatalog;
import org.apache.iceberg.rest.auth.OAuth2Util;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.polaris.spark.rest.GenericTable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Option;

public class PolarisCatalogUtils {
    public static final String TABLE_PROVIDER_KEY = "provider";
    public static final String TABLE_PATH_KEY = "path";

    public static boolean useIceberg(String provider) {
        return provider == null || "iceberg".equalsIgnoreCase(provider);
    }

    public static boolean useDelta(String provider) {
        return "delta".equalsIgnoreCase(provider);
    }

    public static boolean isTableWithSparkManagedLocation(Map<String, String> properties) {
        boolean hasLocationClause = properties.containsKey("location");
        boolean hasPathClause = properties.containsKey(TABLE_PATH_KEY);
        return !hasLocationClause && !hasPathClause;
    }

    public static Table loadSparkTable(GenericTable genericTable) {
        SparkSession sparkSession = SparkSession.active();
        TableProvider provider = (TableProvider)DataSource.lookupDataSourceV2((String)genericTable.getFormat(), (SQLConf)sparkSession.sessionState().conf()).get();
        Map<String, String> properties = genericTable.getProperties();
        boolean hasLocationClause = properties.get("location") != null;
        boolean hasPathClause = properties.get(TABLE_PATH_KEY) != null;
        HashMap tableProperties = Maps.newHashMap();
        tableProperties.putAll(properties);
        if (!hasPathClause && hasLocationClause) {
            tableProperties.put(TABLE_PATH_KEY, properties.get("location"));
        }
        return DataSourceV2Utils.getTableFromProvider((TableProvider)provider, (CaseInsensitiveStringMap)new CaseInsensitiveStringMap((Map)tableProperties), (Option)Option.empty());
    }

    public static OAuth2Util.AuthSession getAuthSession(SparkCatalog sparkCatalog) {
        try {
            RESTCatalog icebergRestCatalog;
            Field icebergCatalogField = sparkCatalog.getClass().getDeclaredField("icebergCatalog");
            icebergCatalogField.setAccessible(true);
            Catalog icebergCatalog = (Catalog)icebergCatalogField.get(sparkCatalog);
            if (icebergCatalog instanceof CachingCatalog) {
                Field catalogField = icebergCatalog.getClass().getDeclaredField("catalog");
                catalogField.setAccessible(true);
                icebergRestCatalog = (RESTCatalog)catalogField.get(icebergCatalog);
            } else {
                icebergRestCatalog = (RESTCatalog)icebergCatalog;
            }
            Field sessionCatalogField = icebergRestCatalog.getClass().getDeclaredField("sessionCatalog");
            sessionCatalogField.setAccessible(true);
            RESTSessionCatalog sessionCatalog = (RESTSessionCatalog)sessionCatalogField.get(icebergRestCatalog);
            Field authField = sessionCatalog.getClass().getDeclaredField("catalogAuth");
            authField.setAccessible(true);
            return (OAuth2Util.AuthSession)authField.get(sessionCatalog);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get the catalogAuth from the Iceberg SparkCatalog", e);
        }
    }
}

