/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.spark.rest;

import jakarta.validation.Valid;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;

public class ListGenericTablesResponse {
    private final String nextPageToken;
    @Valid
    private final @Valid Set<@Valid TableIdentifier> identifiers;

    @JsonProperty(value="next-page-token")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    @JsonProperty(value="identifiers")
    public Set<@Valid TableIdentifier> getIdentifiers() {
        return this.identifiers;
    }

    @JsonCreator
    public ListGenericTablesResponse(@JsonProperty(value="next-page-token") String nextPageToken, @JsonProperty(value="identifiers") Set<@Valid TableIdentifier> identifiers) {
        this.nextPageToken = nextPageToken;
        this.identifiers = Objects.requireNonNullElse(identifiers, new LinkedHashSet());
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListGenericTablesResponse listGenericTablesResponse = (ListGenericTablesResponse)o;
        return Objects.equals(this.nextPageToken, listGenericTablesResponse.nextPageToken) && Objects.equals(this.identifiers, listGenericTablesResponse.identifiers);
    }

    public int hashCode() {
        return Objects.hash(this.nextPageToken, this.identifiers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListGenericTablesResponse {\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("    identifiers: ").append(this.toIndentedString(this.identifiers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String nextPageToken;
        private Set<@Valid TableIdentifier> identifiers;

        private Builder() {
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public Builder setIdentifiers(Set<@Valid TableIdentifier> identifiers) {
            this.identifiers = identifiers;
            return this;
        }

        public ListGenericTablesResponse build() {
            ListGenericTablesResponse inst = new ListGenericTablesResponse(this.nextPageToken, this.identifiers);
            return inst;
        }
    }
}

