/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.spark.rest;

import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;

public class CreateGenericTableRequest {
    @NotNull
    private final String name;
    @NotNull
    private final String format;
    private final String baseLocation;
    private final String doc;
    private final Map<String, String> properties;

    @JsonProperty(value="name", required=true)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="format", required=true)
    public String getFormat() {
        return this.format;
    }

    @JsonProperty(value="base-location")
    public String getBaseLocation() {
        return this.baseLocation;
    }

    @JsonProperty(value="doc")
    public String getDoc() {
        return this.doc;
    }

    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonCreator
    public CreateGenericTableRequest(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="format", required=true) String format, @JsonProperty(value="base-location") String baseLocation, @JsonProperty(value="doc") String doc, @JsonProperty(value="properties") Map<String, String> properties) {
        this.name = name;
        this.format = format;
        this.baseLocation = baseLocation;
        this.doc = doc;
        this.properties = Objects.requireNonNullElse(properties, new HashMap());
    }

    public CreateGenericTableRequest(String name, String format) {
        this.name = name;
        this.format = format;
        this.baseLocation = null;
        this.doc = null;
        this.properties = new HashMap<String, String>();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name, String format) {
        return new Builder(name, format);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateGenericTableRequest createGenericTableRequest = (CreateGenericTableRequest)o;
        return Objects.equals(this.name, createGenericTableRequest.name) && Objects.equals(this.format, createGenericTableRequest.format) && Objects.equals(this.baseLocation, createGenericTableRequest.baseLocation) && Objects.equals(this.doc, createGenericTableRequest.doc) && Objects.equals(this.properties, createGenericTableRequest.properties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.format, this.baseLocation, this.doc, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateGenericTableRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    baseLocation: ").append(this.toIndentedString(this.baseLocation)).append("\n");
        sb.append("    doc: ").append(this.toIndentedString(this.doc)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String name;
        private String format;
        private String baseLocation;
        private String doc;
        private Map<String, String> properties;

        private Builder() {
        }

        private Builder(String name, String format) {
            this.name = name;
            this.format = format;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setFormat(String format) {
            this.format = format;
            return this;
        }

        public Builder setBaseLocation(String baseLocation) {
            this.baseLocation = baseLocation;
            return this;
        }

        public Builder setDoc(String doc) {
            this.doc = doc;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public CreateGenericTableRequest build() {
            CreateGenericTableRequest inst = new CreateGenericTableRequest(this.name, this.format, this.baseLocation, this.doc, this.properties);
            return inst;
        }
    }
}

