/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.spark;

import java.util.Map;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.polaris.spark.PolarisCatalog;
import org.apache.polaris.spark.rest.GenericTable;
import org.apache.polaris.spark.utils.PolarisCatalogUtils;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class PolarisSparkCatalog
implements TableCatalog {
    private PolarisCatalog polarisCatalog = null;
    private String catalogName = null;

    public PolarisSparkCatalog(PolarisCatalog polarisCatalog) {
        this.polarisCatalog = polarisCatalog;
    }

    public void initialize(String name, CaseInsensitiveStringMap options) {
        this.catalogName = name;
    }

    public String name() {
        return this.catalogName;
    }

    public Table loadTable(Identifier identifier) throws NoSuchTableException {
        try {
            GenericTable genericTable = this.polarisCatalog.loadGenericTable(Spark3Util.identifierToTableIdentifier((Identifier)identifier));
            return PolarisCatalogUtils.loadSparkTable(genericTable);
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException(identifier);
        }
    }

    public Table createTable(Identifier identifier, StructType schema, Transform[] transforms, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        try {
            String format = properties.get("provider");
            GenericTable genericTable = this.polarisCatalog.createGenericTable(Spark3Util.identifierToTableIdentifier((Identifier)identifier), format, null, properties);
            return PolarisCatalogUtils.loadSparkTable(genericTable);
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(identifier);
        }
    }

    public Table alterTable(Identifier identifier, TableChange ... changes) throws NoSuchTableException {
        throw new UnsupportedOperationException("alterTable operation is not supported");
    }

    public boolean purgeTable(Identifier ident) {
        return this.dropTable(ident);
    }

    public boolean dropTable(Identifier identifier) {
        return this.polarisCatalog.dropGenericTable(Spark3Util.identifierToTableIdentifier((Identifier)identifier));
    }

    public void renameTable(Identifier from, Identifier to) throws NoSuchTableException, TableAlreadyExistsException {
        throw new UnsupportedOperationException("renameTable operation is not supported");
    }

    public Identifier[] listTables(String[] namespace) {
        try {
            return (Identifier[])this.polarisCatalog.listGenericTables(Namespace.of((String[])namespace)).stream().map(ident -> Identifier.of((String[])ident.namespace().levels(), (String)ident.name())).toArray(Identifier[]::new);
        }
        catch (UnsupportedOperationException ex) {
            return new Identifier[0];
        }
    }
}

