/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.spark;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.rest.Endpoint;
import org.apache.iceberg.rest.ErrorHandlers;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.ResourcePaths;
import org.apache.iceberg.rest.auth.AuthSession;
import org.apache.iceberg.rest.auth.OAuth2Util;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.util.EnvironmentUtil;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.polaris.core.rest.PolarisEndpoints;
import org.apache.polaris.core.rest.PolarisResourcePaths;
import org.apache.polaris.spark.PolarisCatalog;
import org.apache.polaris.spark.rest.CreateGenericTableRESTRequest;
import org.apache.polaris.spark.rest.CreateGenericTableRequest;
import org.apache.polaris.spark.rest.GenericTable;
import org.apache.polaris.spark.rest.ListGenericTablesRESTResponse;
import org.apache.polaris.spark.rest.LoadGenericTableRESTResponse;

public class PolarisRESTCatalog
implements PolarisCatalog,
Closeable {
    public static final String REST_PAGE_SIZE = "rest-page-size";
    private final Function<Map<String, String>, RESTClient> clientBuilder;
    private RESTClient restClient = null;
    private CloseableGroup closeables = null;
    private Set<Endpoint> endpoints;
    private OAuth2Util.AuthSession catalogAuth = null;
    private PolarisResourcePaths pathGenerator = null;
    private Integer pageSize = null;
    private static final Set<Endpoint> DEFAULT_ENDPOINTS = PolarisEndpoints.GENERIC_TABLE_ENDPOINTS;

    public PolarisRESTCatalog() {
        this(config -> HTTPClient.builder((Map)config).uri((String)config.get("uri")).build());
    }

    public PolarisRESTCatalog(Function<Map<String, String>, RESTClient> clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    public void initialize(Map<String, String> unresolved, OAuth2Util.AuthSession catalogAuth) {
        ConfigResponse config;
        Preconditions.checkArgument((unresolved != null ? 1 : 0) != 0, (Object)"Invalid configuration: null");
        Map props = EnvironmentUtil.resolveAll(unresolved);
        this.catalogAuth = catalogAuth;
        try (RESTClient initClient = this.clientBuilder.apply(props).withAuthSession((AuthSession)catalogAuth);){
            config = PolarisRESTCatalog.fetchConfig(initClient, catalogAuth.headers(), props);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close HTTP client", e);
        }
        Map mergedProps = config.merge(props);
        this.endpoints = config.endpoints().isEmpty() ? DEFAULT_ENDPOINTS : ImmutableSet.copyOf((Collection)config.endpoints());
        this.pathGenerator = PolarisResourcePaths.forCatalogProperties((Map)mergedProps);
        this.restClient = this.clientBuilder.apply(mergedProps).withAuthSession((AuthSession)catalogAuth);
        this.pageSize = PropertyUtil.propertyAsNullableInt((Map)mergedProps, (String)REST_PAGE_SIZE);
        if (this.pageSize != null) {
            Preconditions.checkArgument((this.pageSize > 0 ? 1 : 0) != 0, (String)"Invalid value for %s, must be a positive integer", (Object[])new Object[]{REST_PAGE_SIZE});
        }
        this.closeables = new CloseableGroup();
        this.closeables.addCloseable((Closeable)this.restClient);
        this.closeables.setSuppressCloseFailure(true);
    }

    protected static ConfigResponse fetchConfig(RESTClient client, Map<String, String> headers, Map<String, String> properties) {
        ImmutableMap.Builder queryParams = ImmutableMap.builder();
        if (properties.containsKey("warehouse")) {
            queryParams.put((Object)"warehouse", (Object)properties.get("warehouse"));
        }
        ConfigResponse configResponse = (ConfigResponse)client.get(ResourcePaths.config(), (Map)queryParams.build(), ConfigResponse.class, headers, ErrorHandlers.defaultErrorHandler());
        configResponse.validate();
        return configResponse;
    }

    @Override
    public void close() throws IOException {
        if (this.closeables != null) {
            this.closeables.close();
        }
    }

    @Override
    public List<TableIdentifier> listGenericTables(Namespace ns) {
        Endpoint.check(this.endpoints, (Endpoint)PolarisEndpoints.V1_LIST_GENERIC_TABLES);
        HashMap queryParams = Maps.newHashMap();
        ImmutableList.Builder tables = ImmutableList.builder();
        String pageToken = "";
        if (this.pageSize != null) {
            queryParams.put("pageSize", String.valueOf(this.pageSize));
        }
        do {
            queryParams.put("pageToken", pageToken);
            ListGenericTablesRESTResponse response = (ListGenericTablesRESTResponse)this.restClient.withAuthSession((AuthSession)this.catalogAuth).get(this.pathGenerator.genericTables(ns), (Map)queryParams, ListGenericTablesRESTResponse.class, Map.of(), ErrorHandlers.namespaceErrorHandler());
            pageToken = response.getNextPageToken();
            tables.addAll(response.getIdentifiers());
        } while (pageToken != null);
        return tables.build();
    }

    @Override
    public boolean dropGenericTable(TableIdentifier identifier) {
        Endpoint.check(this.endpoints, (Endpoint)PolarisEndpoints.V1_DELETE_GENERIC_TABLE);
        try {
            this.restClient.withAuthSession((AuthSession)this.catalogAuth).delete(this.pathGenerator.genericTable(identifier), null, Map.of(), ErrorHandlers.tableErrorHandler());
            return true;
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    @Override
    public GenericTable createGenericTable(TableIdentifier identifier, String format, String doc, Map<String, String> props) {
        Endpoint.check(this.endpoints, (Endpoint)PolarisEndpoints.V1_CREATE_GENERIC_TABLE);
        CreateGenericTableRESTRequest request = new CreateGenericTableRESTRequest(CreateGenericTableRequest.builder().setName(identifier.name()).setFormat(format).setDoc(doc).setProperties(props).build());
        LoadGenericTableRESTResponse response = (LoadGenericTableRESTResponse)this.restClient.withAuthSession((AuthSession)this.catalogAuth).post(this.pathGenerator.genericTables(identifier.namespace()), (RESTRequest)request, LoadGenericTableRESTResponse.class, Map.of(), ErrorHandlers.tableErrorHandler());
        return response.getTable();
    }

    @Override
    public GenericTable loadGenericTable(TableIdentifier identifier) {
        Endpoint.check(this.endpoints, (Endpoint)PolarisEndpoints.V1_LOAD_GENERIC_TABLE);
        LoadGenericTableRESTResponse response = (LoadGenericTableRESTResponse)this.restClient.withAuthSession((AuthSession)this.catalogAuth).get(this.pathGenerator.genericTable(identifier), null, LoadGenericTableRESTResponse.class, Map.of(), ErrorHandlers.tableErrorHandler());
        return response.getTable();
    }
}

