/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.spark.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.iceberg.common.DynConstructors;
import org.apache.polaris.spark.PolarisSparkCatalog;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.DelegatingCatalogExtension;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DeltaHelper.class);
    public static final String DELTA_CATALOG_IMPL_KEY = "delta-catalog-impl";
    private static final String DEFAULT_DELTA_CATALOG_CLASS = "org.apache.spark.sql.delta.catalog.DeltaCatalog";
    private TableCatalog deltaCatalog = null;
    private String deltaCatalogImpl = "org.apache.spark.sql.delta.catalog.DeltaCatalog";

    public DeltaHelper(CaseInsensitiveStringMap options) {
        if (options.get((Object)DELTA_CATALOG_IMPL_KEY) != null) {
            this.deltaCatalogImpl = options.get((Object)DELTA_CATALOG_IMPL_KEY);
        }
    }

    public TableCatalog loadDeltaCatalog(PolarisSparkCatalog polarisSparkCatalog) {
        DynConstructors.Ctor ctor;
        if (this.deltaCatalog != null) {
            return this.deltaCatalog;
        }
        try {
            ctor = DynConstructors.builder(TableCatalog.class).impl(this.deltaCatalogImpl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize Delta Catalog %s: %s", this.deltaCatalogImpl, e.getMessage()), e);
        }
        try {
            this.deltaCatalog = (TableCatalog)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize Delta Catalog, %s does not implement Table Catalog.", this.deltaCatalogImpl), e);
        }
        ((DelegatingCatalogExtension)this.deltaCatalog).setDelegateCatalog((CatalogPlugin)polarisSparkCatalog);
        try {
            String methodGetName = "isUnityCatalog$lzycompute";
            Method method = this.deltaCatalog.getClass().getDeclaredMethod(methodGetName, new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this.deltaCatalog, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.warn("No lazy compute method found for variable isUnityCatalog");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke the lazy compute methods for isUnityCatalog", e);
        }
        try {
            Field field = this.deltaCatalog.getClass().getDeclaredField("isUnityCatalog");
            field.setAccessible(true);
            field.set(this.deltaCatalog, true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Failed find the isUnityCatalog field, delta-spark version >= 3.2.1 is required", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to set the isUnityCatalog field", e);
        }
        return this.deltaCatalog;
    }
}

