/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.spark;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.arrow.util.VisibleForTesting;
import org.apache.iceberg.rest.auth.OAuth2Util;
import org.apache.iceberg.spark.SupportsReplaceView;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.polaris.spark.PolarisRESTCatalog;
import org.apache.polaris.spark.PolarisSparkCatalog;
import org.apache.polaris.spark.utils.DeltaHelper;
import org.apache.polaris.spark.utils.PolarisCatalogUtils;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.NoSuchViewException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.ViewAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.StagedTable;
import org.apache.spark.sql.connector.catalog.StagingTableCatalog;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.View;
import org.apache.spark.sql.connector.catalog.ViewCatalog;
import org.apache.spark.sql.connector.catalog.ViewChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkCatalog
implements StagingTableCatalog,
TableCatalog,
SupportsNamespaces,
ViewCatalog,
SupportsReplaceView {
    private static final Logger LOG = LoggerFactory.getLogger(SparkCatalog.class);
    @VisibleForTesting
    protected String catalogName = null;
    @VisibleForTesting
    protected org.apache.iceberg.spark.SparkCatalog icebergsSparkCatalog = null;
    @VisibleForTesting
    protected PolarisSparkCatalog polarisSparkCatalog = null;
    @VisibleForTesting
    protected DeltaHelper deltaHelper = null;

    public String name() {
        return this.catalogName;
    }

    @VisibleForTesting
    public CaseInsensitiveStringMap validateAndResolveCatalogOptions(CaseInsensitiveStringMap options) {
        Preconditions.checkArgument((options.get((Object)"catalog-impl") == null ? 1 : 0) != 0, (Object)"Customized catalog implementation is not supported and not needed, please remove the configuration!");
        String catalogType = PropertyUtil.propertyAsString((Map)options, (String)"type", (String)"rest");
        Preconditions.checkArgument((boolean)catalogType.equals("rest"), (Object)("Only rest catalog type is allowed, but got catalog type: " + catalogType + ". Either configure the type to rest or remove the config"));
        HashMap resolvedOptions = Maps.newHashMap();
        resolvedOptions.putAll(options);
        resolvedOptions.put("type", "rest");
        return new CaseInsensitiveStringMap((Map)resolvedOptions);
    }

    private void initRESTCatalog(String name, CaseInsensitiveStringMap options) {
        CaseInsensitiveStringMap resolvedOptions = this.validateAndResolveCatalogOptions(options);
        this.icebergsSparkCatalog = new org.apache.iceberg.spark.SparkCatalog();
        this.icebergsSparkCatalog.initialize(name, resolvedOptions);
        OAuth2Util.AuthSession catalogAuth = PolarisCatalogUtils.getAuthSession(this.icebergsSparkCatalog);
        PolarisRESTCatalog restCatalog = new PolarisRESTCatalog();
        restCatalog.initialize((Map<String, String>)options, catalogAuth);
        this.polarisSparkCatalog = new PolarisSparkCatalog(restCatalog);
        this.polarisSparkCatalog.initialize(name, resolvedOptions);
    }

    public void initialize(String name, CaseInsensitiveStringMap options) {
        this.catalogName = name;
        this.initRESTCatalog(name, options);
        this.deltaHelper = new DeltaHelper(options);
    }

    public Table loadTable(Identifier ident) throws NoSuchTableException {
        try {
            return this.icebergsSparkCatalog.loadTable(ident);
        }
        catch (NoSuchTableException e) {
            return this.polarisSparkCatalog.loadTable(ident);
        }
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        String provider = properties.get("provider");
        if (PolarisCatalogUtils.useIceberg(provider)) {
            return this.icebergsSparkCatalog.createTable(ident, schema, transforms, properties);
        }
        if (PolarisCatalogUtils.isTableWithSparkManagedLocation(properties)) {
            throw new UnsupportedOperationException("Create table without location key is not supported by Polaris. Please provide location or path on table creation.");
        }
        if (PolarisCatalogUtils.useDelta(provider)) {
            TableCatalog deltaCatalog = this.deltaHelper.loadDeltaCatalog(this.polarisSparkCatalog);
            return deltaCatalog.createTable(ident, schema, transforms, properties);
        }
        return this.polarisSparkCatalog.createTable(ident, schema, transforms, properties);
    }

    public Table alterTable(Identifier ident, TableChange ... changes) throws NoSuchTableException {
        try {
            return this.icebergsSparkCatalog.alterTable(ident, changes);
        }
        catch (NoSuchTableException e) {
            Table table = this.polarisSparkCatalog.loadTable(ident);
            String provider = (String)table.properties().get("provider");
            if (PolarisCatalogUtils.useDelta(provider)) {
                TableCatalog deltaCatalog = this.deltaHelper.loadDeltaCatalog(this.polarisSparkCatalog);
                return deltaCatalog.alterTable(ident, changes);
            }
            return this.polarisSparkCatalog.alterTable(ident, new TableChange[0]);
        }
    }

    public boolean dropTable(Identifier ident) {
        return this.icebergsSparkCatalog.dropTable(ident) || this.polarisSparkCatalog.dropTable(ident);
    }

    public void renameTable(Identifier from, Identifier to) throws NoSuchTableException, TableAlreadyExistsException {
        try {
            this.icebergsSparkCatalog.renameTable(from, to);
        }
        catch (NoSuchTableException e) {
            this.polarisSparkCatalog.renameTable(from, to);
        }
    }

    public void invalidateTable(Identifier ident) {
        this.icebergsSparkCatalog.invalidateTable(ident);
    }

    public boolean purgeTable(Identifier ident) {
        if (this.icebergsSparkCatalog.purgeTable(ident)) {
            return true;
        }
        return this.polarisSparkCatalog.purgeTable(ident);
    }

    public Identifier[] listTables(String[] namespace) {
        Identifier[] icebergIdents = this.icebergsSparkCatalog.listTables(namespace);
        Identifier[] genericTableIdents = this.polarisSparkCatalog.listTables(namespace);
        return (Identifier[])Stream.concat(Arrays.stream(icebergIdents), Arrays.stream(genericTableIdents)).toArray(Identifier[]::new);
    }

    public StagedTable stageCreate(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) throws TableAlreadyExistsException {
        return this.icebergsSparkCatalog.stageCreate(ident, schema, transforms, properties);
    }

    public StagedTable stageReplace(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) throws NoSuchTableException {
        return this.icebergsSparkCatalog.stageReplace(ident, schema, transforms, properties);
    }

    public StagedTable stageCreateOrReplace(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) {
        return this.icebergsSparkCatalog.stageCreateOrReplace(ident, schema, transforms, properties);
    }

    public String[] defaultNamespace() {
        return this.icebergsSparkCatalog.defaultNamespace();
    }

    public String[][] listNamespaces() {
        return this.icebergsSparkCatalog.listNamespaces();
    }

    public String[][] listNamespaces(String[] namespace) throws NoSuchNamespaceException {
        return this.icebergsSparkCatalog.listNamespaces(namespace);
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws NoSuchNamespaceException {
        return this.icebergsSparkCatalog.loadNamespaceMetadata(namespace);
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) throws NamespaceAlreadyExistsException {
        this.icebergsSparkCatalog.createNamespace(namespace, metadata);
    }

    public void alterNamespace(String[] namespace, NamespaceChange ... changes) throws NoSuchNamespaceException {
        this.icebergsSparkCatalog.alterNamespace(namespace, changes);
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) throws NoSuchNamespaceException {
        return this.icebergsSparkCatalog.dropNamespace(namespace, cascade);
    }

    public Identifier[] listViews(String ... namespace) {
        return this.icebergsSparkCatalog.listViews(namespace);
    }

    public View loadView(Identifier ident) throws NoSuchViewException {
        return this.icebergsSparkCatalog.loadView(ident);
    }

    public View createView(Identifier ident, String sql, String currentCatalog, String[] currentNamespace, StructType schema, String[] queryColumnNames, String[] columnAliases, String[] columnComments, Map<String, String> properties) throws ViewAlreadyExistsException, NoSuchNamespaceException {
        return this.icebergsSparkCatalog.createView(ident, sql, currentCatalog, currentNamespace, schema, queryColumnNames, columnAliases, columnComments, properties);
    }

    public View alterView(Identifier ident, ViewChange ... changes) throws NoSuchViewException, IllegalArgumentException {
        return this.icebergsSparkCatalog.alterView(ident, changes);
    }

    public boolean dropView(Identifier ident) {
        return this.icebergsSparkCatalog.dropView(ident);
    }

    public void renameView(Identifier fromIdentifier, Identifier toIdentifier) throws NoSuchViewException, ViewAlreadyExistsException {
        this.icebergsSparkCatalog.renameView(fromIdentifier, toIdentifier);
    }

    public View replaceView(Identifier ident, String sql, String currentCatalog, String[] currentNamespace, StructType schema, String[] queryColumnNames, String[] columnAliases, String[] columnComments, Map<String, String> properties) throws NoSuchNamespaceException, NoSuchViewException {
        return this.icebergsSparkCatalog.replaceView(ident, sql, currentCatalog, currentNamespace, schema, queryColumnNames, columnAliases, columnComments, properties);
    }
}

