/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.storage;

import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.ServiceOptions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.storage.PolarisStorageActions;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageIntegration;
import org.apache.polaris.core.storage.PolarisStorageIntegrationProvider;
import org.apache.polaris.core.storage.StorageAccessProperty;
import org.apache.polaris.core.storage.aws.AwsCredentialsStorageIntegration;
import org.apache.polaris.core.storage.aws.StsClientProvider;
import org.apache.polaris.core.storage.azure.AzureCredentialsStorageIntegration;
import org.apache.polaris.core.storage.gcp.GcpCredentialsStorageIntegration;
import org.apache.polaris.service.storage.StorageConfiguration;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@ApplicationScoped
public class PolarisStorageIntegrationProviderImpl
implements PolarisStorageIntegrationProvider {
    private final StsClientProvider stsClientProvider;
    private final Optional<AwsCredentialsProvider> stsCredentials;
    private final Supplier<GoogleCredentials> gcpCredsProvider;

    @Inject
    public PolarisStorageIntegrationProviderImpl(StorageConfiguration storageConfiguration, StsClientProvider stsClientProvider) {
        this(stsClientProvider, Optional.ofNullable(storageConfiguration.stsCredentials()), storageConfiguration.gcpCredentialsSupplier());
    }

    public PolarisStorageIntegrationProviderImpl(StsClientProvider stsClientProvider, Optional<AwsCredentialsProvider> stsCredentials, Supplier<GoogleCredentials> gcpCredsProvider) {
        this.stsClientProvider = stsClientProvider;
        this.stsCredentials = stsCredentials;
        this.gcpCredsProvider = gcpCredsProvider;
    }

    @Nullable
    public <T extends PolarisStorageConfigurationInfo> PolarisStorageIntegration<T> getStorageIntegrationForConfig(PolarisStorageConfigurationInfo polarisStorageConfigurationInfo) {
        if (polarisStorageConfigurationInfo == null) {
            return null;
        }
        return switch (polarisStorageConfigurationInfo.getStorageType()) {
            case PolarisStorageConfigurationInfo.StorageType.S3 -> new AwsCredentialsStorageIntegration(this.stsClientProvider, this.stsCredentials);
            case PolarisStorageConfigurationInfo.StorageType.GCS -> new GcpCredentialsStorageIntegration(this.gcpCredsProvider.get(), (HttpTransportFactory)ServiceOptions.getFromServiceLoader(HttpTransportFactory.class, NetHttpTransport::new));
            case PolarisStorageConfigurationInfo.StorageType.AZURE -> new AzureCredentialsStorageIntegration();
            case PolarisStorageConfigurationInfo.StorageType.FILE -> new PolarisStorageIntegration<T>(this, "file"){

                public EnumMap<StorageAccessProperty, String> getSubscopedCreds(@Nonnull CallContext callContext, @Nonnull T storageConfig, boolean allowListOperation, @Nonnull Set<String> allowedReadLocations, @Nonnull Set<String> allowedWriteLocations) {
                    return new EnumMap<StorageAccessProperty, String>(StorageAccessProperty.class);
                }

                @Nonnull
                public Map<String, Map<PolarisStorageActions, PolarisStorageIntegration.ValidationResult>> validateAccessToLocations(@Nonnull T storageConfig, @Nonnull Set<PolarisStorageActions> actions, @Nonnull Set<String> locations) {
                    return Map.of();
                }
            };
            case PolarisStorageConfigurationInfo.StorageType.MFS -> new PolarisStorageIntegration<T>(this, "mfs"){

                public EnumMap<StorageAccessProperty, String> getSubscopedCreds(@Nonnull CallContext callContext, @Nonnull T storageConfig, boolean allowListOperation, @Nonnull Set<String> allowedReadLocations, @Nonnull Set<String> allowedWriteLocations) {
                    return new EnumMap<StorageAccessProperty, String>(StorageAccessProperty.class);
                }

                @Nonnull
                public Map<String, Map<PolarisStorageActions, PolarisStorageIntegration.ValidationResult>> validateAccessToLocations(@Nonnull T storageConfig, @Nonnull Set<PolarisStorageActions> actions, @Nonnull Set<String> locations) {
                    return Map.of();
                }
            };
            default -> throw new IllegalArgumentException("Unknown storage type " + String.valueOf(polarisStorageConfigurationInfo.getStorageType()));
        };
    }
}

