/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.core.SecurityContext;
import java.io.Closeable;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.UpdateRequirement;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.ViewCatalog;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.iceberg.rest.credentials.Credential;
import org.apache.iceberg.rest.credentials.ImmutableCredential;
import org.apache.iceberg.rest.requests.CommitTransactionRequest;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.auth.PolarisAuthorizableOperation;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.connection.ConnectionConfigInfoDpo;
import org.apache.polaris.core.connection.ConnectionType;
import org.apache.polaris.core.connection.hadoop.HadoopConnectionConfigInfoDpo;
import org.apache.polaris.core.connection.iceberg.IcebergRestConnectionConfigInfoDpo;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.table.IcebergTableLikeEntity;
import org.apache.polaris.core.persistence.PolarisEntityManager;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.TransactionWorkspaceMetaStoreManager;
import org.apache.polaris.core.persistence.dao.entity.EntitiesResult;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.apache.polaris.core.storage.AccessConfig;
import org.apache.polaris.core.storage.PolarisStorageActions;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.service.catalog.CatalogMfsUtils;
import org.apache.polaris.service.catalog.SupportsNotifications;
import org.apache.polaris.service.catalog.common.CatalogHandler;
import org.apache.polaris.service.catalog.iceberg.CatalogHandlerUtils;
import org.apache.polaris.service.catalog.iceberg.IcebergCatalog;
import org.apache.polaris.service.catalog.iceberg.SupportsCredentialDelegation;
import org.apache.polaris.service.config.ReservedProperties;
import org.apache.polaris.service.context.catalog.CallContextCatalogFactory;
import org.apache.polaris.service.http.IcebergHttpUtil;
import org.apache.polaris.service.http.IfNoneMatch;
import org.apache.polaris.service.types.NotificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCatalogHandler
extends CatalogHandler
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergCatalogHandler.class);
    private final PolarisMetaStoreManager metaStoreManager;
    private final UserSecretsManager userSecretsManager;
    private final CallContextCatalogFactory catalogFactory;
    private final ReservedProperties reservedProperties;
    private final CatalogHandlerUtils catalogHandlerUtils;
    protected Catalog baseCatalog = null;
    protected SupportsNamespaces namespaceCatalog = null;
    protected ViewCatalog viewCatalog = null;
    public static final String SNAPSHOTS_ALL = "all";
    public static final String SNAPSHOTS_REFS = "refs";

    public IcebergCatalogHandler(CallContext callContext, PolarisEntityManager entityManager, PolarisMetaStoreManager metaStoreManager, UserSecretsManager userSecretsManager, SecurityContext securityContext, CallContextCatalogFactory catalogFactory, String catalogName, PolarisAuthorizer authorizer, ReservedProperties reservedProperties, CatalogHandlerUtils catalogHandlerUtils) {
        super(callContext, entityManager, securityContext, catalogName, authorizer);
        this.metaStoreManager = metaStoreManager;
        this.userSecretsManager = userSecretsManager;
        this.catalogFactory = catalogFactory;
        this.reservedProperties = reservedProperties;
        this.catalogHandlerUtils = catalogHandlerUtils;
    }

    public static boolean isCreate(UpdateTableRequest request) {
        boolean isCreate = request.requirements().stream().anyMatch(UpdateRequirement.AssertTableDoesNotExist.class::isInstance);
        if (isCreate) {
            List invalidRequirements = request.requirements().stream().filter(req -> !(req instanceof UpdateRequirement.AssertTableDoesNotExist)).collect(Collectors.toList());
            Preconditions.checkArgument((boolean)invalidRequirements.isEmpty(), (String)"Invalid create requirements: %s", invalidRequirements);
        }
        return isCreate;
    }

    public ListNamespacesResponse listNamespaces(Namespace parent, String pageToken, Integer pageSize) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_NAMESPACES;
        this.authorizeBasicNamespaceOperationOrThrow(op, parent);
        Catalog catalog = this.baseCatalog;
        if (catalog instanceof IcebergCatalog) {
            IcebergCatalog polarisCatalog = (IcebergCatalog)catalog;
            Page<Namespace> results = polarisCatalog.listNamespaces(parent, pageToken, pageSize);
            return ListNamespacesResponse.builder().addAll((Collection)results.items).nextPageToken(results.pageToken.toTokenString()).build();
        }
        return this.catalogHandlerUtils.listNamespaces(this.namespaceCatalog, parent, pageToken, pageSize);
    }

    private UserSecretsManager getUserSecretsManager() {
        return this.userSecretsManager;
    }

    @Override
    protected void initializeCatalog() {
        CatalogEntity resolvedCatalogEntity = CatalogEntity.of((PolarisBaseEntity)this.resolutionManifest.getResolvedReferenceCatalogEntity().getRawLeafEntity());
        ConnectionConfigInfoDpo connectionConfigInfoDpo = resolvedCatalogEntity.getConnectionConfigInfoDpo();
        if (connectionConfigInfoDpo != null) {
            HadoopCatalog federatedCatalog;
            LOGGER.atInfo().addKeyValue("remoteUrl", (Object)connectionConfigInfoDpo.getUri()).log("Initializing federated catalog");
            FeatureConfiguration.enforceFeatureEnabledOrThrow((CallContext)this.callContext, (FeatureConfiguration)FeatureConfiguration.ENABLE_CATALOG_FEDERATION);
            ConnectionType connectionType = ConnectionType.fromCode((int)connectionConfigInfoDpo.getConnectionTypeCode());
            switch (connectionType) {
                case ICEBERG_REST: {
                    SessionCatalog.SessionContext context = SessionCatalog.SessionContext.createEmpty();
                    federatedCatalog = new RESTCatalog(context, config -> HTTPClient.builder((Map)config).uri((String)config.get("uri")).build());
                    federatedCatalog.initialize(((IcebergRestConnectionConfigInfoDpo)connectionConfigInfoDpo).getRemoteCatalogName(), connectionConfigInfoDpo.asIcebergCatalogProperties(this.getUserSecretsManager()));
                    break;
                }
                case HADOOP: {
                    federatedCatalog = new HadoopCatalog();
                    federatedCatalog.initialize(((HadoopConnectionConfigInfoDpo)connectionConfigInfoDpo).getWarehouse(), connectionConfigInfoDpo.asIcebergCatalogProperties(this.getUserSecretsManager()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Connection type not supported: " + String.valueOf(connectionType));
                }
            }
            this.baseCatalog = federatedCatalog;
        } else {
            LOGGER.atInfo().log("Initializing non-federated catalog");
            this.baseCatalog = this.catalogFactory.createCallContextCatalog(this.callContext, this.authenticatedPrincipal, this.securityContext, this.resolutionManifest);
        }
        this.namespaceCatalog = this.baseCatalog instanceof SupportsNamespaces ? (SupportsNamespaces)this.baseCatalog : null;
        this.viewCatalog = this.baseCatalog instanceof ViewCatalog ? (ViewCatalog)this.baseCatalog : null;
    }

    public ListNamespacesResponse listNamespaces(Namespace parent) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_NAMESPACES;
        this.authorizeBasicNamespaceOperationOrThrow(op, parent);
        return this.catalogHandlerUtils.listNamespaces(this.namespaceCatalog, parent);
    }

    public CreateNamespaceResponse createNamespace(CreateNamespaceRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_NAMESPACE;
        Namespace namespace = request.namespace();
        if (namespace.isEmpty()) {
            throw new AlreadyExistsException("Cannot create root namespace, as it already exists implicitly.", new Object[0]);
        }
        this.authorizeCreateNamespaceUnderNamespaceOperationOrThrow(op, namespace);
        if (this.namespaceCatalog instanceof IcebergCatalog) {
            this.namespaceCatalog.createNamespace(namespace, this.reservedProperties.removeReservedProperties(request.properties()));
            Map<String, String> filteredProperties = this.reservedProperties.removeReservedProperties(this.resolutionManifest.getPassthroughResolvedPath((Object)namespace).getRawLeafEntity().getPropertiesAsMap());
            return CreateNamespaceResponse.builder().withNamespace(namespace).setProperties(filteredProperties).build();
        }
        return this.catalogHandlerUtils.createNamespace(this.namespaceCatalog, request);
    }

    private static boolean isStaticFacade(CatalogEntity catalog) {
        return Catalog.TypeEnum.EXTERNAL.equals((Object)catalog.getCatalogType()) && !catalog.isPassthroughFacade();
    }

    public GetNamespaceResponse loadNamespaceMetadata(Namespace namespace) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LOAD_NAMESPACE_METADATA;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        return this.catalogHandlerUtils.loadNamespace(this.namespaceCatalog, namespace);
    }

    public void namespaceExists(Namespace namespace) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.NAMESPACE_EXISTS;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        this.catalogHandlerUtils.loadNamespace(this.namespaceCatalog, namespace);
    }

    public void dropNamespace(Namespace namespace) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DROP_NAMESPACE;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        this.catalogHandlerUtils.dropNamespace(this.namespaceCatalog, namespace);
    }

    public UpdateNamespacePropertiesResponse updateNamespaceProperties(Namespace namespace, UpdateNamespacePropertiesRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.UPDATE_NAMESPACE_PROPERTIES;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        return this.catalogHandlerUtils.updateNamespaceProperties(this.namespaceCatalog, namespace, request);
    }

    public ListTablesResponse listTables(Namespace namespace, String pageToken, Integer pageSize) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_TABLES;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        Catalog catalog = this.baseCatalog;
        if (catalog instanceof IcebergCatalog) {
            IcebergCatalog polarisCatalog = (IcebergCatalog)catalog;
            Page<TableIdentifier> results = polarisCatalog.listTables(namespace, pageToken, pageSize);
            return ListTablesResponse.builder().addAll((Collection)results.items).nextPageToken(results.pageToken.toTokenString()).build();
        }
        return this.catalogHandlerUtils.listTables(this.baseCatalog, namespace, pageToken, pageSize);
    }

    public ListTablesResponse listTables(Namespace namespace) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_TABLES;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        return this.catalogHandlerUtils.listTables(this.baseCatalog, namespace);
    }

    public LoadTableResponse createTableDirect(Namespace namespace, CreateTableRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_TABLE_DIRECT;
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)request.name());
        this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(op, identifier);
        CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)this.resolutionManifest.getResolvedReferenceCatalogEntity().getResolvedLeafEntity().getEntity());
        if (IcebergCatalogHandler.isStaticFacade(catalog)) {
            throw new BadRequestException("Cannot create table on static-facade external catalogs.", new Object[0]);
        }
        CreateTableRequest requestWithoutReservedProperties = CreateTableRequest.builder().withName(request.name()).withLocation(request.location()).withPartitionSpec(request.spec()).withSchema(request.schema()).withWriteOrder(request.writeOrder()).setProperties(this.reservedProperties.removeReservedProperties(request.properties())).build();
        return this.catalogHandlerUtils.createTable(this.baseCatalog, namespace, requestWithoutReservedProperties);
    }

    public LoadTableResponse createTableDirectWithWriteDelegation(Namespace namespace, CreateTableRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_TABLE_DIRECT_WITH_WRITE_DELEGATION;
        this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(op, TableIdentifier.of((Namespace)namespace, (String)request.name()));
        CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)this.resolutionManifest.getResolvedReferenceCatalogEntity().getResolvedLeafEntity().getEntity());
        if (IcebergCatalogHandler.isStaticFacade(catalog)) {
            throw new BadRequestException("Cannot create table on static-facade external catalogs.", new Object[0]);
        }
        request.validate();
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)request.name());
        if (this.baseCatalog.tableExists(tableIdentifier)) {
            throw new AlreadyExistsException("Table already exists: %s", new Object[]{tableIdentifier});
        }
        HashMap properties = Maps.newHashMap();
        properties.put("created-at", OffsetDateTime.now(ZoneOffset.UTC).toString());
        properties.putAll(this.reservedProperties.removeReservedProperties(request.properties()));
        Table table = this.baseCatalog.buildTable(tableIdentifier, request.schema()).withLocation(request.location()).withPartitionSpec(request.spec()).withSortOrder(request.writeOrder()).withProperties((Map)properties).create();
        PolarisStorageConfigurationInfo storageConf = catalog.getStorageConfigurationInfo();
        if (storageConf != null && storageConf.getStorageType().equals((Object)PolarisStorageConfigurationInfo.StorageType.MFS)) {
            String users = catalog.getPropertiesAsMap().getOrDefault("catalog-users", "*");
            CatalogMfsUtils.changeCatalogDirectoryPermission(catalog.getBaseLocation(), users, this.catalogName);
        }
        if (table instanceof BaseTable) {
            BaseTable baseTable = (BaseTable)table;
            TableMetadata tableMetadata = baseTable.operations().current();
            return this.buildLoadTableResponseWithDelegationCredentials(tableIdentifier, tableMetadata, Set.of(PolarisStorageActions.READ, PolarisStorageActions.WRITE, PolarisStorageActions.LIST), SNAPSHOTS_ALL).build();
        }
        if (table instanceof BaseMetadataTable) {
            throw new NoSuchTableException("Table does not exist: %s", new Object[]{tableIdentifier.toString()});
        }
        throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
    }

    private TableMetadata stageTableCreateHelper(Namespace namespace, CreateTableRequest request) {
        request.validate();
        TableIdentifier ident = TableIdentifier.of((Namespace)namespace, (String)request.name());
        if (this.baseCatalog.tableExists(ident)) {
            throw new AlreadyExistsException("Table already exists: %s", new Object[]{ident});
        }
        HashMap properties = Maps.newHashMap();
        properties.put("created-at", OffsetDateTime.now(ZoneOffset.UTC).toString());
        properties.putAll(this.reservedProperties.removeReservedProperties(request.properties()));
        String location = request.location() != null ? (this.baseCatalog instanceof IcebergCatalog ? ((IcebergCatalog)this.baseCatalog).transformTableLikeLocation(request.location()) : request.location()) : this.baseCatalog.buildTable(ident, request.schema()).withPartitionSpec(request.spec()).withSortOrder(request.writeOrder()).withProperties((Map)properties).createTransaction().table().location();
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)request.schema(), (PartitionSpec)(request.spec() != null ? request.spec() : PartitionSpec.unpartitioned()), (SortOrder)(request.writeOrder() != null ? request.writeOrder() : SortOrder.unsorted()), (String)location, (Map)properties);
        return metadata;
    }

    public LoadTableResponse createTableStaged(Namespace namespace, CreateTableRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_TABLE_STAGED;
        this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(op, TableIdentifier.of((Namespace)namespace, (String)request.name()));
        CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)this.resolutionManifest.getResolvedReferenceCatalogEntity().getResolvedLeafEntity().getEntity());
        if (IcebergCatalogHandler.isStaticFacade(catalog)) {
            throw new BadRequestException("Cannot create table on static-facade external catalogs.", new Object[0]);
        }
        TableMetadata metadata = this.stageTableCreateHelper(namespace, request);
        return LoadTableResponse.builder().withTableMetadata(metadata).build();
    }

    public LoadTableResponse createTableStagedWithWriteDelegation(Namespace namespace, CreateTableRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_TABLE_STAGED_WITH_WRITE_DELEGATION;
        this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(op, TableIdentifier.of((Namespace)namespace, (String)request.name()));
        CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)this.resolutionManifest.getResolvedReferenceCatalogEntity().getResolvedLeafEntity().getEntity());
        if (IcebergCatalogHandler.isStaticFacade(catalog)) {
            throw new BadRequestException("Cannot create table on static-facade external catalogs.", new Object[0]);
        }
        TableIdentifier ident = TableIdentifier.of((Namespace)namespace, (String)request.name());
        TableMetadata metadata = this.stageTableCreateHelper(namespace, request);
        return this.buildLoadTableResponseWithDelegationCredentials(ident, metadata, Set.of(PolarisStorageActions.ALL), SNAPSHOTS_ALL).build();
    }

    public LoadTableResponse registerTable(Namespace namespace, RegisterTableRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REGISTER_TABLE;
        this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(op, TableIdentifier.of((Namespace)namespace, (String)request.name()));
        return this.catalogHandlerUtils.registerTable(this.baseCatalog, namespace, request);
    }

    public boolean sendNotification(TableIdentifier identifier, NotificationRequest request) {
        SupportsNotifications notificationCatalog;
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.SEND_NOTIFICATIONS;
        List<TableIdentifier> extraPassthroughTableLikes = List.of(identifier);
        ArrayList<Namespace> extraPassthroughNamespaces = new ArrayList<Namespace>();
        extraPassthroughNamespaces.add(Namespace.empty());
        for (int i = 1; i <= identifier.namespace().length(); ++i) {
            Namespace nsLevel = Namespace.of((String[])((String[])Arrays.stream(identifier.namespace().levels()).limit(i).toArray(String[]::new)));
            extraPassthroughNamespaces.add(nsLevel);
        }
        this.authorizeBasicNamespaceOperationOrThrow(op, Namespace.empty(), extraPassthroughNamespaces, extraPassthroughTableLikes, null);
        CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)this.resolutionManifest.getResolvedReferenceCatalogEntity().getResolvedLeafEntity().getEntity());
        if (catalog.getCatalogType().equals((Object)Catalog.TypeEnum.INTERNAL)) {
            LOGGER.atWarn().addKeyValue("catalog", (Object)catalog).addKeyValue("notification", (Object)request).log("Attempted notification on internal catalog");
            throw new BadRequestException("Cannot update internal catalog via notifications", new Object[0]);
        }
        Catalog catalog2 = this.baseCatalog;
        return catalog2 instanceof SupportsNotifications && (notificationCatalog = (SupportsNotifications)catalog2).sendNotification(identifier, request);
    }

    private IcebergTableLikeEntity getTableEntity(TableIdentifier tableIdentifier) {
        PolarisResolvedPathWrapper target = this.resolutionManifest.getResolvedPath((Object)tableIdentifier);
        return IcebergTableLikeEntity.of((PolarisBaseEntity)target.getRawLeafEntity());
    }

    public LoadTableResponse loadTable(TableIdentifier tableIdentifier, String snapshots) {
        return this.loadTableIfStale(tableIdentifier, null, snapshots).get();
    }

    public Optional<LoadTableResponse> loadTableIfStale(TableIdentifier tableIdentifier, IfNoneMatch ifNoneMatch, String snapshots) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LOAD_TABLE;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier);
        if (ifNoneMatch != null) {
            IcebergTableLikeEntity tableEntity = this.getTableEntity(tableIdentifier);
            if (tableEntity == null || tableEntity.getMetadataLocation() == null) {
                LOGGER.atWarn().addKeyValue("tableIdentifier", (Object)tableIdentifier).addKeyValue("tableEntity", (Object)tableEntity).log("Failed to getMetadataLocation to generate ETag when loading table");
            } else {
                String tableEntityTag = IcebergHttpUtil.generateETagForMetadataFileLocation(tableEntity.getMetadataLocation());
                if (ifNoneMatch.anyMatch(tableEntityTag)) {
                    return Optional.empty();
                }
            }
        }
        LoadTableResponse rawResponse = this.catalogHandlerUtils.loadTable(this.baseCatalog, tableIdentifier);
        return Optional.of(this.filterResponseToSnapshots(rawResponse, snapshots));
    }

    public LoadTableResponse loadTableWithAccessDelegation(TableIdentifier tableIdentifier, String snapshots) {
        return this.loadTableWithAccessDelegationIfStale(tableIdentifier, null, snapshots).get();
    }

    public Optional<LoadTableResponse> loadTableWithAccessDelegationIfStale(TableIdentifier tableIdentifier, IfNoneMatch ifNoneMatch, String snapshots) {
        Table table;
        PolarisAuthorizableOperation read = PolarisAuthorizableOperation.LOAD_TABLE_WITH_READ_DELEGATION;
        PolarisAuthorizableOperation write = PolarisAuthorizableOperation.LOAD_TABLE_WITH_WRITE_DELEGATION;
        HashSet<PolarisStorageActions> actionsRequested = new HashSet<PolarisStorageActions>(Set.of(PolarisStorageActions.READ, PolarisStorageActions.LIST));
        try {
            this.authorizeBasicTableLikeOperationOrThrow(write, PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier);
            actionsRequested.add(PolarisStorageActions.WRITE);
        }
        catch (ForbiddenException e) {
            this.authorizeBasicTableLikeOperationOrThrow(read, PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier);
        }
        PolarisResolvedPathWrapper catalogPath = this.resolutionManifest.getResolvedReferenceCatalogEntity();
        this.callContext.getPolarisCallContext().getDiagServices().checkNotNull((Object)catalogPath, "No catalog available for loadTable request");
        CatalogEntity catalogEntity = CatalogEntity.of((PolarisBaseEntity)catalogPath.getRawLeafEntity());
        PolarisConfigurationStore configurationStore = this.callContext.getPolarisCallContext().getConfigurationStore();
        LOGGER.info("Catalog type: {}", (Object)catalogEntity.getCatalogType());
        LOGGER.info("allow external catalog credential vending: {}", configurationStore.getConfiguration(this.callContext.getRealmContext(), catalogEntity, (PolarisConfiguration)FeatureConfiguration.ALLOW_EXTERNAL_CATALOG_CREDENTIAL_VENDING));
        if (catalogEntity.getCatalogType().equals((Object)Catalog.TypeEnum.EXTERNAL) && !((Boolean)configurationStore.getConfiguration(this.callContext.getRealmContext(), catalogEntity, (PolarisConfiguration)FeatureConfiguration.ALLOW_EXTERNAL_CATALOG_CREDENTIAL_VENDING)).booleanValue()) {
            throw new ForbiddenException("Access Delegation is not enabled for this catalog. Please consult applicable documentation for the catalog config property '%s' to enable this feature", new Object[]{FeatureConfiguration.ALLOW_EXTERNAL_CATALOG_CREDENTIAL_VENDING.catalogConfig()});
        }
        if (ifNoneMatch != null) {
            IcebergTableLikeEntity tableEntity = this.getTableEntity(tableIdentifier);
            if (tableEntity == null || tableEntity.getMetadataLocation() == null) {
                LOGGER.atWarn().addKeyValue("tableIdentifier", (Object)tableIdentifier).addKeyValue("tableEntity", (Object)tableEntity).log("Failed to getMetadataLocation to generate ETag when loading table");
            } else {
                String tableETag = IcebergHttpUtil.generateETagForMetadataFileLocation(tableEntity.getMetadataLocation());
                if (ifNoneMatch.anyMatch(tableETag)) {
                    return Optional.empty();
                }
            }
        }
        if ((table = this.baseCatalog.loadTable(tableIdentifier)) instanceof BaseTable) {
            BaseTable baseTable = (BaseTable)table;
            TableMetadata tableMetadata = baseTable.operations().current();
            return Optional.of(this.buildLoadTableResponseWithDelegationCredentials(tableIdentifier, tableMetadata, actionsRequested, snapshots).build());
        }
        if (table instanceof BaseMetadataTable) {
            throw new NoSuchTableException("Table does not exist: %s", new Object[]{tableIdentifier.toString()});
        }
        throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
    }

    private LoadTableResponse.Builder buildLoadTableResponseWithDelegationCredentials(TableIdentifier tableIdentifier, TableMetadata tableMetadata, Set<PolarisStorageActions> actions, String snapshots) {
        LoadTableResponse.Builder responseBuilder = LoadTableResponse.builder().withTableMetadata(tableMetadata);
        Catalog catalog = this.baseCatalog;
        if (catalog instanceof SupportsCredentialDelegation) {
            SupportsCredentialDelegation credentialDelegation = (SupportsCredentialDelegation)catalog;
            LOGGER.atDebug().addKeyValue("tableIdentifier", (Object)tableIdentifier).addKeyValue("tableLocation", (Object)tableMetadata.location()).log("Fetching client credentials for table");
            AccessConfig accessConfig = credentialDelegation.getAccessConfig(tableIdentifier, tableMetadata, actions);
            Map credentialConfig = accessConfig.credentials();
            responseBuilder.addAllConfig(credentialConfig);
            responseBuilder.addAllConfig(accessConfig.extraProperties());
            if (!credentialConfig.isEmpty()) {
                responseBuilder.addCredential((Credential)ImmutableCredential.builder().prefix(tableMetadata.location()).config(credentialConfig).build());
            }
        }
        return responseBuilder;
    }

    private UpdateTableRequest applyUpdateFilters(UpdateTableRequest request) {
        TableIdentifier identifier = request.identifier();
        List requirements = request.requirements();
        List<MetadataUpdate> updates = request.updates().stream().map(update -> {
            if (this.baseCatalog instanceof IcebergCatalog && update instanceof MetadataUpdate.SetLocation) {
                String requestedLocation = ((MetadataUpdate.SetLocation)update).location();
                String filteredLocation = ((IcebergCatalog)this.baseCatalog).transformTableLikeLocation(requestedLocation);
                return new MetadataUpdate.SetLocation(filteredLocation);
            }
            return update;
        }).toList();
        return UpdateTableRequest.create((TableIdentifier)identifier, (List)requirements, updates);
    }

    public LoadTableResponse updateTable(TableIdentifier tableIdentifier, UpdateTableRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.UPDATE_TABLE;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier);
        CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)this.resolutionManifest.getResolvedReferenceCatalogEntity().getResolvedLeafEntity().getEntity());
        if (IcebergCatalogHandler.isStaticFacade(catalog)) {
            throw new BadRequestException("Cannot update table on static-facade external catalogs.", new Object[0]);
        }
        return this.catalogHandlerUtils.updateTable(this.baseCatalog, tableIdentifier, this.applyUpdateFilters(request));
    }

    public LoadTableResponse updateTableForStagedCreate(TableIdentifier tableIdentifier, UpdateTableRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.UPDATE_TABLE_FOR_STAGED_CREATE;
        this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(op, tableIdentifier);
        CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)this.resolutionManifest.getResolvedReferenceCatalogEntity().getResolvedLeafEntity().getEntity());
        if (IcebergCatalogHandler.isStaticFacade(catalog)) {
            throw new BadRequestException("Cannot update table on static-facade external catalogs.", new Object[0]);
        }
        return this.catalogHandlerUtils.updateTable(this.baseCatalog, tableIdentifier, this.applyUpdateFilters(request));
    }

    public void dropTableWithoutPurge(TableIdentifier tableIdentifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DROP_TABLE_WITHOUT_PURGE;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier);
        this.catalogHandlerUtils.dropTable(this.baseCatalog, tableIdentifier);
    }

    public void dropTableWithPurge(TableIdentifier tableIdentifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DROP_TABLE_WITH_PURGE;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier);
        CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)this.resolutionManifest.getResolvedReferenceCatalogEntity().getResolvedLeafEntity().getEntity());
        if (IcebergCatalogHandler.isStaticFacade(catalog)) {
            throw new BadRequestException("Cannot drop table on static-facade external catalogs.", new Object[0]);
        }
        this.catalogHandlerUtils.purgeTable(this.baseCatalog, tableIdentifier);
    }

    public void tableExists(TableIdentifier tableIdentifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.TABLE_EXISTS;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier);
        this.catalogHandlerUtils.loadTable(this.baseCatalog, tableIdentifier);
    }

    public void renameTable(RenameTableRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.RENAME_TABLE;
        this.authorizeRenameTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_TABLE, request.source(), request.destination());
        CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)this.resolutionManifest.getResolvedReferenceCatalogEntity().getResolvedLeafEntity().getEntity());
        if (IcebergCatalogHandler.isStaticFacade(catalog)) {
            throw new BadRequestException("Cannot rename table on static-facade external catalogs.", new Object[0]);
        }
        this.catalogHandlerUtils.renameTable(this.baseCatalog, request);
    }

    public void commitTransaction(CommitTransactionRequest commitTransactionRequest) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.COMMIT_TRANSACTION;
        this.authorizeCollectionOfTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_TABLE, commitTransactionRequest.tableChanges().stream().map(UpdateTableRequest::identifier).toList());
        CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)this.resolutionManifest.getResolvedReferenceCatalogEntity().getResolvedLeafEntity().getEntity());
        if (IcebergCatalogHandler.isStaticFacade(catalog)) {
            throw new BadRequestException("Cannot update table on static-facade external catalogs.", new Object[0]);
        }
        if (!(this.baseCatalog instanceof IcebergCatalog)) {
            throw new BadRequestException("Unsupported operation: commitTransaction with baseCatalog type: %s", new Object[]{this.baseCatalog.getClass().getName()});
        }
        TransactionWorkspaceMetaStoreManager transactionMetaStoreManager = new TransactionWorkspaceMetaStoreManager(this.metaStoreManager);
        ((IcebergCatalog)this.baseCatalog).setMetaStoreManager((PolarisMetaStoreManager)transactionMetaStoreManager);
        commitTransactionRequest.tableChanges().stream().forEach(change -> {
            Table table = this.baseCatalog.loadTable(change.identifier());
            if (!(table instanceof BaseTable)) {
                throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
            }
            if (IcebergCatalogHandler.isCreate(change)) {
                throw new BadRequestException("Unsupported operation: commitTranaction with updateForStagedCreate: %s", new Object[]{change});
            }
            TableOperations tableOps = ((BaseTable)table).operations();
            TableMetadata currentMetadata = tableOps.current();
            change.requirements().forEach(requirement -> requirement.validate(currentMetadata));
            TableMetadata.Builder metadataBuilder = TableMetadata.buildFrom((TableMetadata)currentMetadata);
            change.updates().stream().forEach(singleUpdate -> {
                if (singleUpdate instanceof MetadataUpdate.SetLocation && !currentMetadata.location().equals(((MetadataUpdate.SetLocation)singleUpdate).location()) && !((Boolean)this.callContext.getPolarisCallContext().getConfigurationStore().getConfiguration(this.callContext.getRealmContext(), (PolarisConfiguration)FeatureConfiguration.ALLOW_NAMESPACE_LOCATION_OVERLAP)).booleanValue()) {
                    throw new BadRequestException("Unsupported operation: commitTransaction containing SetLocation for table '%s' and new location '%s'", new Object[]{change.identifier(), ((MetadataUpdate.SetLocation)singleUpdate).location()});
                }
                singleUpdate.applyTo(metadataBuilder);
            });
            TableMetadata updatedMetadata = metadataBuilder.build();
            if (!updatedMetadata.changes().isEmpty()) {
                tableOps.commit(currentMetadata, updatedMetadata);
            }
        });
        List pendingUpdates = transactionMetaStoreManager.getPendingUpdates();
        EntitiesResult result = this.metaStoreManager.updateEntitiesPropertiesIfNotChanged(this.callContext.getPolarisCallContext(), pendingUpdates);
        if (!result.isSuccess()) {
            throw new CommitFailedException("Transaction commit failed with status: %s, extraInfo: %s", new Object[]{result.getReturnStatus(), result.getExtraInformation()});
        }
    }

    public ListTablesResponse listViews(Namespace namespace, String pageToken, Integer pageSize) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_VIEWS;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        Catalog catalog = this.baseCatalog;
        if (catalog instanceof IcebergCatalog) {
            IcebergCatalog polarisCatalog = (IcebergCatalog)catalog;
            Page<TableIdentifier> results = polarisCatalog.listViews(namespace, pageToken, pageSize);
            return ListTablesResponse.builder().addAll((Collection)results.items).nextPageToken(results.pageToken.toTokenString()).build();
        }
        catalog = this.baseCatalog;
        if (catalog instanceof ViewCatalog) {
            ViewCatalog viewCatalog = (ViewCatalog)catalog;
            return this.catalogHandlerUtils.listViews(viewCatalog, namespace, pageToken, pageSize);
        }
        throw new BadRequestException("Unsupported operation: listViews with baseCatalog type: %s", new Object[]{this.baseCatalog.getClass().getName()});
    }

    public ListTablesResponse listViews(Namespace namespace) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_VIEWS;
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace);
        return this.catalogHandlerUtils.listViews(this.viewCatalog, namespace);
    }

    public LoadViewResponse createView(Namespace namespace, CreateViewRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_VIEW;
        this.authorizeCreateTableLikeUnderNamespaceOperationOrThrow(op, TableIdentifier.of((Namespace)namespace, (String)request.name()));
        CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)this.resolutionManifest.getResolvedReferenceCatalogEntity().getResolvedLeafEntity().getEntity());
        if (IcebergCatalogHandler.isStaticFacade(catalog)) {
            throw new BadRequestException("Cannot create view on static-facade external catalogs.", new Object[0]);
        }
        return this.catalogHandlerUtils.createView(this.viewCatalog, namespace, request);
    }

    public LoadViewResponse loadView(TableIdentifier viewIdentifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LOAD_VIEW;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_VIEW, viewIdentifier);
        return this.catalogHandlerUtils.loadView(this.viewCatalog, viewIdentifier);
    }

    public LoadViewResponse replaceView(TableIdentifier viewIdentifier, UpdateTableRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REPLACE_VIEW;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_VIEW, viewIdentifier);
        CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)this.resolutionManifest.getResolvedReferenceCatalogEntity().getResolvedLeafEntity().getEntity());
        if (IcebergCatalogHandler.isStaticFacade(catalog)) {
            throw new BadRequestException("Cannot replace view on static-facade external catalogs.", new Object[0]);
        }
        return this.catalogHandlerUtils.updateView(this.viewCatalog, viewIdentifier, this.applyUpdateFilters(request));
    }

    public void dropView(TableIdentifier viewIdentifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DROP_VIEW;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_VIEW, viewIdentifier);
        this.catalogHandlerUtils.dropView(this.viewCatalog, viewIdentifier);
    }

    public void viewExists(TableIdentifier viewIdentifier) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.VIEW_EXISTS;
        this.authorizeBasicTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_VIEW, viewIdentifier);
        this.catalogHandlerUtils.loadView(this.viewCatalog, viewIdentifier);
    }

    public void renameView(RenameTableRequest request) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.RENAME_VIEW;
        this.authorizeRenameTableLikeOperationOrThrow(op, PolarisEntitySubType.ICEBERG_VIEW, request.source(), request.destination());
        CatalogEntity catalog = CatalogEntity.of((PolarisBaseEntity)this.resolutionManifest.getResolvedReferenceCatalogEntity().getResolvedLeafEntity().getEntity());
        if (IcebergCatalogHandler.isStaticFacade(catalog)) {
            throw new BadRequestException("Cannot rename view on static-facade external catalogs.", new Object[0]);
        }
        this.catalogHandlerUtils.renameView(this.viewCatalog, request);
    }

    @Nonnull
    private LoadTableResponse filterResponseToSnapshots(LoadTableResponse loadTableResponse, String snapshots) {
        if (snapshots == null || snapshots.equalsIgnoreCase(SNAPSHOTS_ALL)) {
            return loadTableResponse;
        }
        if (snapshots.equalsIgnoreCase(SNAPSHOTS_REFS)) {
            TableMetadata metadata = loadTableResponse.tableMetadata();
            Set referencedSnapshotIds = metadata.refs().values().stream().map(SnapshotRef::snapshotId).collect(Collectors.toSet());
            TableMetadata filteredMetadata = metadata.removeSnapshotsIf(s -> !referencedSnapshotIds.contains(s.snapshotId()));
            return LoadTableResponse.builder().withTableMetadata(filteredMetadata).addAllConfig(loadTableResponse.config()).addAllCredentials(loadTableResponse.credentials()).build();
        }
        throw new IllegalArgumentException("Unrecognized snapshots: " + snapshots);
    }

    @Override
    public void close() throws Exception {
        Catalog catalog = this.baseCatalog;
        if (catalog instanceof Closeable) {
            Closeable closeable = (Closeable)catalog;
            closeable.close();
        }
    }
}

