/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.SecurityContext;
import java.security.Principal;
import java.time.Clock;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.auth.AuthenticatedPolarisPrincipal;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.core.persistence.BasePersistence;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisEntityManager;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.dao.entity.CreatePrincipalResult;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.apache.polaris.core.secrets.UserSecretsManagerFactory;
import org.apache.polaris.core.storage.PolarisStorageIntegrationProvider;
import org.apache.polaris.service.admin.PolarisServiceImpl;
import org.apache.polaris.service.admin.api.PolarisCatalogsApi;
import org.apache.polaris.service.admin.api.PolarisCatalogsApiService;
import org.apache.polaris.service.catalog.CatalogPrefixParser;
import org.apache.polaris.service.catalog.DefaultCatalogPrefixParser;
import org.apache.polaris.service.catalog.api.IcebergRestCatalogApi;
import org.apache.polaris.service.catalog.api.IcebergRestCatalogApiService;
import org.apache.polaris.service.catalog.api.IcebergRestConfigurationApi;
import org.apache.polaris.service.catalog.api.IcebergRestConfigurationApiService;
import org.apache.polaris.service.catalog.iceberg.CatalogHandlerUtils;
import org.apache.polaris.service.catalog.iceberg.IcebergCatalogAdapter;
import org.apache.polaris.service.catalog.io.FileIOFactory;
import org.apache.polaris.service.catalog.io.MeasuredFileIOFactory;
import org.apache.polaris.service.config.RealmEntityManagerFactory;
import org.apache.polaris.service.config.ReservedProperties;
import org.apache.polaris.service.context.catalog.CallContextCatalogFactory;
import org.apache.polaris.service.context.catalog.PolarisCallContextCatalogFactory;
import org.apache.polaris.service.events.PolarisEventListener;
import org.apache.polaris.service.events.TestPolarisEventListener;
import org.apache.polaris.service.persistence.InMemoryPolarisMetaStoreManagerFactory;
import org.apache.polaris.service.secrets.UnsafeInMemorySecretsManagerFactory;
import org.apache.polaris.service.storage.PolarisStorageIntegrationProviderImpl;
import org.apache.polaris.service.task.TaskExecutor;
import org.assertj.core.util.TriFunction;
import org.mockito.Mockito;
import software.amazon.awssdk.services.sts.StsClient;

public record TestServices(PolarisCatalogsApi catalogsApi, IcebergRestCatalogApi restApi, IcebergRestConfigurationApi restConfigurationApi, IcebergCatalogAdapter catalogAdapter, PolarisConfigurationStore configurationStore, PolarisDiagnostics polarisDiagnostics, RealmEntityManagerFactory entityManagerFactory, MetaStoreManagerFactory metaStoreManagerFactory, RealmContext realmContext, SecurityContext securityContext, FileIOFactory fileIOFactory, TaskExecutor taskExecutor, PolarisEventListener polarisEventListener) {
    private static final RealmContext TEST_REALM = () -> "test-realm";
    private static final String GCP_ACCESS_TOKEN = "abc";

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private RealmContext realmContext = TEST_REALM;
        private Map<String, Object> config = Map.of();
        private StsClient stsClient = (StsClient)Mockito.mock(StsClient.class);
        private FileIOFactorySupplier fileIOFactorySupplier = MeasuredFileIOFactory::new;

        private Builder() {
        }

        public Builder realmContext(RealmContext realmContext) {
            this.realmContext = realmContext;
            return this;
        }

        public Builder config(Map<String, Object> config) {
            this.config = config;
            return this;
        }

        public Builder fileIOFactorySupplier(FileIOFactorySupplier fileIOFactorySupplier) {
            this.fileIOFactorySupplier = fileIOFactorySupplier;
            return this;
        }

        public Builder stsClient(StsClient stsClient) {
            this.stsClient = stsClient;
            return this;
        }

        public TestServices build() {
            MockedConfigurationStore configurationStore = new MockedConfigurationStore(this.config);
            PolarisDiagnostics polarisDiagnostics = (PolarisDiagnostics)Mockito.mock(PolarisDiagnostics.class);
            PolarisAuthorizer authorizer = (PolarisAuthorizer)Mockito.mock(PolarisAuthorizer.class);
            PolarisStorageIntegrationProviderImpl storageIntegrationProvider = new PolarisStorageIntegrationProviderImpl(destination -> this.stsClient, Optional.empty(), () -> GoogleCredentials.create((AccessToken)new AccessToken(TestServices.GCP_ACCESS_TOKEN, new Date())));
            InMemoryPolarisMetaStoreManagerFactory metaStoreManagerFactory = new InMemoryPolarisMetaStoreManagerFactory((PolarisStorageIntegrationProvider)storageIntegrationProvider, polarisDiagnostics, (PolarisConfigurationStore)configurationStore);
            RealmEntityManagerFactory realmEntityManagerFactory = new RealmEntityManagerFactory(this, (MetaStoreManagerFactory)metaStoreManagerFactory){};
            UnsafeInMemorySecretsManagerFactory userSecretsManagerFactory = new UnsafeInMemorySecretsManagerFactory();
            BasePersistence metaStoreSession = (BasePersistence)metaStoreManagerFactory.getOrCreateSessionSupplier(this.realmContext).get();
            PolarisCallContext callContext = new PolarisCallContext(this.realmContext, metaStoreSession, polarisDiagnostics, (PolarisConfigurationStore)configurationStore, Clock.systemUTC());
            PolarisEntityManager entityManager = realmEntityManagerFactory.getOrCreateEntityManager(this.realmContext);
            PolarisMetaStoreManager metaStoreManager = metaStoreManagerFactory.getOrCreateMetaStoreManager(this.realmContext);
            UserSecretsManager userSecretsManager = userSecretsManagerFactory.getOrCreateUserSecretsManager(this.realmContext);
            FileIOFactory fileIOFactory = (FileIOFactory)this.fileIOFactorySupplier.apply(realmEntityManagerFactory, metaStoreManagerFactory, configurationStore);
            TaskExecutor taskExecutor = (TaskExecutor)Mockito.mock(TaskExecutor.class);
            TestPolarisEventListener polarisEventListener = new TestPolarisEventListener();
            PolarisCallContextCatalogFactory callContextFactory = new PolarisCallContextCatalogFactory(realmEntityManagerFactory, (MetaStoreManagerFactory)metaStoreManagerFactory, (UserSecretsManagerFactory)userSecretsManagerFactory, taskExecutor, fileIOFactory, (PolarisEventListener)polarisEventListener);
            ReservedProperties reservedProperties = ReservedProperties.NONE;
            CatalogHandlerUtils catalogHandlerUtils = new CatalogHandlerUtils(callContext.getRealmContext(), (PolarisConfigurationStore)configurationStore);
            IcebergCatalogAdapter catalogService = new IcebergCatalogAdapter(this.realmContext, (CallContext)callContext, (CallContextCatalogFactory)callContextFactory, entityManager, metaStoreManager, userSecretsManager, authorizer, (CatalogPrefixParser)new DefaultCatalogPrefixParser(), reservedProperties, catalogHandlerUtils);
            IcebergRestCatalogApi restApi = new IcebergRestCatalogApi((IcebergRestCatalogApiService)catalogService);
            IcebergRestConfigurationApi restConfigurationApi = new IcebergRestConfigurationApi((IcebergRestConfigurationApiService)catalogService);
            CreatePrincipalResult createdPrincipal = metaStoreManager.createPrincipal(callContext.getPolarisCallContext(), (PolarisBaseEntity)((PrincipalEntity.Builder)((PrincipalEntity.Builder)new PrincipalEntity.Builder().setName("test-principal")).setCreateTimestamp(Instant.now().toEpochMilli())).setCredentialRotationRequiredState().build());
            final AuthenticatedPolarisPrincipal principal = new AuthenticatedPolarisPrincipal(PolarisEntity.of((PolarisBaseEntity)createdPrincipal.getPrincipal()), Set.of());
            SecurityContext securityContext = new SecurityContext(){

                public Principal getUserPrincipal() {
                    return principal;
                }

                public boolean isUserInRole(String s) {
                    return false;
                }

                public boolean isSecure() {
                    return true;
                }

                public String getAuthenticationScheme() {
                    return "";
                }
            };
            PolarisCatalogsApi catalogsApi = new PolarisCatalogsApi((PolarisCatalogsApiService)new PolarisServiceImpl(realmEntityManagerFactory, (MetaStoreManagerFactory)metaStoreManagerFactory, (UserSecretsManagerFactory)userSecretsManagerFactory, authorizer, (CallContext)callContext, reservedProperties));
            return new TestServices(catalogsApi, restApi, restConfigurationApi, catalogService, configurationStore, polarisDiagnostics, realmEntityManagerFactory, (MetaStoreManagerFactory)metaStoreManagerFactory, this.realmContext, securityContext, fileIOFactory, taskExecutor, (PolarisEventListener)polarisEventListener);
        }
    }

    private static class MockedConfigurationStore
    implements PolarisConfigurationStore {
        private final Map<String, Object> defaults;

        public MockedConfigurationStore(Map<String, Object> defaults) {
            this.defaults = Map.copyOf(defaults);
        }

        @Nullable
        public <T> T getConfiguration(@Nonnull RealmContext realmContext, String configName) {
            Object confgValue = this.defaults.get(configName);
            return (T)confgValue;
        }
    }

    @FunctionalInterface
    public static interface FileIOFactorySupplier
    extends TriFunction<RealmEntityManagerFactory, MetaStoreManagerFactory, PolarisConfigurationStore, FileIOFactory> {
    }
}

