/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.it;

import java.net.URI;
import java.util.Objects;
import org.apache.polaris.service.it.env.ClientCredentials;
import org.apache.polaris.service.it.env.ClientPrincipal;
import org.apache.polaris.service.it.env.Server;
import org.apache.polaris.service.it.ext.PolarisServerManager;
import org.junit.jupiter.api.extension.ExtensionContext;

public class QuarkusServerManager
implements PolarisServerManager {
    public Server serverForContext(ExtensionContext context) {
        return new Server(this){

            public URI baseUri() {
                return URI.create(String.format("http://localhost:%d", QuarkusServerManager.getQuarkusTestPort()));
            }

            public ClientPrincipal adminCredentials() {
                return new ClientPrincipal("root", new ClientCredentials("test-admin", "test-secret"));
            }

            public void close() {
            }
        };
    }

    private static Integer getQuarkusTestPort() {
        return Objects.requireNonNull(Integer.getInteger("quarkus.http.test-port"), "System property not set correctly: quarkus.http.test-port");
    }
}

