/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc.models;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.storage.StorageLocation;
import org.apache.polaris.persistence.relational.jdbc.DatabaseType;
import org.apache.polaris.persistence.relational.jdbc.models.Converter;

public class ModelEntity
implements Converter<PolarisBaseEntity> {
    public static final String TABLE_NAME = "ENTITIES";
    public static final List<String> ALL_COLUMNS = List.of("id", "catalog_id", "parent_id", "type_code", "name", "entity_version", "sub_type_code", "create_timestamp", "drop_timestamp", "purge_timestamp", "to_purge_timestamp", "last_update_timestamp", "properties", "internal_properties", "grant_records_version", "location_without_scheme");
    private long catalogId;
    private long id;
    private long parentId;
    private int typeCode;
    private String name;
    private int entityVersion;
    private int subTypeCode;
    private long createTimestamp;
    private long dropTimestamp;
    private long purgeTimestamp;
    private long toPurgeTimestamp;
    private long lastUpdateTimestamp;
    private String properties;
    private String internalProperties;
    private int grantRecordsVersion;
    private String locationWithoutScheme;

    public long getId() {
        return this.id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public String getName() {
        return this.name;
    }

    public int getEntityVersion() {
        return this.entityVersion;
    }

    public long getCatalogId() {
        return this.catalogId;
    }

    public int getSubTypeCode() {
        return this.subTypeCode;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public long getDropTimestamp() {
        return this.dropTimestamp;
    }

    public long getPurgeTimestamp() {
        return this.purgeTimestamp;
    }

    public long getToPurgeTimestamp() {
        return this.toPurgeTimestamp;
    }

    public long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public String getProperties() {
        return this.properties != null ? this.properties : "{}";
    }

    public String getInternalProperties() {
        return this.internalProperties != null ? this.internalProperties : "{}";
    }

    public int getGrantRecordsVersion() {
        return this.grantRecordsVersion;
    }

    public String getLocationWithoutScheme() {
        return this.locationWithoutScheme;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public PolarisBaseEntity fromResultSet(ResultSet r) throws SQLException {
        ModelEntity modelEntity = ModelEntity.builder().catalogId(r.getObject("catalog_id", Long.class)).id(r.getObject("id", Long.class)).parentId(r.getObject("parent_id", Long.class)).typeCode(r.getObject("type_code", Integer.class)).name(r.getObject("name", String.class)).entityVersion(r.getObject("entity_version", Integer.class)).subTypeCode(r.getObject("sub_type_code", Integer.class)).createTimestamp(r.getObject("create_timestamp", Long.class)).dropTimestamp(r.getObject("drop_timestamp", Long.class)).purgeTimestamp(r.getObject("purge_timestamp", Long.class)).toPurgeTimestamp(r.getObject("to_purge_timestamp", Long.class)).lastUpdateTimestamp(r.getObject("last_update_timestamp", Long.class)).properties(r.getString("properties")).internalProperties(r.getString("internal_properties")).grantRecordsVersion(r.getObject("grant_records_version", Integer.class)).locationWithoutScheme(r.getString("location_without_scheme")).build();
        return ModelEntity.toEntity(modelEntity);
    }

    @Override
    public Map<String, Object> toMap(DatabaseType databaseType) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", this.getId());
        map.put("catalog_id", this.getCatalogId());
        map.put("parent_id", this.getParentId());
        map.put("type_code", this.getTypeCode());
        map.put("name", this.getName());
        map.put("entity_version", this.getEntityVersion());
        map.put("sub_type_code", this.getSubTypeCode());
        map.put("create_timestamp", this.getCreateTimestamp());
        map.put("drop_timestamp", this.getDropTimestamp());
        map.put("purge_timestamp", this.getPurgeTimestamp());
        map.put("to_purge_timestamp", this.getToPurgeTimestamp());
        map.put("last_update_timestamp", this.getLastUpdateTimestamp());
        if (databaseType.equals((Object)DatabaseType.POSTGRES)) {
            map.put("properties", this.toJsonbPGobject(this.getProperties()));
            map.put("internal_properties", this.toJsonbPGobject(this.getInternalProperties()));
        } else {
            map.put("properties", this.getProperties());
            map.put("internal_properties", this.getInternalProperties());
        }
        map.put("grant_records_version", this.getGrantRecordsVersion());
        map.put("location_without_scheme", this.getLocationWithoutScheme());
        return map;
    }

    public static ModelEntity fromEntity(PolarisBaseEntity entity) {
        Builder builder = ModelEntity.builder().catalogId(entity.getCatalogId()).id(entity.getId()).parentId(entity.getParentId()).typeCode(entity.getTypeCode()).name(entity.getName()).entityVersion(entity.getEntityVersion()).subTypeCode(entity.getSubTypeCode()).createTimestamp(entity.getCreateTimestamp()).dropTimestamp(entity.getDropTimestamp()).purgeTimestamp(entity.getPurgeTimestamp()).toPurgeTimestamp(entity.getToPurgeTimestamp()).lastUpdateTimestamp(entity.getLastUpdateTimestamp()).properties(entity.getProperties()).internalProperties(entity.getInternalProperties()).grantRecordsVersion(entity.getGrantRecordsVersion());
        if (entity.getType() == PolarisEntityType.TABLE_LIKE && (entity.getSubType() == PolarisEntitySubType.ICEBERG_TABLE || entity.getSubType() == PolarisEntitySubType.ICEBERG_VIEW)) {
            builder.locationWithoutScheme(StorageLocation.of((String)((String)entity.getPropertiesAsMap().get("location"))).withoutScheme());
        }
        if (entity.getType() == PolarisEntityType.NAMESPACE) {
            builder.locationWithoutScheme(StorageLocation.of((String)((String)entity.getPropertiesAsMap().get("location"))).withoutScheme());
        }
        return builder.build();
    }

    public static PolarisBaseEntity toEntity(ModelEntity model) {
        if (model == null) {
            return null;
        }
        PolarisEntityType entityType = PolarisEntityType.fromCode((int)model.getTypeCode());
        PolarisEntitySubType subType = PolarisEntitySubType.fromCode((int)model.getSubTypeCode());
        if (entityType == null) {
            throw new IllegalArgumentException("Invalid entity type: " + model.getTypeCode());
        }
        if (subType == null) {
            throw new IllegalArgumentException("Invalid entity subtype: " + model.getSubTypeCode());
        }
        PolarisBaseEntity entity = new PolarisBaseEntity(model.getCatalogId(), model.getId(), entityType, subType, model.getParentId(), model.getName());
        entity.setEntityVersion(model.getEntityVersion());
        entity.setCreateTimestamp(model.getCreateTimestamp());
        entity.setDropTimestamp(model.getDropTimestamp());
        entity.setPurgeTimestamp(model.getPurgeTimestamp());
        entity.setToPurgeTimestamp(model.getToPurgeTimestamp());
        entity.setLastUpdateTimestamp(model.getLastUpdateTimestamp());
        entity.setProperties(model.getProperties());
        entity.setInternalProperties(model.getInternalProperties());
        entity.setGrantRecordsVersion(model.getGrantRecordsVersion());
        return entity;
    }

    public static final class Builder {
        private final ModelEntity entity = new ModelEntity();

        private Builder() {
        }

        public Builder catalogId(long catalogId) {
            this.entity.catalogId = catalogId;
            return this;
        }

        public Builder id(long id) {
            this.entity.id = id;
            return this;
        }

        public Builder parentId(long parentId) {
            this.entity.parentId = parentId;
            return this;
        }

        public Builder typeCode(int typeCode) {
            this.entity.typeCode = typeCode;
            return this;
        }

        public Builder name(String name) {
            this.entity.name = name;
            return this;
        }

        public Builder entityVersion(int entityVersion) {
            this.entity.entityVersion = entityVersion;
            return this;
        }

        public Builder subTypeCode(int subTypeCode) {
            this.entity.subTypeCode = subTypeCode;
            return this;
        }

        public Builder createTimestamp(long createTimestamp) {
            this.entity.createTimestamp = createTimestamp;
            return this;
        }

        public Builder dropTimestamp(long dropTimestamp) {
            this.entity.dropTimestamp = dropTimestamp;
            return this;
        }

        public Builder purgeTimestamp(long purgeTimestamp) {
            this.entity.purgeTimestamp = purgeTimestamp;
            return this;
        }

        public Builder toPurgeTimestamp(long toPurgeTimestamp) {
            this.entity.toPurgeTimestamp = toPurgeTimestamp;
            return this;
        }

        public Builder lastUpdateTimestamp(long lastUpdateTimestamp) {
            this.entity.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public Builder properties(String properties) {
            this.entity.properties = properties;
            return this;
        }

        public Builder internalProperties(String internalProperties) {
            this.entity.internalProperties = internalProperties;
            return this;
        }

        public Builder grantRecordsVersion(int grantRecordsVersion) {
            this.entity.grantRecordsVersion = grantRecordsVersion;
            return this;
        }

        public Builder locationWithoutScheme(String location) {
            this.entity.locationWithoutScheme = location;
            return this;
        }

        public ModelEntity build() {
            return this.entity;
        }
    }
}

