/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc;

import io.smallrye.common.annotation.Identifier;
import jakarta.annotation.Nullable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDefaultDiagServiceImpl;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.AtomicOperationMetaStoreManager;
import org.apache.polaris.core.persistence.BasePersistence;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.PrincipalSecretsGenerator;
import org.apache.polaris.core.persistence.bootstrap.RootCredentialsSet;
import org.apache.polaris.core.persistence.cache.EntityCache;
import org.apache.polaris.core.persistence.cache.InMemoryEntityCache;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.core.persistence.dao.entity.PrincipalSecretsResult;
import org.apache.polaris.core.storage.PolarisStorageIntegrationProvider;
import org.apache.polaris.core.storage.cache.StorageCredentialCache;
import org.apache.polaris.persistence.relational.jdbc.DatabaseType;
import org.apache.polaris.persistence.relational.jdbc.DatasourceOperations;
import org.apache.polaris.persistence.relational.jdbc.JdbcBasePersistenceImpl;
import org.apache.polaris.persistence.relational.jdbc.RelationalJdbcConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Identifier(value="relational-jdbc")
public class JdbcMetaStoreManagerFactory
implements MetaStoreManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcMetaStoreManagerFactory.class);
    final Map<String, PolarisMetaStoreManager> metaStoreManagerMap = new HashMap<String, PolarisMetaStoreManager>();
    final Map<String, StorageCredentialCache> storageCredentialCacheMap = new HashMap<String, StorageCredentialCache>();
    final Map<String, EntityCache> entityCacheMap = new HashMap<String, EntityCache>();
    final Map<String, Supplier<BasePersistence>> sessionSupplierMap = new HashMap<String, Supplier<BasePersistence>>();
    protected final PolarisDiagnostics diagServices = new PolarisDefaultDiagServiceImpl();
    @Inject
    PolarisStorageIntegrationProvider storageIntegrationProvider;
    @Inject
    Instance<DataSource> dataSource;
    @Inject
    RelationalJdbcConfiguration relationalJdbcConfiguration;
    @Inject
    PolarisConfigurationStore configurationStore;

    protected JdbcMetaStoreManagerFactory() {
    }

    protected PrincipalSecretsGenerator secretsGenerator(RealmContext realmContext, @Nullable RootCredentialsSet rootCredentialsSet) {
        if (rootCredentialsSet != null) {
            return PrincipalSecretsGenerator.bootstrap((String)realmContext.getRealmIdentifier(), (RootCredentialsSet)rootCredentialsSet);
        }
        return PrincipalSecretsGenerator.RANDOM_SECRETS;
    }

    protected PolarisMetaStoreManager createNewMetaStoreManager() {
        return new AtomicOperationMetaStoreManager();
    }

    private void initializeForRealm(RealmContext realmContext, RootCredentialsSet rootCredentialsSet, boolean isBootstrap) {
        DatabaseType databaseType;
        try {
            databaseType = this.getDatabaseType();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        DatasourceOperations databaseOperations = this.getDatasourceOperations(isBootstrap, databaseType);
        this.sessionSupplierMap.put(realmContext.getRealmIdentifier(), () -> new JdbcBasePersistenceImpl(databaseOperations, this.secretsGenerator(realmContext, rootCredentialsSet), this.storageIntegrationProvider, realmContext.getRealmIdentifier()));
        PolarisMetaStoreManager metaStoreManager = this.createNewMetaStoreManager();
        this.metaStoreManagerMap.put(realmContext.getRealmIdentifier(), metaStoreManager);
    }

    protected DatabaseType getDatabaseType() throws SQLException {
        try (Connection connection = ((DataSource)this.dataSource.get()).getConnection();){
            String productName = connection.getMetaData().getDatabaseProductName();
            DatabaseType databaseType = DatabaseType.fromDisplayName(productName);
            return databaseType;
        }
    }

    private DatasourceOperations getDatasourceOperations(boolean isBootstrap, DatabaseType databaseType) {
        DatasourceOperations databaseOperations = new DatasourceOperations((DataSource)this.dataSource.get(), databaseType, this.relationalJdbcConfiguration);
        if (isBootstrap) {
            try {
                databaseOperations.executeScript(databaseType.getInitScriptResource());
            }
            catch (SQLException e) {
                throw new RuntimeException(String.format("Error executing sql script: %s", e.getMessage()), e);
            }
        }
        return databaseOperations;
    }

    public synchronized Map<String, PrincipalSecretsResult> bootstrapRealms(Iterable<String> realms, RootCredentialsSet rootCredentialsSet) {
        HashMap<String, PrincipalSecretsResult> results = new HashMap<String, PrincipalSecretsResult>();
        for (String realm : realms) {
            RealmContext realmContext = () -> realm;
            if (this.metaStoreManagerMap.containsKey(realm)) continue;
            this.initializeForRealm(realmContext, rootCredentialsSet, true);
            PrincipalSecretsResult secretsResult = this.bootstrapServiceAndCreatePolarisPrincipalForRealm(realmContext, this.metaStoreManagerMap.get(realm));
            results.put(realm, secretsResult);
        }
        return Map.copyOf(results);
    }

    public Map<String, BaseResult> purgeRealms(Iterable<String> realms) {
        HashMap<String, BaseResult> results = new HashMap<String, BaseResult>();
        for (String realm : realms) {
            RealmContext realmContext = () -> realm;
            PolarisMetaStoreManager metaStoreManager = this.getOrCreateMetaStoreManager(realmContext);
            BasePersistence session = this.getOrCreateSessionSupplier(realmContext).get();
            PolarisCallContext callContext = new PolarisCallContext(realmContext, session, this.diagServices);
            BaseResult result = metaStoreManager.purge(callContext);
            results.put(realm, result);
            this.storageCredentialCacheMap.remove(realm);
            this.sessionSupplierMap.remove(realm);
            this.metaStoreManagerMap.remove(realm);
        }
        return Map.copyOf(results);
    }

    public synchronized PolarisMetaStoreManager getOrCreateMetaStoreManager(RealmContext realmContext) {
        if (!this.metaStoreManagerMap.containsKey(realmContext.getRealmIdentifier())) {
            this.initializeForRealm(realmContext, null, false);
            this.checkPolarisServiceBootstrappedForRealm(realmContext, this.metaStoreManagerMap.get(realmContext.getRealmIdentifier()));
        }
        return this.metaStoreManagerMap.get(realmContext.getRealmIdentifier());
    }

    public synchronized Supplier<BasePersistence> getOrCreateSessionSupplier(RealmContext realmContext) {
        if (!this.sessionSupplierMap.containsKey(realmContext.getRealmIdentifier())) {
            this.initializeForRealm(realmContext, null, false);
            this.checkPolarisServiceBootstrappedForRealm(realmContext, this.metaStoreManagerMap.get(realmContext.getRealmIdentifier()));
        } else {
            this.checkPolarisServiceBootstrappedForRealm(realmContext, this.metaStoreManagerMap.get(realmContext.getRealmIdentifier()));
        }
        return this.sessionSupplierMap.get(realmContext.getRealmIdentifier());
    }

    public synchronized StorageCredentialCache getOrCreateStorageCredentialCache(RealmContext realmContext) {
        if (!this.storageCredentialCacheMap.containsKey(realmContext.getRealmIdentifier())) {
            this.storageCredentialCacheMap.put(realmContext.getRealmIdentifier(), new StorageCredentialCache(realmContext, this.configurationStore));
        }
        return this.storageCredentialCacheMap.get(realmContext.getRealmIdentifier());
    }

    public synchronized EntityCache getOrCreateEntityCache(RealmContext realmContext) {
        if (!this.entityCacheMap.containsKey(realmContext.getRealmIdentifier())) {
            PolarisMetaStoreManager metaStoreManager = this.getOrCreateMetaStoreManager(realmContext);
            this.entityCacheMap.put(realmContext.getRealmIdentifier(), (EntityCache)new InMemoryEntityCache(realmContext, this.configurationStore, metaStoreManager));
        }
        return this.entityCacheMap.get(realmContext.getRealmIdentifier());
    }

    private PrincipalSecretsResult bootstrapServiceAndCreatePolarisPrincipalForRealm(RealmContext realmContext, PolarisMetaStoreManager metaStoreManager) {
        EntityResult preliminaryRootPrincipalLookup;
        PolarisCallContext polarisContext = new PolarisCallContext(realmContext, this.sessionSupplierMap.get(realmContext.getRealmIdentifier()).get(), this.diagServices);
        if (CallContext.getCurrentContext() == null) {
            CallContext.setCurrentContext((CallContext)polarisContext);
        }
        if ((preliminaryRootPrincipalLookup = metaStoreManager.readEntityByName(polarisContext, null, PolarisEntityType.PRINCIPAL, PolarisEntitySubType.NULL_SUBTYPE, PolarisEntityConstants.getRootPrincipalName())).isSuccess()) {
            String overrideMessage = "It appears this metastore manager has already been bootstrapped. To continue bootstrapping, please first purge the metastore with the `purge` command.";
            LOGGER.error("\n\n {} \n\n", (Object)overrideMessage);
            throw new IllegalArgumentException(overrideMessage);
        }
        metaStoreManager.bootstrapPolarisService(polarisContext);
        EntityResult rootPrincipalLookup = metaStoreManager.readEntityByName(polarisContext, null, PolarisEntityType.PRINCIPAL, PolarisEntitySubType.NULL_SUBTYPE, PolarisEntityConstants.getRootPrincipalName());
        PrincipalSecretsResult secrets = metaStoreManager.loadPrincipalSecrets(polarisContext, (String)PolarisEntity.of((PolarisBaseEntity)rootPrincipalLookup.getEntity()).getInternalPropertiesAsMap().get(PolarisEntityConstants.getClientIdPropertyName()));
        return secrets;
    }

    private void checkPolarisServiceBootstrappedForRealm(RealmContext realmContext, PolarisMetaStoreManager metaStoreManager) {
        EntityResult rootPrincipalLookup;
        PolarisCallContext polarisContext = new PolarisCallContext(realmContext, this.sessionSupplierMap.get(realmContext.getRealmIdentifier()).get(), this.diagServices);
        if (CallContext.getCurrentContext() == null) {
            CallContext.setCurrentContext((CallContext)polarisContext);
        }
        if (!(rootPrincipalLookup = metaStoreManager.readEntityByName(polarisContext, null, PolarisEntityType.PRINCIPAL, PolarisEntitySubType.NULL_SUBTYPE, PolarisEntityConstants.getRootPrincipalName())).isSuccess()) {
            LOGGER.error("\n\n Realm {} is not bootstrapped, could not load root principal. Please run Bootstrap command. \n\n", (Object)realmContext.getRealmIdentifier());
            throw new IllegalStateException("Realm is not bootstrapped, please run server in bootstrap mode.");
        }
    }
}

