/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.persistence.impl.eclipselink;

import io.smallrye.common.annotation.Identifier;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.nio.file.Path;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.persistence.LocalPolarisMetaStoreManagerFactory;
import org.apache.polaris.core.persistence.bootstrap.RootCredentialsSet;
import org.apache.polaris.core.persistence.transactional.TransactionalPersistence;
import org.apache.polaris.core.storage.PolarisStorageIntegrationProvider;
import org.apache.polaris.extension.persistence.impl.eclipselink.EclipseLinkConfiguration;
import org.apache.polaris.extension.persistence.impl.eclipselink.PolarisEclipseLinkMetaStoreSessionImpl;
import org.apache.polaris.extension.persistence.impl.eclipselink.PolarisEclipseLinkStore;

@ApplicationScoped
@Identifier(value="eclipse-link")
public class EclipseLinkPolarisMetaStoreManagerFactory
extends LocalPolarisMetaStoreManagerFactory<PolarisEclipseLinkStore> {
    @Inject
    EclipseLinkConfiguration eclipseLinkConfiguration;
    @Inject
    PolarisStorageIntegrationProvider storageIntegrationProvider;

    protected EclipseLinkPolarisMetaStoreManagerFactory() {
        this(null, null);
    }

    @Inject
    protected EclipseLinkPolarisMetaStoreManagerFactory(PolarisDiagnostics diagnostics, PolarisConfigurationStore configurationStore) {
        super(diagnostics, configurationStore);
    }

    protected PolarisEclipseLinkStore createBackingStore(@Nonnull PolarisDiagnostics diagnostics) {
        return new PolarisEclipseLinkStore(diagnostics);
    }

    protected TransactionalPersistence createMetaStoreSession(@Nonnull PolarisEclipseLinkStore store, @Nonnull RealmContext realmContext, @Nullable RootCredentialsSet rootCredentialsSet, @Nonnull PolarisDiagnostics diagnostics) {
        return new PolarisEclipseLinkMetaStoreSessionImpl(store, this.storageIntegrationProvider, realmContext, this.configurationFile(), this.persistenceUnitName(), this.secretsGenerator(realmContext, rootCredentialsSet));
    }

    private String configurationFile() {
        return this.eclipseLinkConfiguration.configurationFile().map(Path::toString).orElse(null);
    }

    private String persistenceUnitName() {
        return this.eclipseLinkConfiguration.configurationFile().isPresent() ? this.eclipseLinkConfiguration.persistenceUnit() : null;
    }
}

