/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.docs.generator;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.HiddenTree;
import com.sun.source.doctree.IndexTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.SummaryTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.doctree.ValueTree;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import org.apache.commons.text.StringEscapeUtils;

public abstract class MarkdownFormatter {
    private final Element element;
    private String javadocDeprecated;
    private String javadocSee;
    private String javadocHidden;
    private String javadocSince;
    private String javadocSummary;
    private String javadocBody;

    public MarkdownFormatter(Element element, DocCommentTree commentTree) {
        this.element = element;
        if (commentTree != null) {
            for (DocTree docTree : commentTree.getBlockTags()) {
                switch (docTree.getKind()) {
                    case SEE: {
                        SeeTree seeTree = (SeeTree)docTree;
                        List<? extends DocTree> reference = seeTree.getReference();
                        this.javadocSee = this.format(reference);
                        break;
                    }
                    case DEPRECATED: {
                        DeprecatedTree deprecatedTree = (DeprecatedTree)docTree;
                        List<? extends DocTree> body = deprecatedTree.getBody();
                        this.javadocDeprecated = this.format(body);
                        break;
                    }
                    case HIDDEN: {
                        HiddenTree hiddenTree = (HiddenTree)docTree;
                        List<? extends DocTree> body = hiddenTree.getBody();
                        this.javadocHidden = this.format(body);
                        break;
                    }
                    case SINCE: {
                        SinceTree sinceTree = (SinceTree)docTree;
                        List<? extends DocTree> body = sinceTree.getBody();
                        this.javadocSince = this.format(body);
                        break;
                    }
                }
            }
            List<? extends DocTree> fullBody = commentTree.getFullBody();
            if (!fullBody.isEmpty()) {
                List<? extends DocTree> list = switch (fullBody.getFirst().getKind()) {
                    case DocTree.Kind.SUMMARY -> {
                        SummaryTree summaryTree = (SummaryTree)fullBody.getFirst();
                        this.javadocSummary = this.format(summaryTree.getSummary());
                        yield fullBody.subList(1, fullBody.size());
                    }
                    default -> {
                        this.javadocSummary = this.format(commentTree.getFirstSentence());
                        yield commentTree.getBody();
                    }
                };
                this.javadocBody = this.format(list);
            }
        }
    }

    public String description() {
        StringBuilder sb = new StringBuilder();
        if (this.javadocSummary != null) {
            sb.append(this.javadocSummary);
        }
        if (this.javadocBody != null) {
            sb.append(' ').append(this.javadocBody);
        }
        if (this.javadocSince != null) {
            sb.append("\n\nSince: ").append(this.javadocSince);
        }
        if (this.javadocSee != null) {
            sb.append("\n\nSee: ").append(this.javadocSee);
        }
        if (this.javadocDeprecated != null) {
            sb.append("\n\n_Deprecated_ ").append(this.javadocDeprecated);
        } else if (this.element != null) {
            boolean deprecated;
            boolean bl = deprecated = this.element.getAnnotation(Deprecated.class) != null;
            if (deprecated) {
                sb.append("\n\n_Deprecated_ ");
            }
        }
        return sb.toString();
    }

    public boolean isHidden() {
        return this.javadocHidden != null;
    }

    private String format(List<? extends DocTree> docTrees) {
        String s = new MDFormat().formatList(docTrees);
        String r;
        while (!(r = s.replaceAll("\n\n\n", "\n\n")).equals(s)) {
            s = r;
        }
        return s;
    }

    private class MDFormat {
        final Deque<Target> stack = new ArrayDeque<Target>();

        private MDFormat() {
        }

        String formatList(List<? extends DocTree> docTrees) {
            RootTarget root = new RootTarget();
            this.stack.add(root);
            this.process(docTrees);
            return root.text.toString();
        }

        private void process(List<? extends DocTree> docTrees) {
            for (DocTree docTree : docTrees) {
                this.process(docTree);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void process(DocTree doc) {
            Target target = Objects.requireNonNull(this.stack.peekLast());
            block0 : switch (doc.getKind()) {
                case DOC_COMMENT: {
                    DocCommentTree docCommentTree = (DocCommentTree)doc;
                    List<? extends DocTree> first = docCommentTree.getFirstSentence();
                    for (DocTree docTree : first) {
                        this.process(docTree);
                    }
                    List<? extends DocTree> body = docCommentTree.getBody();
                    for (DocTree docTree : body) {
                        this.process(docTree);
                    }
                    List<? extends DocTree> list = docCommentTree.getBlockTags();
                    this.process(list);
                    break;
                }
                case COMMENT: {
                    break;
                }
                case CODE: {
                    LiteralTree literalTree = (LiteralTree)doc;
                    TextTree body = literalTree.getBody();
                    target.addCode(body.getBody());
                    break;
                }
                case LINK: {
                    this.link((LinkTree)doc, target, true);
                    break;
                }
                case LINK_PLAIN: {
                    this.link((LinkTree)doc, target, false);
                    break;
                }
                case VALUE: {
                    this.value((ValueTree)doc, target);
                    break;
                }
                case INDEX: {
                    IndexTree indexTree = (IndexTree)doc;
                    DocTree searchTerm = indexTree.getSearchTerm();
                    this.process(searchTerm);
                    break;
                }
                case SUMMARY: {
                    SummaryTree summaryTree = (SummaryTree)doc;
                    List<? extends DocTree> summary = summaryTree.getSummary();
                    this.process(summary);
                    break;
                }
                case DOC_ROOT: 
                case DOC_TYPE: 
                case INHERIT_DOC: {
                    break;
                }
                case ENTITY: {
                    EntityTree entityTree = (EntityTree)doc;
                    String unescaped = StringEscapeUtils.unescapeHtml4((String)entityTree.toString());
                    target.addText(unescaped);
                    break;
                }
                case IDENTIFIER: {
                    break;
                }
                case REFERENCE: {
                    ReferenceTree referenceTree = (ReferenceTree)doc;
                    String signature = referenceTree.getSignature();
                    target.text.append(signature);
                    break;
                }
                case TEXT: {
                    TextTree textTree = (TextTree)doc;
                    target.addText(textTree.getBody());
                    break;
                }
                case LITERAL: {
                    LiteralTree literalTree = (LiteralTree)doc;
                    TextTree textTree = literalTree.getBody();
                    target.addText(textTree.getBody());
                    break;
                }
                case ERRONEOUS: {
                    ErroneousTree erroneousTree = (ErroneousTree)doc;
                    target.addText(erroneousTree.getBody());
                    break;
                }
                case UNKNOWN_BLOCK_TAG: {
                    UnknownBlockTagTree unknownBlockTagTree = (UnknownBlockTagTree)doc;
                    List<? extends DocTree> content = unknownBlockTagTree.getContent();
                    this.process(content);
                    break;
                }
                case UNKNOWN_INLINE_TAG: {
                    UnknownInlineTagTree unknownInlineTagTree = (UnknownInlineTagTree)doc;
                    List<? extends DocTree> content = unknownInlineTagTree.getContent();
                    this.process(content);
                    break;
                }
                case START_ELEMENT: {
                    StartElementTree startElementTree = (StartElementTree)doc;
                    Name name = startElementTree.getName();
                    List<? extends DocTree> attributes = startElementTree.getAttributes();
                    Map<String, String> map = attributes.stream().filter(d -> d.getKind() == DocTree.Kind.ATTRIBUTE).map(AttributeTree.class::cast).collect(Collectors.toMap(a -> a.getName().toString().toLowerCase(Locale.ROOT), a -> MarkdownFormatter.this.format(a.getValue())));
                    switch (name.toString().toLowerCase(Locale.ROOT)) {
                        case "p": {
                            target.text.append("\n\n").append(target.indent);
                            break;
                        }
                        case "a": {
                            target.text.append('[');
                            this.stack.addLast(new ATagTarget(target.indent, map));
                            break;
                        }
                        case "em": 
                        case "i": {
                            target.text.append('_');
                            break;
                        }
                        case "b": {
                            target.text.append("**");
                            break;
                        }
                        case "ol": {
                            target.text.append("\n\n");
                            this.stack.addLast(new OrderedListTarget(target.indent));
                            break;
                        }
                        case "ul": {
                            target.text.append("\n\n");
                            this.stack.addLast(new UnorderedListTarget(target.indent));
                            break;
                        }
                        case "li": {
                            while (true) {
                                if (target instanceof ListTarget) break;
                                Target last = this.stack.removeLast();
                                target = this.stack.peekLast();
                                Objects.requireNonNull(target).text.append((CharSequence)last.text);
                            }
                            ListTarget listTarget = (ListTarget)target;
                            target.text.append(listTarget.itemPrefix);
                            this.stack.addLast(listTarget.newItem());
                            break;
                        }
                        case "code": {
                            target.text.append('`');
                            break;
                        }
                    }
                    this.process(attributes);
                    break;
                }
                case END_ELEMENT: {
                    void var6_44;
                    EndElementTree endElementTree = (EndElementTree)doc;
                    Name name = endElementTree.getName();
                    String string = name.toString().toLowerCase(Locale.ROOT);
                    int n = -1;
                    switch (string.hashCode()) {
                        case 112: {
                            if (!string.equals("p")) break;
                            boolean bl = false;
                            break;
                        }
                        case 97: {
                            if (!string.equals("a")) break;
                            boolean bl = true;
                            break;
                        }
                        case 3240: {
                            if (!string.equals("em")) break;
                            int n2 = 2;
                            break;
                        }
                        case 105: {
                            if (!string.equals("i")) break;
                            int n3 = 3;
                            break;
                        }
                        case 98: {
                            if (!string.equals("b")) break;
                            int n4 = 4;
                            break;
                        }
                        case 3549: {
                            if (!string.equals("ol")) break;
                            int n5 = 5;
                            break;
                        }
                        case 3735: {
                            if (!string.equals("ul")) break;
                            int n6 = 6;
                            break;
                        }
                        case 3453: {
                            if (!string.equals("li")) break;
                            int n7 = 7;
                            break;
                        }
                        case 3059181: {
                            if (!string.equals("code")) break;
                            int n8 = 8;
                        }
                    }
                    switch (var6_44) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            ATagTarget aTagTarget = (ATagTarget)this.stack.removeLast();
                            target = this.stack.peekLast();
                            Objects.requireNonNull(target).addText(aTagTarget.text.toString());
                            target.text.append("](").append(aTagTarget.attributes.get("href")).append(")");
                            break block0;
                        }
                        case 2: 
                        case 3: {
                            target.trimRight();
                            target.text.append('_');
                            break block0;
                        }
                        case 4: {
                            target.trimRight();
                            target.text.append("**");
                            break block0;
                        }
                        case 5: 
                        case 6: {
                            while (!(target instanceof ListTarget)) {
                                Target last = this.stack.removeLast();
                                target = this.stack.peekLast();
                                Objects.requireNonNull(target).text.append((CharSequence)last.text);
                            }
                            Target list = this.stack.removeLast();
                            target = this.stack.peekLast();
                            Objects.requireNonNull(target).text.append((CharSequence)list.text).append("\n\n");
                            break block0;
                        }
                        case 7: {
                            while (!(target instanceof ListTarget)) {
                                Target last = this.stack.removeLast();
                                target = this.stack.peekLast();
                                Objects.requireNonNull(target).text.append((CharSequence)last.text);
                            }
                            Objects.requireNonNull(this.stack.peekLast()).text.append((CharSequence)this.stack.removeLast().text);
                            break block0;
                        }
                        case 8: {
                            target.text.append('`');
                            break block0;
                        }
                    }
                    break;
                }
                case ATTRIBUTE: {
                    break;
                }
                case SEE: 
                case DEPRECATED: 
                case HIDDEN: 
                case SINCE: 
                case AUTHOR: 
                case EXCEPTION: 
                case PARAM: 
                case PROVIDES: 
                case RETURN: 
                case SERIAL: 
                case SERIAL_DATA: 
                case SERIAL_FIELD: 
                case THROWS: 
                case USES: 
                case VERSION: {
                    break;
                }
            }
        }

        private void value(ValueTree valueTree, Target target) {
            ReferenceTree reference = valueTree.getReference();
            String signature = reference.getSignature().trim();
            if (signature.startsWith("#") && MarkdownFormatter.this.element != null) {
                Optional<Element> referenced = MarkdownFormatter.this.element.getEnclosingElement().getEnclosedElements().stream().filter(enc -> enc.getSimpleName().toString().equals(signature.substring(1))).findFirst();
                if (referenced.isPresent()) {
                    Element ref = referenced.get();
                    if (ref instanceof VariableElement) {
                        VariableElement variableElement = (VariableElement)ref;
                        Object value = variableElement.getConstantValue();
                        if (value instanceof String) {
                            target.text.append('\"').append(value).append('\"');
                        } else {
                            target.text.append(value);
                        }
                    }
                } else {
                    target.text.append(signature);
                }
            } else {
                this.process(reference);
            }
        }

        private void link(LinkTree linkTree, Target target, boolean codeValue) {
            List<? extends DocTree> label = linkTree.getLabel();
            if (!label.isEmpty()) {
                this.process(label);
            }
            ReferenceTree reference = linkTree.getReference();
            String signature = reference.getSignature().trim();
            target.maybeAddSeparator();
            target.text.append("(");
            if (codeValue) {
                target.text.append('`');
            }
            if (signature.startsWith("#") && MarkdownFormatter.this.element != null) {
                Optional<Element> referenced = MarkdownFormatter.this.element.getEnclosingElement().getEnclosedElements().stream().filter(enc -> enc.getSimpleName().toString().equals(signature.substring(1))).findFirst();
                if (referenced.isPresent()) {
                    Element ref = referenced.get();
                    if (ref instanceof VariableElement) {
                        VariableElement variableElement = (VariableElement)ref;
                        Object value = variableElement.getConstantValue();
                        target.text.append(value);
                    }
                } else {
                    target.text.append(signature);
                }
            } else {
                this.process(reference);
            }
            if (codeValue) {
                target.text.append('`');
            }
            target.text.append(')');
        }
    }

    static abstract class Target {
        final StringBuilder text = new StringBuilder();
        final String indent;

        Target(String indent) {
            this.indent = indent;
        }

        void addText(String text) {
            this.addTextOrCode(text, false);
        }

        void addTextOrCode(String text, boolean code) {
            String t = text.replaceAll("\n", " ");
            if ((t = t.replaceFirst("^\\s*", "")).isEmpty() && !text.isEmpty()) {
                this.maybeAddSeparator();
                return;
            }
            String e = text.replaceFirst("\\s*$", "");
            if (text.charAt(0) != t.charAt(0)) {
                this.maybeAddSeparator();
            }
            if (code) {
                this.text.append('`');
            }
            this.text.append(t);
            if (code) {
                this.text.append('`');
            }
            if (!e.equals(t)) {
                this.maybeAddSeparator();
            }
        }

        void addCode(String text) {
            this.addTextOrCode(text, true);
        }

        void maybeAddSeparator() {
            int len = this.text.length();
            if (len == 0) {
                return;
            }
            if (Character.isWhitespace(this.text.charAt(len - 1))) {
                return;
            }
            this.text.append(' ');
        }

        void trimRight() {
            int l = this.text.length();
            while (l > 0 && Character.isWhitespace(this.text.charAt(l - 1))) {
                this.text.setLength(--l);
            }
        }
    }

    static class ATagTarget
    extends Target {
        final Map<String, String> attributes;

        ATagTarget(String indent, Map<String, String> attributes) {
            super(indent);
            this.attributes = attributes;
        }
    }

    static class ListItemTarget
    extends Target {
        ListItemTarget(String indent) {
            super(indent);
        }
    }

    static class UnorderedListTarget
    extends ListTarget {
        UnorderedListTarget(String indent) {
            super("\n" + indent + " * ", indent + "   ");
        }
    }

    static class OrderedListTarget
    extends ListTarget {
        OrderedListTarget(String indent) {
            super("\n" + indent + " 1. ", indent + "    ");
        }
    }

    static abstract class ListTarget
    extends Target {
        final String itemPrefix;

        public ListTarget(String itemPrefix, String indent) {
            super(indent);
            this.itemPrefix = itemPrefix;
        }

        ListItemTarget newItem() {
            return new ListItemTarget(this.indent);
        }
    }

    static class RootTarget
    extends Target {
        RootTarget() {
            super("");
        }
    }
}

