/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.docs.generator;

import com.sun.source.doctree.DocCommentTree;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.TypeElement;
import org.apache.polaris.docs.generator.MarkdownPropertyFormatter;
import org.apache.polaris.docs.generator.MarkdownTypeFormatter;
import org.apache.polaris.docs.generator.SmallRyeConfigPropertyInfo;

public class SmallRyeConfigSectionPage {
    final String section;
    final List<String> lines = new ArrayList<String>();
    final TypeElement typeElement;
    DocCommentTree comment;
    boolean empty = true;
    int sectionRef;

    SmallRyeConfigSectionPage(String section, TypeElement typeElement, DocCommentTree comment) {
        this.section = section;
        this.typeElement = typeElement;
        this.comment = comment;
    }

    public void addProperty(String propertyFullName, SmallRyeConfigPropertyInfo propertyInfo, MarkdownPropertyFormatter md) {
        if (this.empty) {
            this.lines.add("| Property | Default Value | Type | Description |");
            this.lines.add("|----------|---------------|------|-------------|");
            this.empty = false;
        }
        String fullNameCode = ("`" + propertyFullName + "`").replaceAll("``", "");
        String dv = propertyInfo.defaultValue();
        this.lines.add("| " + fullNameCode + " | " + (String)(dv != null ? (dv.isEmpty() ? "(empty)" : "`" + dv + "`") : "") + " | " + md.propertyType() + " | " + md.description().replaceAll("\n", "<br>") + " |");
    }

    public boolean isEmpty() {
        return this.comment == null && this.empty;
    }

    public void writeTo(PrintWriter pw) {
        if (this.comment != null) {
            MarkdownTypeFormatter typeFormatter = new MarkdownTypeFormatter(this.typeElement, this.comment);
            pw.println(typeFormatter.description().trim());
            pw.println();
        }
        this.lines.forEach(pw::println);
    }

    public void incrementSectionRef() {
        if (++this.sectionRef > 1) {
            this.comment = null;
        }
    }
}

