/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.docs.generator;

import com.sun.source.doctree.DocCommentTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.AbstractElementVisitor8;
import jdk.javadoc.doclet.DocletEnvironment;
import org.apache.polaris.docs.ConfigDocs;
import org.apache.polaris.docs.generator.PropertiesConfigItem;

public class PropertiesConfigPageGroup {
    public static final Set<Modifier> EXPECTED_FIELD_MODIFIERS = Set.of(Modifier.FINAL, Modifier.STATIC);
    private final String name;
    private final Map<String, List<PropertiesConfigItem>> items = new LinkedHashMap<String, List<PropertiesConfigItem>>();

    public PropertiesConfigPageGroup(String name) {
        this.name = name;
    }

    public Map<String, Iterable<PropertiesConfigItem>> sectionItems() {
        LinkedHashMap<String, Iterable<PropertiesConfigItem>> sections = new LinkedHashMap<String, Iterable<PropertiesConfigItem>>();
        this.forEachSection(sections::put);
        return sections;
    }

    public void forEachSection(BiConsumer<String, Iterable<PropertiesConfigItem>> consumer) {
        HashSet<String> processedSections = new HashSet<String>();
        for (Map.Entry<String, List<PropertiesConfigItem>> e : this.items.entrySet()) {
            String section = e.getKey();
            if (!processedSections.add(section)) continue;
            consumer.accept(section, (Iterable<PropertiesConfigItem>)e.getValue());
        }
    }

    public String name() {
        return this.name;
    }

    ElementVisitor<Void, DocletEnvironment> visitor() {
        return new AbstractElementVisitor8<Void, DocletEnvironment>(){

            @Override
            public Void visitPackage(PackageElement e, DocletEnvironment env) {
                return null;
            }

            @Override
            public Void visitType(TypeElement e, DocletEnvironment env) {
                return e.accept(this, env);
            }

            @Override
            public Void visitVariable(VariableElement e, DocletEnvironment env) {
                ConfigDocs.ConfigItem configItem = e.getAnnotation(ConfigDocs.ConfigItem.class);
                if (configItem != null) {
                    Object propertyKey = e.getConstantValue();
                    if (e.getKind() == ElementKind.FIELD && e.getModifiers().containsAll(EXPECTED_FIELD_MODIFIERS) && propertyKey instanceof String) {
                        DocCommentTree docComment = env.getDocTrees().getDocCommentTree(e);
                        PropertiesConfigPageGroup.this.items.computeIfAbsent(configItem.section(), g -> new ArrayList()).add(new PropertiesConfigItem(e, docComment));
                    }
                }
                return null;
            }

            @Override
            public Void visitExecutable(ExecutableElement e, DocletEnvironment env) {
                return null;
            }

            @Override
            public Void visitTypeParameter(TypeParameterElement e, DocletEnvironment env) {
                return null;
            }
        };
    }
}

