/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.docs.generator;

import com.sun.source.doctree.DocCommentTree;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import org.apache.polaris.docs.generator.MarkdownPropertyFormatter;
import org.apache.polaris.docs.generator.PropertiesConfigItem;
import org.apache.polaris.docs.generator.PropertiesConfigPageGroup;
import org.apache.polaris.docs.generator.PropertiesConfigs;
import org.apache.polaris.docs.generator.SmallRyeConfigMappingInfo;
import org.apache.polaris.docs.generator.SmallRyeConfigPropertyInfo;
import org.apache.polaris.docs.generator.SmallRyeConfigSectionPage;
import org.apache.polaris.docs.generator.SmallRyeConfigs;

public class DocGenDoclet
implements Doclet {
    private Path outputDirectory = Paths.get(".", new String[0]);
    private final Doclet.Option directoryOption = new Doclet.Option(){

        @Override
        public int getArgumentCount() {
            return 1;
        }

        @Override
        public String getDescription() {
            return "Directory to write .md files to";
        }

        @Override
        public Doclet.Option.Kind getKind() {
            return Doclet.Option.Kind.STANDARD;
        }

        @Override
        public List<String> getNames() {
            return List.of("-d", "--directory");
        }

        @Override
        public String getParameters() {
            return "directory";
        }

        @Override
        public boolean process(String option, List<String> arguments) {
            DocGenDoclet.this.outputDirectory = Paths.get(arguments.get(0), new String[0]);
            return true;
        }
    };
    private final Doclet.Option notimestampDummy = new DummyOption(List.of("-notimestamp"), 0);
    private final Doclet.Option doctitleDummy = new DummyOption(List.of("-doctitle"), 1);
    private final Doclet.Option windowtitleDummy = new DummyOption(List.of("-windowtitle"), 1);

    @Override
    public boolean run(DocletEnvironment environment) {
        PropertiesConfigs propertiesConfigs = new PropertiesConfigs(environment);
        SmallRyeConfigs smallryeConfigs = new SmallRyeConfigs(environment);
        for (Element element : environment.getIncludedElements()) {
            try {
                element.accept(propertiesConfigs.visitor(), null);
                element.accept(smallryeConfigs.visitor(), null);
            }
            catch (RuntimeException ex) {
                throw new RuntimeException("Failure processing included element " + String.valueOf(element), ex);
            }
        }
        this.propertiesConfigPages(propertiesConfigs);
        this.smallryeConfigPages(environment, smallryeConfigs);
        return true;
    }

    private void propertiesConfigPages(PropertiesConfigs propertiesConfigs) {
        for (PropertiesConfigPageGroup page : propertiesConfigs.pages()) {
            System.out.println("Generating properties config pages for " + page.name());
            for (Map.Entry<String, Iterable<PropertiesConfigItem>> e : page.sectionItems().entrySet()) {
                String section = e.getKey();
                if (section.isEmpty()) {
                    section = "main";
                }
                System.out.println("... generating page section " + section);
                Iterable<PropertiesConfigItem> items = e.getValue();
                Path file = this.outputDirectory.resolve(page.name() + "-" + this.safeFileName(section) + ".md");
                try {
                    BufferedWriter fw = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    try (PrintWriter writer = new PrintWriter(fw);){
                        writer.println("| Property | Description |");
                        writer.println("|----------|-------------|");
                        for (PropertiesConfigItem item : items) {
                            MarkdownPropertyFormatter md = new MarkdownPropertyFormatter(item);
                            if (md.isHidden()) continue;
                            writer.print("| `");
                            writer.print(md.propertyName());
                            writer.print("` | ");
                            writer.print(md.description().replaceAll("\n", "<br>"));
                            writer.println(" |");
                        }
                    }
                    finally {
                        if (fw == null) continue;
                        fw.close();
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private void smallryeConfigPages(DocletEnvironment environment, SmallRyeConfigs smallryeConfigs) {
        HashMap<String, SmallRyeConfigSectionPage> sectionPages = new HashMap<String, SmallRyeConfigSectionPage>();
        for (SmallRyeConfigMappingInfo mappingInfo : smallryeConfigs.configMappingInfos()) {
            this.smallryeProcessRootMappingInfo(environment, smallryeConfigs, mappingInfo, sectionPages);
        }
        sectionPages.values().stream().filter(p -> !p.isEmpty()).forEach(page -> {
            System.out.printf("... generating smallrye config page for section %s%n", page.section);
            Path file = this.outputDirectory.resolve("smallrye-" + this.safeFileName(page.section) + ".md");
            try (PrintWriter pw = new PrintWriter(Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));){
                page.writeTo(pw);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void smallryeProcessRootMappingInfo(DocletEnvironment environment, SmallRyeConfigs smallryeConfigs, SmallRyeConfigMappingInfo mappingInfo, Map<String, SmallRyeConfigSectionPage> sectionPages) {
        String effectiveSection = mappingInfo.prefix();
        String propertyNamePrefix = mappingInfo.prefix();
        this.smallryeProcessMappingInfo("", environment, smallryeConfigs, effectiveSection, mappingInfo, propertyNamePrefix, sectionPages);
    }

    private void smallryeProcessPropertyMappingInfo(String logIndent, DocletEnvironment environment, SmallRyeConfigs smallryeConfigs, String section, SmallRyeConfigMappingInfo mappingInfo, String propertyNamePrefix, Map<String, SmallRyeConfigSectionPage> sectionPages) {
        this.smallryeProcessMappingInfo(logIndent + "  ", environment, smallryeConfigs, section, mappingInfo, propertyNamePrefix, sectionPages);
    }

    private void smallryeProcessMappingInfo(String logIndent, DocletEnvironment environment, SmallRyeConfigs smallryeConfigs, String effectiveSection, SmallRyeConfigMappingInfo mappingInfo, String propertyNamePrefix, Map<String, SmallRyeConfigSectionPage> sectionPages) {
        sectionPages.computeIfAbsent(effectiveSection, s -> new SmallRyeConfigSectionPage((String)s, mappingInfo.element(), mappingInfo.typeComment()));
        mappingInfo.properties(environment).forEach(prop -> this.smallryeProcessProperty(logIndent, environment, smallryeConfigs, mappingInfo, effectiveSection, (SmallRyeConfigPropertyInfo)prop, propertyNamePrefix, sectionPages));
    }

    private void smallryeProcessProperty(String logIndent, DocletEnvironment environment, SmallRyeConfigs smallryeConfigs, SmallRyeConfigMappingInfo mappingInfo, String section, SmallRyeConfigPropertyInfo propertyInfo, String propertyNamePrefix, Map<String, SmallRyeConfigSectionPage> sectionPages) {
        String effectiveSection = propertyInfo.prefixOverride().map(o -> SmallRyeConfigs.concatWithDot(section, o)).orElse(section);
        MarkdownPropertyFormatter md = new MarkdownPropertyFormatter(propertyInfo);
        if (md.isHidden()) {
            return;
        }
        String fullName = this.formatPropertyName(propertyNamePrefix, md.propertyName(), md.propertySuffix());
        SmallRyeConfigSectionPage page = sectionPages.computeIfAbsent(effectiveSection, s -> {
            DocCommentTree doc = propertyInfo.sectionDocFromType() ? (DocCommentTree)propertyInfo.groupType().map(smallryeConfigs::getConfigMappingInfo).map(SmallRyeConfigMappingInfo::typeComment).orElse(null) : propertyInfo.doc();
            return new SmallRyeConfigSectionPage((String)s, mappingInfo.element(), doc);
        });
        propertyInfo.prefixOverride().ifPresent(o -> page.incrementSectionRef());
        if (propertyInfo.isSettableType()) {
            page.addProperty(fullName, propertyInfo, md);
        }
        propertyInfo.groupType().ifPresent(groupType -> this.smallryeProcessPropertyMappingInfo(logIndent + "  ", environment, smallryeConfigs, effectiveSection, smallryeConfigs.getConfigMappingInfo((Class<?>)groupType), fullName, sectionPages));
    }

    private String formatPropertyName(String propertyNamePrefix, String propertyName, String propertySuffix) {
        String r = SmallRyeConfigs.concatWithDot(propertyNamePrefix, propertyName);
        return propertySuffix.isEmpty() ? r : SmallRyeConfigs.concatWithDot(r, "`_`<" + propertySuffix + ">`_`");
    }

    private String safeFileName(String str) {
        StringBuilder sb = new StringBuilder();
        int len = str.length();
        boolean hadLOD = false;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                hadLOD = true;
                continue;
            }
            if (!hadLOD) continue;
            sb.append('_');
            hadLOD = false;
        }
        return sb.toString();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        return Set.of(this.directoryOption, this.doctitleDummy, this.windowtitleDummy, this.notimestampDummy);
    }

    @Override
    public String getName() {
        return "PolarisReferenceDocsDoclet";
    }

    @Override
    public void init(Locale locale, Reporter reporter) {
    }

    static final class DummyOption
    implements Doclet.Option {
        private final List<String> names;
        private final int argumentCount;

        DummyOption(List<String> names, int argumentCount) {
            this.names = names;
            this.argumentCount = argumentCount;
        }

        @Override
        public boolean process(String option, List<String> arguments) {
            return true;
        }

        @Override
        public String getParameters() {
            return "";
        }

        @Override
        public List<String> getNames() {
            return this.names;
        }

        @Override
        public Doclet.Option.Kind getKind() {
            return null;
        }

        @Override
        public String getDescription() {
            return "Ignored";
        }

        @Override
        public int getArgumentCount() {
            return this.argumentCount;
        }
    }
}

