package org.apache.polaris.service.admin.api;

import org.apache.polaris.core.admin.model.AddGrantRequest;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogRole;
import org.apache.polaris.core.admin.model.CatalogRoles;
import org.apache.polaris.core.admin.model.Catalogs;
import org.apache.polaris.core.admin.model.CreateCatalogRequest;
import org.apache.polaris.core.admin.model.CreateCatalogRoleRequest;
import org.apache.polaris.core.admin.model.GrantResources;
import org.apache.polaris.core.admin.model.PrincipalRoles;
import org.apache.polaris.core.admin.model.RevokeGrantRequest;
import org.apache.polaris.core.admin.model.UpdateCatalogRequest;
import org.apache.polaris.core.admin.model.UpdateCatalogRoleRequest;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;

import java.util.Map;
import java.util.List;

import java.io.InputStream;

import jakarta.annotation.Nonnull;
import jakarta.annotation.security.RolesAllowed;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.core.Response;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;

import jakarta.inject.Inject;

import org.apache.polaris.core.context.RealmContext;

import org.eclipse.microprofile.faulttolerance.Timeout;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

/**
 * The catalogs API interface
 *
 * This file is automatically generated by the OpenAPI Code Generator based on configuration in the
 * build.gradle file.
 *
 */
@Path("/api/management/v1/catalogs")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.836467545Z[UTC]", comments = "Generator version: 7.12.0")
public class PolarisCatalogsApi  {
  private static final Logger LOGGER = LoggerFactory.getLogger(PolarisCatalogsApi.class);

  private final PolarisCatalogsApiService service;

  @Inject
  public PolarisCatalogsApi(PolarisCatalogsApiService service) {
    this.service = service;
  }

  /**
   * Add a new grant to the catalog role
   *
   * Response type: {@code Void}.
   * @param catalogName Required - The name of the catalog where the role will receive the grant
   * @param catalogRoleName Required - The name of the role receiving the grant (must exist)
   * @param addGrantRequest  
   *
   * @return 201 - Successful response
   * @return 403 - The principal is not authorized to create grants
   * @return 404 - The catalog or the role does not exist
   */
  @PUT
  @Path("/{catalogName}/catalog-roles/{catalogRoleName}/grants")
  @Consumes({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.catalogs.addGrantToCatalogRole")
  @Timeout
  public Response addGrantToCatalogRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogName") String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogRoleName") String catalogRoleName, @Valid AddGrantRequest addGrantRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking catalogs with params")
      .addKeyValue("operation", "addGrantToCatalogRole")
      .addKeyValue("catalogName", catalogName)
      .addKeyValue("catalogRoleName", catalogRoleName)
      .addKeyValue("addGrantRequest", String.valueOf(addGrantRequest))
      .log();

    Response ret =
      service.addGrantToCatalogRole(catalogName,catalogRoleName,addGrantRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of addGrantToCatalogRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Add a new Catalog
   *
   * Response type: {@code Void}.
   * @param createCatalogRequest Required - The Catalog to create
   *
   * @return 201 - Successful response
   * @return 403 - The caller does not have permission to create a catalog
   * @return 404 - The catalog does not exist
   * @return 409 - A catalog with the specified name already exists
   */
  @POST
  @Consumes({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.catalogs.createCatalog")
  @Timeout
  public Response createCatalog( @Nonnull @Valid CreateCatalogRequest createCatalogRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking catalogs with params")
      .addKeyValue("operation", "createCatalog")
      .addKeyValue("createCatalogRequest", String.valueOf(createCatalogRequest))
      .log();

    Response ret =
      service.createCatalog(createCatalogRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of createCatalog API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Create a new role in the catalog
   *
   * Response type: {@code Void}.
   * @param catalogName Required - The catalog for which we are reading/updating roles
   * @param createCatalogRoleRequest  
   *
   * @return 201 - Successful response
   * @return 403 - The principal is not authorized to create roles
   * @return 404 - The catalog does not exist
   */
  @POST
  @Path("/{catalogName}/catalog-roles")
  @Consumes({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.catalogs.createCatalogRole")
  @Timeout
  public Response createCatalogRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogName") String catalogName, @Valid CreateCatalogRoleRequest createCatalogRoleRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking catalogs with params")
      .addKeyValue("operation", "createCatalogRole")
      .addKeyValue("catalogName", catalogName)
      .addKeyValue("createCatalogRoleRequest", String.valueOf(createCatalogRoleRequest))
      .log();

    Response ret =
      service.createCatalogRole(catalogName,createCatalogRoleRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of createCatalogRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Delete an existing catalog. The catalog must be empty.
   *
   * Response type: {@code Void}.
   * @param catalogName Required - The name of the catalog
   *
   * @return 204 - Success, no content
   * @return 403 - The caller does not have permission to delete a catalog
   * @return 404 - The catalog does not exist
   */
  @DELETE
  @Path("/{catalogName}")
  @RolesAllowed("**")
  @Timed("polaris.catalogs.deleteCatalog")
  @Timeout
  public Response deleteCatalog( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogName") String catalogName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking catalogs with params")
      .addKeyValue("operation", "deleteCatalog")
      .addKeyValue("catalogName", catalogName)
      .log();

    Response ret =
      service.deleteCatalog(catalogName,realmContext,securityContext);
    LOGGER.debug("Completed execution of deleteCatalog API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Delete an existing role from the catalog. All associated grants will also be deleted
   *
   * Response type: {@code Void}.
   * @param catalogName Required - The catalog for which we are retrieving roles
   * @param catalogRoleName Required - The name of the role
   *
   * @return 204 - Success, no content
   * @return 403 - The principal is not authorized to delete roles
   * @return 404 - The catalog or the role does not exist
   */
  @DELETE
  @Path("/{catalogName}/catalog-roles/{catalogRoleName}")
  @RolesAllowed("**")
  @Timed("polaris.catalogs.deleteCatalogRole")
  @Timeout
  public Response deleteCatalogRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogName") String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogRoleName") String catalogRoleName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking catalogs with params")
      .addKeyValue("operation", "deleteCatalogRole")
      .addKeyValue("catalogName", catalogName)
      .addKeyValue("catalogRoleName", catalogRoleName)
      .log();

    Response ret =
      service.deleteCatalogRole(catalogName,catalogRoleName,realmContext,securityContext);
    LOGGER.debug("Completed execution of deleteCatalogRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Get the details of a catalog
   *
   * Response type: {@code Catalog}.
   * @param catalogName Required - The name of the catalog
   *
   * @return 200 - The catalog details
   * @return 403 - The caller does not have permission to read catalog details
   * @return 404 - The catalog does not exist
   */
  @GET
  @Path("/{catalogName}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.catalogs.getCatalog")
  @Timeout
  public Response getCatalog( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogName") String catalogName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking catalogs with params")
      .addKeyValue("operation", "getCatalog")
      .addKeyValue("catalogName", catalogName)
      .log();

    Response ret =
      service.getCatalog(catalogName,realmContext,securityContext);
    LOGGER.debug("Completed execution of getCatalog API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Get the details of an existing role
   *
   * Response type: {@code CatalogRole}.
   * @param catalogName Required - The catalog for which we are retrieving roles
   * @param catalogRoleName Required - The name of the role
   *
   * @return 200 - The specified role details
   * @return 403 - The principal is not authorized to read role data
   * @return 404 - The catalog or the role does not exist
   */
  @GET
  @Path("/{catalogName}/catalog-roles/{catalogRoleName}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.catalogs.getCatalogRole")
  @Timeout
  public Response getCatalogRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogName") String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogRoleName") String catalogRoleName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking catalogs with params")
      .addKeyValue("operation", "getCatalogRole")
      .addKeyValue("catalogName", catalogName)
      .addKeyValue("catalogRoleName", catalogRoleName)
      .log();

    Response ret =
      service.getCatalogRole(catalogName,catalogRoleName,realmContext,securityContext);
    LOGGER.debug("Completed execution of getCatalogRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * List the PrincipalRoles to which the target catalog role has been assigned
   *
   * Response type: {@code PrincipalRoles}.
   * @param catalogName Required - The name of the catalog where the catalog role resides
   * @param catalogRoleName Required - The name of the catalog role
   *
   * @return 200 - List the PrincipalRoles to which the target catalog role has been assigned
   * @return 403 - The caller does not have permission to list principal roles
   * @return 404 - The catalog or catalog role does not exist
   */
  @GET
  @Path("/{catalogName}/catalog-roles/{catalogRoleName}/principal-roles")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.catalogs.listAssigneePrincipalRolesForCatalogRole")
  @Timeout
  public Response listAssigneePrincipalRolesForCatalogRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogName") String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogRoleName") String catalogRoleName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking catalogs with params")
      .addKeyValue("operation", "listAssigneePrincipalRolesForCatalogRole")
      .addKeyValue("catalogName", catalogName)
      .addKeyValue("catalogRoleName", catalogRoleName)
      .log();

    Response ret =
      service.listAssigneePrincipalRolesForCatalogRole(catalogName,catalogRoleName,realmContext,securityContext);
    LOGGER.debug("Completed execution of listAssigneePrincipalRolesForCatalogRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * List existing roles in the catalog
   *
   * Response type: {@code CatalogRoles}.
   * @param catalogName Required - The catalog for which we are reading/updating roles
   *
   * @return 200 - The list of roles that exist in this catalog
   */
  @GET
  @Path("/{catalogName}/catalog-roles")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.catalogs.listCatalogRoles")
  @Timeout
  public Response listCatalogRoles( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogName") String catalogName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking catalogs with params")
      .addKeyValue("operation", "listCatalogRoles")
      .addKeyValue("catalogName", catalogName)
      .log();

    Response ret =
      service.listCatalogRoles(catalogName,realmContext,securityContext);
    LOGGER.debug("Completed execution of listCatalogRoles API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * List all catalogs in this polaris service
   *
   * Response type: {@code Catalogs}.
   *
   * @return 200 - List of catalogs in the polaris service
   * @return 403 - The caller does not have permission to list catalog details
   */
  @GET
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.catalogs.listCatalogs")
  @Timeout
  public Response listCatalogs(@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking catalogs with params")
      .addKeyValue("operation", "listCatalogs")
      .log();

    Response ret =
      service.listCatalogs(realmContext,securityContext);
    LOGGER.debug("Completed execution of listCatalogs API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * List the grants the catalog role holds
   *
   * Response type: {@code GrantResources}.
   * @param catalogName Required - The name of the catalog where the role will receive the grant
   * @param catalogRoleName Required - The name of the role receiving the grant (must exist)
   *
   * @return 200 - List of all grants given to the role in this catalog
   */
  @GET
  @Path("/{catalogName}/catalog-roles/{catalogRoleName}/grants")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.catalogs.listGrantsForCatalogRole")
  @Timeout
  public Response listGrantsForCatalogRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogName") String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogRoleName") String catalogRoleName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking catalogs with params")
      .addKeyValue("operation", "listGrantsForCatalogRole")
      .addKeyValue("catalogName", catalogName)
      .addKeyValue("catalogRoleName", catalogRoleName)
      .log();

    Response ret =
      service.listGrantsForCatalogRole(catalogName,catalogRoleName,realmContext,securityContext);
    LOGGER.debug("Completed execution of listGrantsForCatalogRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Delete a specific grant from the role. This may be a subset or a superset of the grants the role has. In case of a subset, the role will retain the grants not specified. If the &#x60;cascade&#x60; parameter is true, grant revocation will have a cascading effect - that is, if a principal has specific grants on a subresource, and grants are revoked on a parent resource, the grants present on the subresource will be revoked as well. By default, this behavior is disabled and grant revocation only affects the specified resource.
   *
   * Response type: {@code Void}.
   * @param catalogName Required - The name of the catalog where the role will receive the grant
   * @param catalogRoleName Required - The name of the role receiving the grant (must exist)
   * @param cascade  If true, the grant revocation cascades to all subresources.
   * @param revokeGrantRequest  
   *
   * @return 201 - Successful response
   * @return 403 - The principal is not authorized to create grants
   * @return 404 - The catalog or the role does not exist
   */
  @POST
  @Path("/{catalogName}/catalog-roles/{catalogRoleName}/grants")
  @Consumes({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.catalogs.revokeGrantFromCatalogRole")
  @Timeout
  public Response revokeGrantFromCatalogRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogName") String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogRoleName") String catalogRoleName, @DefaultValue("false") @QueryParam("cascade")  Boolean cascade, @Valid RevokeGrantRequest revokeGrantRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking catalogs with params")
      .addKeyValue("operation", "revokeGrantFromCatalogRole")
      .addKeyValue("catalogName", catalogName)
      .addKeyValue("catalogRoleName", catalogRoleName)
      .addKeyValue("cascade", cascade)
      .addKeyValue("revokeGrantRequest", String.valueOf(revokeGrantRequest))
      .log();

    Response ret =
      service.revokeGrantFromCatalogRole(catalogName,catalogRoleName,cascade,revokeGrantRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of revokeGrantFromCatalogRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Update an existing catalog
   *
   * Response type: {@code Catalog}.
   * @param catalogName Required - The name of the catalog
   * @param updateCatalogRequest Required - The catalog details to use in the update
   *
   * @return 200 - The catalog details
   * @return 403 - The caller does not have permission to update catalog details
   * @return 404 - The catalog does not exist
   * @return 409 - The entity version doesn't match the currentEntityVersion; retry after fetching latest version
   */
  @PUT
  @Path("/{catalogName}")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.catalogs.updateCatalog")
  @Timeout
  public Response updateCatalog( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogName") String catalogName, @Nonnull @Valid UpdateCatalogRequest updateCatalogRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking catalogs with params")
      .addKeyValue("operation", "updateCatalog")
      .addKeyValue("catalogName", catalogName)
      .addKeyValue("updateCatalogRequest", String.valueOf(updateCatalogRequest))
      .log();

    Response ret =
      service.updateCatalog(catalogName,updateCatalogRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of updateCatalog API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Update an existing role in the catalog
   *
   * Response type: {@code CatalogRole}.
   * @param catalogName Required - The catalog for which we are retrieving roles
   * @param catalogRoleName Required - The name of the role
   * @param updateCatalogRoleRequest  
   *
   * @return 200 - The specified role details
   * @return 403 - The principal is not authorized to update roles
   * @return 404 - The catalog or the role does not exist
   * @return 409 - The entity version doesn't match the currentEntityVersion; retry after fetching latest version
   */
  @PUT
  @Path("/{catalogName}/catalog-roles/{catalogRoleName}")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.catalogs.updateCatalogRole")
  @Timeout
  public Response updateCatalogRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogName") String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogRoleName") String catalogRoleName, @Valid UpdateCatalogRoleRequest updateCatalogRoleRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking catalogs with params")
      .addKeyValue("operation", "updateCatalogRole")
      .addKeyValue("catalogName", catalogName)
      .addKeyValue("catalogRoleName", catalogRoleName)
      .addKeyValue("updateCatalogRoleRequest", String.valueOf(updateCatalogRoleRequest))
      .log();

    Response ret =
      service.updateCatalogRole(catalogName,catalogRoleName,updateCatalogRoleRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of updateCatalogRole API with status code {}", ret.getStatus());
    return ret;
  }
}
