package org.apache.polaris.service.admin.api;

import org.apache.polaris.core.admin.model.CatalogRoles;
import org.apache.polaris.core.admin.model.CreatePrincipalRoleRequest;
import org.apache.polaris.core.admin.model.GrantCatalogRoleRequest;
import org.apache.polaris.core.admin.model.PrincipalRole;
import org.apache.polaris.core.admin.model.PrincipalRoles;
import org.apache.polaris.core.admin.model.Principals;
import org.apache.polaris.core.admin.model.UpdatePrincipalRoleRequest;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;

import java.util.Map;
import java.util.List;

import java.io.InputStream;

import jakarta.annotation.Nonnull;
import jakarta.annotation.security.RolesAllowed;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.core.Response;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;

import jakarta.inject.Inject;

import org.apache.polaris.core.context.RealmContext;

import org.eclipse.microprofile.faulttolerance.Timeout;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

/**
 * The principal-roles API interface
 *
 * This file is automatically generated by the OpenAPI Code Generator based on configuration in the
 * build.gradle file.
 *
 */
@Path("/api/management/v1/principal-roles")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:49.455628396Z[UTC]", comments = "Generator version: 7.12.0")
public class PolarisPrincipalRolesApi  {
  private static final Logger LOGGER = LoggerFactory.getLogger(PolarisPrincipalRolesApi.class);

  private final PolarisPrincipalRolesApiService service;

  @Inject
  public PolarisPrincipalRolesApi(PolarisPrincipalRolesApiService service) {
    this.service = service;
  }

  /**
   * Assign a catalog role to a principal role
   *
   * Response type: {@code Void}.
   * @param principalRoleName Required - The principal role name
   * @param catalogName Required - The name of the catalog where the catalogRoles reside
   * @param grantCatalogRoleRequest Required - The principal to create
   *
   * @return 201 - Successful response
   * @return 403 - The caller does not have permission to assign a catalog role
   */
  @PUT
  @Path("/{principalRoleName}/catalog-roles/{catalogName}")
  @Consumes({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.principal-roles.assignCatalogRoleToPrincipalRole")
  @Timeout
  public Response assignCatalogRoleToPrincipalRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("principalRoleName") String principalRoleName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogName") String catalogName, @Nonnull @Valid GrantCatalogRoleRequest grantCatalogRoleRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principal-roles with params")
      .addKeyValue("operation", "assignCatalogRoleToPrincipalRole")
      .addKeyValue("principalRoleName", principalRoleName)
      .addKeyValue("catalogName", catalogName)
      .addKeyValue("grantCatalogRoleRequest", String.valueOf(grantCatalogRoleRequest))
      .log();

    Response ret =
      service.assignCatalogRoleToPrincipalRole(principalRoleName,catalogName,grantCatalogRoleRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of assignCatalogRoleToPrincipalRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Create a principal role
   *
   * Response type: {@code Void}.
   * @param createPrincipalRoleRequest Required - The principal to create
   *
   * @return 201 - Successful response
   * @return 403 - The caller does not have permission to add a principal role
   */
  @POST
  @Consumes({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.principal-roles.createPrincipalRole")
  @Timeout
  public Response createPrincipalRole( @Nonnull @Valid CreatePrincipalRoleRequest createPrincipalRoleRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principal-roles with params")
      .addKeyValue("operation", "createPrincipalRole")
      .addKeyValue("createPrincipalRoleRequest", String.valueOf(createPrincipalRoleRequest))
      .log();

    Response ret =
      service.createPrincipalRole(createPrincipalRoleRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of createPrincipalRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Remove a principal role from polaris
   *
   * Response type: {@code Void}.
   * @param principalRoleName Required - The principal role name
   *
   * @return 204 - Success, no content
   * @return 403 - The caller does not have permission to delete a principal role
   * @return 404 - The principal role does not exist
   */
  @DELETE
  @Path("/{principalRoleName}")
  @RolesAllowed("**")
  @Timed("polaris.principal-roles.deletePrincipalRole")
  @Timeout
  public Response deletePrincipalRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("principalRoleName") String principalRoleName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principal-roles with params")
      .addKeyValue("operation", "deletePrincipalRole")
      .addKeyValue("principalRoleName", principalRoleName)
      .log();

    Response ret =
      service.deletePrincipalRole(principalRoleName,realmContext,securityContext);
    LOGGER.debug("Completed execution of deletePrincipalRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Get the principal role details
   *
   * Response type: {@code PrincipalRole}.
   * @param principalRoleName Required - The principal role name
   *
   * @return 200 - The requested principal role
   * @return 403 - The caller does not have permission to get principal role details
   * @return 404 - The principal role does not exist
   */
  @GET
  @Path("/{principalRoleName}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.principal-roles.getPrincipalRole")
  @Timeout
  public Response getPrincipalRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("principalRoleName") String principalRoleName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principal-roles with params")
      .addKeyValue("operation", "getPrincipalRole")
      .addKeyValue("principalRoleName", principalRoleName)
      .log();

    Response ret =
      service.getPrincipalRole(principalRoleName,realmContext,securityContext);
    LOGGER.debug("Completed execution of getPrincipalRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * List the Principals to whom the target principal role has been assigned
   *
   * Response type: {@code Principals}.
   * @param principalRoleName Required - The principal role name
   *
   * @return 200 - List the Principals to whom the target principal role has been assigned
   * @return 403 - The caller does not have permission to list principals
   * @return 404 - The principal role does not exist
   */
  @GET
  @Path("/{principalRoleName}/principals")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.principal-roles.listAssigneePrincipalsForPrincipalRole")
  @Timeout
  public Response listAssigneePrincipalsForPrincipalRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("principalRoleName") String principalRoleName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principal-roles with params")
      .addKeyValue("operation", "listAssigneePrincipalsForPrincipalRole")
      .addKeyValue("principalRoleName", principalRoleName)
      .log();

    Response ret =
      service.listAssigneePrincipalsForPrincipalRole(principalRoleName,realmContext,securityContext);
    LOGGER.debug("Completed execution of listAssigneePrincipalsForPrincipalRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Get the catalog roles mapped to the principal role
   *
   * Response type: {@code CatalogRoles}.
   * @param principalRoleName Required - The principal role name
   * @param catalogName Required - The name of the catalog where the catalogRoles reside
   *
   * @return 200 - The list of catalog roles mapped to the principal role
   * @return 403 - The caller does not have permission to list catalog roles
   * @return 404 - The principal role does not exist
   */
  @GET
  @Path("/{principalRoleName}/catalog-roles/{catalogName}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.principal-roles.listCatalogRolesForPrincipalRole")
  @Timeout
  public Response listCatalogRolesForPrincipalRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("principalRoleName") String principalRoleName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogName") String catalogName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principal-roles with params")
      .addKeyValue("operation", "listCatalogRolesForPrincipalRole")
      .addKeyValue("principalRoleName", principalRoleName)
      .addKeyValue("catalogName", catalogName)
      .log();

    Response ret =
      service.listCatalogRolesForPrincipalRole(principalRoleName,catalogName,realmContext,securityContext);
    LOGGER.debug("Completed execution of listCatalogRolesForPrincipalRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * List the principal roles
   *
   * Response type: {@code PrincipalRoles}.
   *
   * @return 200 - List of principal roles
   * @return 403 - The caller does not have permission to list principal roles
   * @return 404 - The catalog does not exist
   */
  @GET
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.principal-roles.listPrincipalRoles")
  @Timeout
  public Response listPrincipalRoles(@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principal-roles with params")
      .addKeyValue("operation", "listPrincipalRoles")
      .log();

    Response ret =
      service.listPrincipalRoles(realmContext,securityContext);
    LOGGER.debug("Completed execution of listPrincipalRoles API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Remove a catalog role from a principal role
   *
   * Response type: {@code Void}.
   * @param principalRoleName Required - The principal role name
   * @param catalogName Required - The name of the catalog that contains the role to revoke
   * @param catalogRoleName Required - The name of the catalog role that should be revoked
   *
   * @return 204 - Success, no content
   * @return 403 - The caller does not have permission to revoke a catalog role
   * @return 404 - The principal role does not exist
   */
  @DELETE
  @Path("/{principalRoleName}/catalog-roles/{catalogName}/{catalogRoleName}")
  @RolesAllowed("**")
  @Timed("polaris.principal-roles.revokeCatalogRoleFromPrincipalRole")
  @Timeout
  public Response revokeCatalogRoleFromPrincipalRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("principalRoleName") String principalRoleName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogName") String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("catalogRoleName") String catalogRoleName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principal-roles with params")
      .addKeyValue("operation", "revokeCatalogRoleFromPrincipalRole")
      .addKeyValue("principalRoleName", principalRoleName)
      .addKeyValue("catalogName", catalogName)
      .addKeyValue("catalogRoleName", catalogRoleName)
      .log();

    Response ret =
      service.revokeCatalogRoleFromPrincipalRole(principalRoleName,catalogName,catalogRoleName,realmContext,securityContext);
    LOGGER.debug("Completed execution of revokeCatalogRoleFromPrincipalRole API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Update an existing principalRole
   *
   * Response type: {@code PrincipalRole}.
   * @param principalRoleName Required - The principal role name
   * @param updatePrincipalRoleRequest Required - The principalRole details to use in the update
   *
   * @return 200 - The updated principal role
   * @return 403 - The caller does not have permission to update principal role details
   * @return 404 - The principal role does not exist
   * @return 409 - The entity version doesn't match the currentEntityVersion; retry after fetching latest version
   */
  @PUT
  @Path("/{principalRoleName}")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.principal-roles.updatePrincipalRole")
  @Timeout
  public Response updatePrincipalRole( @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256) @PathParam("principalRoleName") String principalRoleName, @Nonnull @Valid UpdatePrincipalRoleRequest updatePrincipalRoleRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking principal-roles with params")
      .addKeyValue("operation", "updatePrincipalRole")
      .addKeyValue("principalRoleName", principalRoleName)
      .addKeyValue("updatePrincipalRoleRequest", String.valueOf(updatePrincipalRoleRequest))
      .log();

    Response ret =
      service.updatePrincipalRole(principalRoleName,updatePrincipalRoleRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of updatePrincipalRole API with status code {}", ret.getStatus());
    return ret;
  }
}
