/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.admin.model.StorageConfigInfo;

@ApiModel(description="aws storage configuration info")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AwsStorageConfigInfo
extends StorageConfigInfo {
    private final String roleArn;
    private final String externalId;
    private final String userArn;
    private final String region;
    private final String endpoint;
    private final String stsEndpoint;
    private final Boolean pathStyleAccess;

    @ApiModelProperty(example="arn:aws:iam::123456789001:principal/abc1-b-self1234", value="the aws role arn that grants privileges on the S3 buckets")
    @JsonProperty(value="roleArn")
    public String getRoleArn() {
        return this.roleArn;
    }

    @ApiModelProperty(value="an optional external id used to establish a trust relationship with AWS in the trust policy")
    @JsonProperty(value="externalId")
    public String getExternalId() {
        return this.externalId;
    }

    @ApiModelProperty(example="arn:aws:iam::123456789001:user/abc1-b-self1234", value="the aws user arn used to assume the aws role")
    @JsonProperty(value="userArn")
    public String getUserArn() {
        return this.userArn;
    }

    @ApiModelProperty(example="us-east-2", value="the aws region where data is stored")
    @JsonProperty(value="region")
    public String getRegion() {
        return this.region;
    }

    @ApiModelProperty(example="https://s3.example.com:1234", value="endpoint for S3 requests (optional)")
    @JsonProperty(value="endpoint")
    public String getEndpoint() {
        return this.endpoint;
    }

    @ApiModelProperty(example="https://sts.example.com:1234", value="endpoint for STS requests (optional). If not set, defaults to 'endpoint'.")
    @JsonProperty(value="stsEndpoint")
    public String getStsEndpoint() {
        return this.stsEndpoint;
    }

    @ApiModelProperty(example="true", value="Whether S3 requests to files in this catalog should use 'path-style addressing for buckets'.")
    @JsonProperty(value="pathStyleAccess")
    public Boolean getPathStyleAccess() {
        return this.pathStyleAccess;
    }

    @JsonCreator
    public AwsStorageConfigInfo(@JsonProperty(value="roleArn") String roleArn, @JsonProperty(value="externalId") String externalId, @JsonProperty(value="userArn") String userArn, @JsonProperty(value="region") String region, @JsonProperty(value="endpoint") String endpoint, @JsonProperty(value="stsEndpoint") String stsEndpoint, @JsonProperty(value="pathStyleAccess") Boolean pathStyleAccess, @JsonProperty(value="storageType", required=true) StorageConfigInfo.StorageTypeEnum storageType, @JsonProperty(value="allowedLocations") List<String> allowedLocations) {
        super(storageType, allowedLocations);
        this.roleArn = roleArn;
        this.externalId = externalId;
        this.userArn = userArn;
        this.region = region;
        this.endpoint = endpoint;
        this.stsEndpoint = stsEndpoint;
        this.pathStyleAccess = Objects.requireNonNullElse(pathStyleAccess, false);
    }

    public AwsStorageConfigInfo(StorageConfigInfo.StorageTypeEnum storageType) {
        super(storageType);
        this.roleArn = null;
        this.externalId = null;
        this.userArn = null;
        this.region = null;
        this.endpoint = null;
        this.stsEndpoint = null;
        this.pathStyleAccess = false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StorageConfigInfo.StorageTypeEnum storageType) {
        return new Builder(storageType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsStorageConfigInfo awsStorageConfigInfo = (AwsStorageConfigInfo)o;
        return super.equals(o) && Objects.equals(this.roleArn, awsStorageConfigInfo.roleArn) && Objects.equals(this.externalId, awsStorageConfigInfo.externalId) && Objects.equals(this.userArn, awsStorageConfigInfo.userArn) && Objects.equals(this.region, awsStorageConfigInfo.region) && Objects.equals(this.endpoint, awsStorageConfigInfo.endpoint) && Objects.equals(this.stsEndpoint, awsStorageConfigInfo.stsEndpoint) && Objects.equals(this.pathStyleAccess, awsStorageConfigInfo.pathStyleAccess);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.roleArn, super.hashCode(), this.externalId, super.hashCode(), this.userArn, super.hashCode(), this.region, super.hashCode(), this.endpoint, super.hashCode(), this.stsEndpoint, super.hashCode(), this.pathStyleAccess);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AwsStorageConfigInfo {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    roleArn: ").append(this.toIndentedString(this.roleArn)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    userArn: ").append(this.toIndentedString(this.userArn)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    endpoint: ").append(this.toIndentedString(this.endpoint)).append("\n");
        sb.append("    stsEndpoint: ").append(this.toIndentedString(this.stsEndpoint)).append("\n");
        sb.append("    pathStyleAccess: ").append(this.toIndentedString(this.pathStyleAccess)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String roleArn;
        private String externalId;
        private String userArn;
        private String region;
        private String endpoint;
        private String stsEndpoint;
        private Boolean pathStyleAccess;
        private StorageConfigInfo.StorageTypeEnum storageType;
        private List<String> allowedLocations;

        private Builder() {
        }

        private Builder(StorageConfigInfo.StorageTypeEnum storageType) {
            this.storageType = storageType;
        }

        public Builder setRoleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public Builder setExternalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder setUserArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setStsEndpoint(String stsEndpoint) {
            this.stsEndpoint = stsEndpoint;
            return this;
        }

        public Builder setPathStyleAccess(Boolean pathStyleAccess) {
            this.pathStyleAccess = pathStyleAccess;
            return this;
        }

        public Builder setStorageType(StorageConfigInfo.StorageTypeEnum storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder setAllowedLocations(List<String> allowedLocations) {
            this.allowedLocations = allowedLocations;
            return this;
        }

        public AwsStorageConfigInfo build() {
            AwsStorageConfigInfo inst = new AwsStorageConfigInfo(this.roleArn, this.externalId, this.userArn, this.region, this.endpoint, this.stsEndpoint, this.pathStyleAccess, this.storageType, this.allowedLocations);
            return inst;
        }
    }
}

