package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="A storage configuration used by catalogs")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.EXISTING_PROPERTY,
    property = "storageType",
    visible = true
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = AzureStorageConfigInfo.class, name = "AZURE"),
    @JsonSubTypes.Type(value = FileStorageConfigInfo.class, name = "FILE"),
    @JsonSubTypes.Type(value = GcpStorageConfigInfo.class, name = "GCS"),
    @JsonSubTypes.Type(value = MfsStorageConfigInfo.class, name = "MFS"),
    @JsonSubTypes.Type(value = AwsStorageConfigInfo.class, name = "S3")
})public class StorageConfigInfo   {

      /**
   * The cloud provider type this storage is built on. FILE is supported for testing purposes only
   */
  public enum StorageTypeEnum {
    S3("S3"),

        GCS("GCS"),

        AZURE("AZURE"),

        FILE("FILE"),

        MFS("MFS");
    private String value;

    StorageTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }
  }

  @NotNull
  private final StorageTypeEnum storageType;
  private final List<String> allowedLocations;
    /**
     * The cloud provider type this storage is built on. FILE is supported for testing purposes only
     **/
    @ApiModelProperty(required = true, value = "The cloud provider type this storage is built on. FILE is supported for testing purposes only")
    @JsonProperty(value = "storageType", required = true)
    public StorageTypeEnum getStorageType() {
        return storageType;
    }
    
    /**
     **/
    @ApiModelProperty(example = "For AWS [s3://bucketname/prefix/], for AZURE [abfss://container@storageaccount.blob.core.windows.net/prefix/], for GCP [gs://bucketname/prefix/]", value = "")
    @JsonProperty(value = "allowedLocations")
    public List<String> getAllowedLocations() {
        return allowedLocations;
    }
    
    @JsonCreator
    public StorageConfigInfo(@JsonProperty(value = "storageType", required = true) StorageTypeEnum storageType, @JsonProperty(value = "allowedLocations") List<String> allowedLocations) {
        this.storageType = storageType;
        this.allowedLocations = Objects.requireNonNullElse(allowedLocations, new ArrayList<>());
    }


    public StorageConfigInfo(StorageTypeEnum storageType) {
        this.storageType = storageType;
        this.allowedLocations = new ArrayList<>();
    }



    public static final class Builder {
      private StorageTypeEnum storageType;
      private List<String> allowedLocations;
      private Builder() {
      }
      private Builder(StorageTypeEnum storageType) {
        this.storageType = storageType;
      }

      public Builder setStorageType(StorageTypeEnum storageType) {
        this.storageType = storageType;
        return this;
      }
      public Builder setAllowedLocations(List<String> allowedLocations) {
        this.allowedLocations = allowedLocations;
        return this;
      }


      public StorageConfigInfo build() {
        StorageConfigInfo inst = new StorageConfigInfo(storageType, allowedLocations);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StorageConfigInfo storageConfigInfo = (StorageConfigInfo) o;
    return Objects.equals(this.storageType, storageConfigInfo.storageType) &&
        Objects.equals(this.allowedLocations, storageConfigInfo.allowedLocations);
  }

  @Override
  public int hashCode() {
    return Objects.hash(storageType, allowedLocations);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StorageConfigInfo {\n");
    
    sb.append("    storageType: ").append(toIndentedString(storageType)).append("\n");
    sb.append("    allowedLocations: ").append(toIndentedString(allowedLocations)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
