package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")public class PrincipalRole   {

  @NotNull
 @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1,max=256)  private final String name;
  private final Boolean federated;
  private final Map<String, String> properties;
  private final Long createTimestamp;
  private final Long lastUpdateTimestamp;
  private final Integer entityVersion;
    /**
     * The name of the role
     **/
    @ApiModelProperty(required = true, value = "The name of the role")
    @JsonProperty(value = "name", required = true)
    public String getName() {
        return name;
    }
    
    /**
     * Whether the principal role is a federated role (that is, managed by an external identity provider)
     **/
    @ApiModelProperty(value = "Whether the principal role is a federated role (that is, managed by an external identity provider)")
    @JsonProperty(value = "federated")
    public Boolean getFederated() {
        return federated;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "properties")
    public Map<String, String> getProperties() {
        return properties;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "createTimestamp")
    public Long getCreateTimestamp() {
        return createTimestamp;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "lastUpdateTimestamp")
    public Long getLastUpdateTimestamp() {
        return lastUpdateTimestamp;
    }
    
    /**
     * The version of the principal role object used to determine if the principal role metadata has changed
     **/
    @ApiModelProperty(value = "The version of the principal role object used to determine if the principal role metadata has changed")
    @JsonProperty(value = "entityVersion")
    public Integer getEntityVersion() {
        return entityVersion;
    }
    
    @JsonCreator
    public PrincipalRole(@JsonProperty(value = "name", required = true) String name, @JsonProperty(value = "federated") Boolean federated, @JsonProperty(value = "properties") Map<String, String> properties, @JsonProperty(value = "createTimestamp") Long createTimestamp, @JsonProperty(value = "lastUpdateTimestamp") Long lastUpdateTimestamp, @JsonProperty(value = "entityVersion") Integer entityVersion) {
        this.name = name;
        this.federated = Objects.requireNonNullElse(federated, false);
        this.properties = Objects.requireNonNullElse(properties, new HashMap<>());
        this.createTimestamp = createTimestamp;
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        this.entityVersion = entityVersion;
    }


    public PrincipalRole(String name) {
        this.name = name;
        this.federated = false;
        this.properties = new HashMap<>();
        this.createTimestamp = null;
        this.lastUpdateTimestamp = null;
        this.entityVersion = null;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(String name) {
        return new Builder(name);
    }


    public static final class Builder {
      private String name;
      private Boolean federated;
      private Map<String, String> properties;
      private Long createTimestamp;
      private Long lastUpdateTimestamp;
      private Integer entityVersion;
      private Builder() {
      }
      private Builder(String name) {
        this.name = name;
      }

      public Builder setName(String name) {
        this.name = name;
        return this;
      }
      public Builder setFederated(Boolean federated) {
        this.federated = federated;
        return this;
      }
      public Builder setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
      }
      public Builder setCreateTimestamp(Long createTimestamp) {
        this.createTimestamp = createTimestamp;
        return this;
      }
      public Builder setLastUpdateTimestamp(Long lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        return this;
      }
      public Builder setEntityVersion(Integer entityVersion) {
        this.entityVersion = entityVersion;
        return this;
      }


      public PrincipalRole build() {
        PrincipalRole inst = new PrincipalRole(name, federated, properties, createTimestamp, lastUpdateTimestamp, entityVersion);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrincipalRole principalRole = (PrincipalRole) o;
    return Objects.equals(this.name, principalRole.name) &&
        Objects.equals(this.federated, principalRole.federated) &&
        Objects.equals(this.properties, principalRole.properties) &&
        Objects.equals(this.createTimestamp, principalRole.createTimestamp) &&
        Objects.equals(this.lastUpdateTimestamp, principalRole.lastUpdateTimestamp) &&
        Objects.equals(this.entityVersion, principalRole.entityVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, federated, properties, createTimestamp, lastUpdateTimestamp, entityVersion);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrincipalRole {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    federated: ").append(toIndentedString(federated)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    createTimestamp: ").append(toIndentedString(createTimestamp)).append("\n");
    sb.append("    lastUpdateTimestamp: ").append(toIndentedString(lastUpdateTimestamp)).append("\n");
    sb.append("    entityVersion: ").append(toIndentedString(entityVersion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
