package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.NamespacePrivilege;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")public class NamespaceGrant extends GrantResource  {

  @NotNull
  private final List<String> namespace;
  @NotNull
  @Valid
  private final NamespacePrivilege privilege;
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "namespace", required = true)
    public List<String> getNamespace() {
        return namespace;
    }
    
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "privilege", required = true)
    public NamespacePrivilege getPrivilege() {
        return privilege;
    }
    
    @JsonCreator
    public NamespaceGrant(@JsonProperty(value = "namespace", required = true) List<String> namespace, @JsonProperty(value = "privilege", required = true) NamespacePrivilege privilege, @JsonProperty(value = "type", required = true) TypeEnum type) {
        super(type);
        this.namespace = Objects.requireNonNullElse(namespace, new ArrayList<>());
        this.privilege = privilege;
    }



    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(List<String> namespace, NamespacePrivilege privilege, TypeEnum type) {
        return new Builder(namespace, privilege, type);
    }


    public static final class Builder {
      private List<String> namespace;
      private NamespacePrivilege privilege;
      private TypeEnum type;
      private Builder() {
      }
      private Builder(List<String> namespace, NamespacePrivilege privilege, TypeEnum type) {
        this.namespace = Objects.requireNonNullElse(namespace, new ArrayList<>());
        this.privilege = privilege;
        this.type = type;
      }

      public Builder setNamespace(List<String> namespace) {
        this.namespace = namespace;
        return this;
      }
      public Builder setPrivilege(NamespacePrivilege privilege) {
        this.privilege = privilege;
        return this;
      }
      public Builder setType(TypeEnum type) {
        this.type = type;
        return this;
      }


      public NamespaceGrant build() {
        NamespaceGrant inst = new NamespaceGrant(namespace, privilege, type);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NamespaceGrant namespaceGrant = (NamespaceGrant) o;
    return super.equals(o) && Objects.equals(this.namespace, namespaceGrant.namespace) &&
        Objects.equals(this.privilege, namespaceGrant.privilege);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), namespace, super.hashCode(), privilege);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NamespaceGrant {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    namespace: ").append(toIndentedString(namespace)).append("\n");
    sb.append("    privilege: ").append(toIndentedString(privilege)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
