package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import org.apache.polaris.core.admin.model.ServiceIdentityInfo;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="A connection configuration representing a remote catalog service. IMPORTANT - Specifying a ConnectionConfigInfo in an ExternalCatalog is currently an experimental API and is subject to change.")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.EXISTING_PROPERTY,
    property = "connectionType",
    visible = true
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = HadoopConnectionConfigInfo.class, name = "HADOOP"),
    @JsonSubTypes.Type(value = IcebergRestConnectionConfigInfo.class, name = "ICEBERG_REST")
})public class ConnectionConfigInfo   {

      /**
   * The type of remote catalog service represented by this connection
   */
  public enum ConnectionTypeEnum {
    ICEBERG_REST("ICEBERG_REST"),

        HADOOP("HADOOP");
    private String value;

    ConnectionTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }
  }

  @NotNull
  private final ConnectionTypeEnum connectionType;
  private final String uri;
  @Valid
  private final AuthenticationParameters authenticationParameters;
  @Valid
  private final ServiceIdentityInfo serviceIdentity;
    /**
     * The type of remote catalog service represented by this connection
     **/
    @ApiModelProperty(required = true, value = "The type of remote catalog service represented by this connection")
    @JsonProperty(value = "connectionType", required = true)
    public ConnectionTypeEnum getConnectionType() {
        return connectionType;
    }
    
    /**
     * URI to the remote catalog service
     **/
    @ApiModelProperty(value = "URI to the remote catalog service")
    @JsonProperty(value = "uri")
    public String getUri() {
        return uri;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "authenticationParameters")
    public AuthenticationParameters getAuthenticationParameters() {
        return authenticationParameters;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "serviceIdentity")
    public ServiceIdentityInfo getServiceIdentity() {
        return serviceIdentity;
    }
    
    @JsonCreator
    public ConnectionConfigInfo(@JsonProperty(value = "connectionType", required = true) ConnectionTypeEnum connectionType, @JsonProperty(value = "uri") String uri, @JsonProperty(value = "authenticationParameters") AuthenticationParameters authenticationParameters, @JsonProperty(value = "serviceIdentity") ServiceIdentityInfo serviceIdentity) {
        this.connectionType = connectionType;
        this.uri = uri;
        this.authenticationParameters = authenticationParameters;
        this.serviceIdentity = serviceIdentity;
    }


    public ConnectionConfigInfo(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
        this.uri = null;
        this.authenticationParameters = null;
        this.serviceIdentity = null;
    }



    public static final class Builder {
      private ConnectionTypeEnum connectionType;
      private String uri;
      private AuthenticationParameters authenticationParameters;
      private ServiceIdentityInfo serviceIdentity;
      private Builder() {
      }
      private Builder(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
      }

      public Builder setConnectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
        return this;
      }
      public Builder setUri(String uri) {
        this.uri = uri;
        return this;
      }
      public Builder setAuthenticationParameters(AuthenticationParameters authenticationParameters) {
        this.authenticationParameters = authenticationParameters;
        return this;
      }
      public Builder setServiceIdentity(ServiceIdentityInfo serviceIdentity) {
        this.serviceIdentity = serviceIdentity;
        return this;
      }


      public ConnectionConfigInfo build() {
        ConnectionConfigInfo inst = new ConnectionConfigInfo(connectionType, uri, authenticationParameters, serviceIdentity);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConnectionConfigInfo connectionConfigInfo = (ConnectionConfigInfo) o;
    return Objects.equals(this.connectionType, connectionConfigInfo.connectionType) &&
        Objects.equals(this.uri, connectionConfigInfo.uri) &&
        Objects.equals(this.authenticationParameters, connectionConfigInfo.authenticationParameters) &&
        Objects.equals(this.serviceIdentity, connectionConfigInfo.serviceIdentity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(connectionType, uri, authenticationParameters, serviceIdentity);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConnectionConfigInfo {\n");
    
    sb.append("    connectionType: ").append(toIndentedString(connectionType)).append("\n");
    sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
    sb.append("    authenticationParameters: ").append(toIndentedString(authenticationParameters)).append("\n");
    sb.append("    serviceIdentity: ").append(toIndentedString(serviceIdentity)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
