package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.polaris.core.admin.model.Catalog;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="A list of Catalog objects")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")public class Catalogs   {

  @NotNull
  @Valid
  private final List<@Valid Catalog> catalogs;
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "catalogs", required = true)
    public List<@Valid Catalog> getCatalogs() {
        return catalogs;
    }
    
    @JsonCreator
    public Catalogs(@JsonProperty(value = "catalogs", required = true) List<@Valid Catalog> catalogs) {
        this.catalogs = Objects.requireNonNullElse(catalogs, new ArrayList<>());
    }



    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(List<@Valid Catalog> catalogs) {
        return new Builder(catalogs);
    }


    public static final class Builder {
      private List<@Valid Catalog> catalogs;
      private Builder() {
      }
      private Builder(List<@Valid Catalog> catalogs) {
        this.catalogs = Objects.requireNonNullElse(catalogs, new ArrayList<>());
      }

      public Builder setCatalogs(List<@Valid Catalog> catalogs) {
        this.catalogs = catalogs;
        return this;
      }


      public Catalogs build() {
        Catalogs inst = new Catalogs(catalogs);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Catalogs catalogs = (Catalogs) o;
    return Objects.equals(this.catalogs, catalogs.catalogs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(catalogs);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Catalogs {\n");
    
    sb.append("    catalogs: ").append(toIndentedString(catalogs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
